      PARAMETER ( N = 100)
      PARAMETER ( M = 50)
      REAL     PHI(M+1,N+1)
     *       , WAVENUM , DELTAY , PI , TAUR , TAUI , WIDTH , XL
     *       , XGRD(2) , YGRD(2) , VMAX
     *       , PHIR(N+1) , YP(N+1) , CYC(2)
      COMPLEX  CPHI(N+1) , COEFFA , COEFFB , COEFFC , COEFFD
     *       , UIMAG , C
      INTEGER  JX , JY , JM
     *       , IPAT , NC , JCRT , JSIZE , NDOT
      DATA IPAT/Z'0000FFF0'/
      DATA CYC/2, 2/
*
      UIMAG   = ( 0.0 , 1.0 )
      PI      = 3.1416
      WIDTH   = 8.0
*
*
      CALL PLSTRT ( 20.0 , 20.0 , 'NLP1' )
*
*
*
      WAVENUM = 0.50
      CR = 0.0
      CI = SQRT(-(( 1.0 - WAVENUM*2 )**2 - EXP(-WAVENUM*4)))
     +     / (WAVENUM*2)
      C  = CR + UIMAG * CI
      COEFFC = 1.0
      COEFFB = ( WAVENUM * 2 * ( 1 - C ) - 1 ) * EXP(WAVENUM*2)
      COEFFA = COEFFB * EXP(-WAVENUM) + COEFFC * EXP(WAVENUM)
      COEFFD = COEFFB * EXP(WAVENUM) + COEFFC * EXP(-WAVENUM)
*
      DELTAY  = WIDTH / FLOAT(N)
*
      XL      = 2.0 * PI / WAVENUM
      XGRD(1) =   0.0
      XGRD(2) =   XL
      YGRD(1) = - WIDTH * 0.5
      YGRD(2) =   WIDTH * 0.5
*
      DO 110 JY = 1 , N+1
        YP(JY)   = (REAL(JY-1)/REAL(N)-0.5)*WIDTH
        IF(YP(JY).LE.-1.0) THEN
          CPHI(JY) = COEFFD * EXP(WAVENUM*(YP(JY)+1.0))
        ELSEIF(YP(JY).GE.1.0) THEN
          CPHI(JY) = COEFFA * EXP(-WAVENUM*(YP(JY)-1.0))
        ELSE
          CPHI(JY) = COEFFB * EXP(-WAVENUM*YP(JY))
     +             + COEFFC * EXP(WAVENUM*YP(JY))
        ENDIF
 110  CONTINUE
*
      VMAX = 0.0
      DO 120 JY = 1 , N+1
        IF ( ABS(CPHI(JY)).GT.VMAX ) THEN
          VMAX = ABS(CPHI(JY))
        ENDIF
 120  CONTINUE
*
      DO 130 JY = 1 , N+1
        CPHI(JY) = CPHI(JY) / VMAX
        PHIR(JY) = ABS(CPHI(JY))
 130  CONTINUE
*
      DO 140 JX = 1 , M+1
        DO 150 JY = 1 , N+1
          PHI(JX,JY) = REAL(CPHI(JY) * UIMAG
     +               * EXP(UIMAG*FLOAT(JX-1)/FLOAT(M)*2*PI))
 150    CONTINUE
 140  CONTINUE
*
        XSTR = 0.25
        XEND = 0.35
        YSTR = 0.65
        YEND = 0.85
*
      CALL SET ( XSTR, XEND, YSTR, YEND, 0.0 , 1.0
     *         , -WIDTH*0.5, WIDTH*0.5 , 1 )
      CALL OPTN ( 'INTN' , 'LOW ' )
      CALL PCURVE ( PHIR , YP , N+1)
      CALL PWRIT  ( 1.15 , 0.0 , '|o|'  , 3 , 12 , 0 , 0 )
      CALL PWRIT  ( 1.15 , 0.0 , '/'    , 1 , 12 , 0 , 0 )
      CALL PWRIT  (-0.12 , 0.0 , ' 0.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  (-0.12 , WIDTH*0.50 , ' 4.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  (-0.12 ,-WIDTH*0.50 , '-4.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  ( 0.00 , WIDTH*0.60 , 'y'    , 1 , 16 , 0 , 1 )
      CALL PGRIDA (  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  1 ,  1 ,  0 ,  0 )
*
        XSTR = 0.40
        XEND = XSTR + (YEND - YSTR) / WIDTH * XL
      CALL SET ( XSTR, XEND, YSTR, YEND
     *         ,  0.0 , XL , -WIDTH*0.5 , WIDTH*0.5 , 1 )
      CALL PGRIDA (  0 ,  0 ,  0 ,  0 ,  1 ,  1 ,  0 ,  0 ,  0 ,  0 )
      CALL CONOPT ( -9 , -9 , 1 )
      CALL CONGRD ( PHI , M+1 , M+1 , N+1
     *            , -1.0 , 1.0 , 0.1 , 1 , -1 , -IPAT
     *            , -1 , XGRD , YGRD )
      CALL PWRIT  ( XL*0.70, WIDTH*0.64, 'k=     ', 7 , 12 , 0 , 1 )
      CALL PNUMBR ( XL*0.70, WIDTH*0.64, WAVENUM, 4, 6H(F4.2), 12, 0, 1)
      CALL PWRIT  ( XL*0.50, WIDTH*0.56, ' C =        ',12, 12, 0, -1)
      CALL PWRIT  ( XL*0.50, WIDTH*0.56, '           i', 12, 12, 0 ,-1)
      CALL PNUMBR ( XL*0.57, WIDTH*0.56, CI, 10, 6H(F8.4), 12, 0,-1)
*
      DO 510 JM = 1 , 2
*
      WAVENUM = 1.00
      IF (JM.EQ.1) THEN
        CR =   SQRT((( 1.0 - WAVENUM*2 )**2 - EXP(-WAVENUM*4)))
     +       / (WAVENUM*2)
      ELSE
        CR = - SQRT((( 1.0 - WAVENUM*2 )**2 - EXP(-WAVENUM*4)))
     +       / (WAVENUM*2)
      ENDIF
      CI = 0.0
      C  = CR + UIMAG * CI
      COEFFC = 1.0
      COEFFB = ( WAVENUM * 2 * ( 1 - C ) - 1 ) * EXP(WAVENUM*2)
      COEFFA = COEFFB * EXP(-WAVENUM) + COEFFC * EXP(WAVENUM)
      COEFFD = COEFFB * EXP(WAVENUM) + COEFFC * EXP(-WAVENUM)
*
      DELTAY  = WIDTH / FLOAT(N)
*
      XL      = 2.0 * PI / WAVENUM * CYC(JM)
      XGRD(1) =   0.0
      XGRD(2) =   XL
      YGRD(1) = - WIDTH * 0.5
      YGRD(2) =   WIDTH * 0.5
*
      DO 10 JY = 1 , N+1
        YP(JY)   = (REAL(JY-1)/REAL(N)-0.5)*WIDTH
        IF(YP(JY).LE.-1.0) THEN
          CPHI(JY) = COEFFD * EXP(WAVENUM*(YP(JY)+1.0))
        ELSEIF(YP(JY).GE.1.0) THEN
          CPHI(JY) = COEFFA * EXP(-WAVENUM*(YP(JY)-1.0))
        ELSE
          CPHI(JY) = COEFFB * EXP(-WAVENUM*YP(JY))
     +             + COEFFC * EXP(WAVENUM*YP(JY))
        ENDIF
 10   CONTINUE
*
      VMAX = 0.0
      DO 20 JY = 1 , N+1
        IF ( ABS(CPHI(JY)).GT.VMAX ) THEN
          VMAX = ABS(CPHI(JY))
        ENDIF
 20   CONTINUE
*
      DO 30 JY = 1 , N+1
        CPHI(JY) = CPHI(JY) / VMAX
        PHIR(JY) = ABS(CPHI(JY))
 30   CONTINUE
*
      DO 40 JX = 1 , M+1
        DO 50 JY = 1 , N+1
          PHI(JX,JY) = REAL(CPHI(JY) * UIMAG
     +               * EXP(UIMAG*FLOAT(JX-1)/FLOAT(M)*2*PI*CYC(JM)))
 50     CONTINUE
 40   CONTINUE
*
        XSTR = 0.25
        XEND = 0.35
      IF (JM.EQ.1) THEN
        YSTR = 0.40
        YEND = 0.60
      ELSE
        YSTR = 0.15
        YEND = 0.35
      ENDIF
*
      CALL SET ( XSTR, XEND, YSTR, YEND, 0.0 , 1.0
     *         , -WIDTH*0.5, WIDTH*0.5 , 1 )
      CALL OPTN ( 'INTN' , 'LOW ' )
      CALL PCURVE ( PHIR , YP , N+1)
      CALL PWRIT  ( 1.15 , 0.0 , '|o|'  , 3 , 12 , 0 , 0 )
      CALL PWRIT  ( 1.15 , 0.0 , '/'    , 1 , 12 , 0 , 0 )
      CALL PWRIT  (-0.12 , 0.0 , ' 0.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  (-0.12 , WIDTH*0.50 , ' 4.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  (-0.12 ,-WIDTH*0.50 , '-4.0' , 4 , 12 , 0 , 1 )
      CALL PWRIT  ( 0.00 , WIDTH*0.60 , 'y'    , 1 , 16 , 0 , 1 )
      CALL PGRIDA (  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  1 ,  1 ,  0 ,  0 )
*
        XSTR = 0.40
        XEND = XSTR + (YEND - YSTR) / WIDTH * XL
      CALL SET ( XSTR, XEND, YSTR, YEND
     *         ,  0.0 , XL , -WIDTH*0.5 , WIDTH*0.5 , 1 )
      CALL PGRIDA (  0 ,  0 ,  0 ,  0 ,  1 ,  1 ,  0 ,  0 ,  0 ,  0 )
      CALL CONOPT ( -9 , -9 , 1 )
      CALL CONGRD ( PHI , M+1 , M+1 , N+1
     *            , -1.0 , 1.0 , 0.1 , 1 , -1 , -IPAT
     *            , -1 , XGRD , YGRD )
      CALL PWRIT  ( XL*0.70, WIDTH*0.64, 'k=     ', 7 , 12 , 0 , 1 )
      CALL PNUMBR ( XL*0.70, WIDTH*0.64, WAVENUM, 4, 6H(F4.2), 12, 0, 1)
      CALL PWRIT  ( XL*0.50, WIDTH*0.56, ' C =        ',12, 12, 0, -1)
      CALL PNUMBR ( XL*0.65, WIDTH*0.56, CR, 10, 6H(F8.4), 12, 0,-1)
*
 510  CONTINUE
*
      CALL PLFIN
      STOP
      END
