!= dcpam ϵ絤ͥǥ Ver. 2
!
!= dcpam radiation model for the Earth's atmosphere Ver. 2
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: radiation_dcpam_E_V2.f90,v 1.3 2011-02-21 12:15:37 yot Exp $
! Tag Name::  $Name: dcpam5-20110228-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module radiation_dcpam_E_V2
  !
  != dcpam ϵ絤ͥǥ Ver. 2
  !
  != dcpam radiation model for the Earth's atmosphere Ver. 1
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ϵ絤ͥǥ.
  !
  ! This is a radiation model for the Earth's atmospehre.
  !
  ! Radiation in the wavenumber range from    0 to  3000 cm-1 
  ! is calculated in the routine of long wave radiation. 
  ! Radiation in the wavenumber range from 1000 to 57143 cm-1 (0.175 to 10 micron) 
  ! is calculated in the routine of shortwave radiation. 
  !
  !== References
  !
  !
  !== Procedures List
  !
  ! RadiationDcpamEV2Flux :: ͥեåη׻
  ! ------------          :: ------------
  ! RadiationDcpamEV2Flux :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#radiation_dcpam_E_V2_nml
  !

  ! USE statements
  !

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ.
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ.
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ.
                             ! Number of vertical level

  implicit none

  private

  real(DP), allocatable, save :: xyz_QO3(:,:,:)
                              ! O3 ʬ (1)
                              ! O3 distribution (1)

!!$  integer , save              :: SWVer
!!$  integer , save              :: LWVer

  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_dcpam_E_V2_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  public :: RadiationDcpamEV2Flux

  character(*), parameter:: module_name = 'radiation_dcpam_E_V2'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110228-4 $' // &
    & '$Id: radiation_dcpam_E_V2.f90,v 1.3 2011-02-21 12:15:37 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine RadiationDcpamEV2Flux(                                 &
    & xy_SurfAlbedo,                                                &
    & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QH2OLiq,     &
    & xyz_Height, xy_SurfTemp,                                      &
    & xyr_RadSFlux, xyr_RadLFlux, xyra_DelRadLFlux                  &
    & )


    ! USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! O3 ʬۤ
    ! Set O3 distribution
    !
    use set_o3, only: SetO3

!!$    ! dcpam ϵ絤ûͥǥ Ver. 2
!!$    ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2
!!$    !
!!$    use radiation_dcpam_E_SW_V2, only: RadiationDcpamESWV2Flux

    ! dcpam ϵ絤ûͥǥ Ver. 2.1
    ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2.1
    !
    use radiation_dcpam_E_SW_V2_1, only: RadiationDcpamESWV21Flux

!!$    ! dcpam ϵ絤Ĺͥǥ Ver. 2
!!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2
!!$    !
!!$    use radiation_dcpam_E_LW_V2, only : RadiationDcpamELWV2Flux
!!$
!!$    ! dcpam ϵ絤Ĺͥǥ Ver. 2.1
!!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.1
!!$    !
!!$    use radiation_dcpam_E_LW_V2_1, only : RadiationDcpamELWV21Flux
!!$
!!$    ! dcpam ϵ絤Ĺͥǥ Ver. 2.2
!!$    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.2
!!$    !
!!$    use radiation_dcpam_E_LW_V2_2, only : RadiationDcpamELWV22Flux

    ! dcpam ϵ絤Ĺͥǥ Ver. 2.3
    ! dcpam long wave radiation model for the Earth's atmosphere Ver. 2.3
    !
    use radiation_dcpam_E_LW_V2_3, only : RadiationDcpamELWV23Flux

    real(DP), intent(in ) :: xy_SurfAlbedo   (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_QH2OVap     (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   . Mass mixing ratio of constituents (1)
    real(DP), intent(in ) :: xyz_QH2OLiq     (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_Height      (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xy_SurfTemp     (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xyr_RadSFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyr_RadLFlux    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(out) :: xyra_DelRadLFlux(0:imax-1, 1:jmax, 0:kmax, 0:1)


    ! Work variables
    !
    real(DP) :: xyz_QH2OSol(0:imax-1, 1:jmax, 1:kmax)


    ! Amount of water ice is assumed to be zero, for the moment.
    ! In future, this value will be an argument of this subroutine.
    !
    xyz_QH2OSol = 0.0_DP


    ! 
    ! Initialization
    !
    if ( .not. radiation_dcpam_E_V2_inited ) call RadiationDcpamEV2Init


    ! O3 ʬۤ
    ! Setting of O3 distribution
    !
    call SetO3( &
      & xyz_Press, & ! (in )
      & xyz_QO3    & ! (out)
      & )


!!$    select case ( SWVer )
!!$    case ( 0 )
!!$      ! dcpam ϵ絤ûͥǥ Ver. 2
!!$      ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2
!!$      !
!!$      call RadiationDcpamESWV2Flux(                                 &
!!$        & xy_SurfAlbedo,                                                  &
!!$        & xyz_Press, xyr_Press, xyz_Temp, xyz_QH2OVap, xyz_QO3, xyz_Height,  &
!!$        & xyr_RadSFlux                                                    &
!!$        & )
!!$    case ( 1 )
      ! dcpam ϵ絤ûͥǥ Ver. 2.1
      ! dcpam short wave radiation model for the Earth's atmosphere Ver. 2.1
      !
      call RadiationDcpamESWV21Flux(                       &
        & xy_SurfAlbedo,                                   &
        & xyz_Press, xyr_Press, xyz_Temp,                  &
        & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, xyz_QO3,  &
        & xyr_RadSFlux                                     &
        & )
!!$    case default
!!$      call MessageNotify( 'E', module_name, 'SW model version %d is not supported.', i = (/ LWVer /) )
!!$    end select

!!$    select case ( LWVer )
!!$    case ( 0 )
!!$      call RadiationDcpamELWV2Flux( &
!!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
!!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
!!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
!!$        & )
!!$    case ( 1 )
!!$      call RadiationDcpamELWV21Flux( &
!!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
!!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
!!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
!!$        & )
!!$    case ( 2 )
!!$      call RadiationDcpamELWV22Flux( &
!!$        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
!!$        & xyz_QH2OVap, xyz_QO3,                                           & ! (in )
!!$        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
!!$        & )
!!$    case ( 3 )
      call RadiationDcpamELWV23Flux( &
        & xyz_Press, xyr_Press, xyz_Temp, xy_SurfTemp,                    & ! (in )
        & xyz_QH2OVap, xyz_QH2OLiq, xyz_QH2OSol, xyz_QO3,                 & ! (in )
        & xyr_RadLFlux, xyra_DelRadLFlux                                  & ! (out)
        & )
!!$    case default
!!$      call MessageNotify( 'E', module_name, 'LW model version %d is not supported.', i = (/ LWVer /) )
!!$    end select


  end subroutine RadiationDcpamEV2Flux

  !--------------------------------------------------------------------------------------

  subroutine RadiationDcpamEV2Init

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify


    ! ʸ ; Declaration statements
    !

!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
!!$                              ! IOSTAT of NAMELIST read

!!$    ! NAMELIST ѿ
!!$    ! NAMELIST group name
!!$    !
!!$    namelist /radiation_dcpam_EV2_nml/ &
!!$      & SWVer, LWVer
!!$          !
!!$          ! ǥեͤˤĤƤϽ³ "radiation_dcpam_EV2#RadiationDcpamEV2Init"
!!$          ! Υɤ򻲾ȤΤ.
!!$          !
!!$          ! Refer to source codes in the initialization procedure
!!$          ! "radiation_dcpam_EV2#RadiationDcpamEV2Init" for the default values.
!!$          !


    ! ǥեͤ
    ! Default values settings
    !
!!$    SWVer = 1
!!$    LWVer = 3


!!$    ! NAMELIST ɤ߹
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = radiation_dcpam_EV2_nml,  & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    ! Allocate a local variable for O3 distribution
    !
    allocate( xyz_QO3(0:imax-1, 1:jmax, 1:kmax) )


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'SWVer = %d', i = (/ SWVer /) )
!!$    call MessageNotify( 'M', module_name, 'LWVer = %d', i = (/ LWVer /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )


    radiation_dcpam_E_V2_inited = .true.

  end subroutine RadiationDcpamEV2Init

  !--------------------------------------------------------------------------------------

end module radiation_dcpam_E_V2
