!= û ()
!
!= Short wave (insolation) incoming
!
! Authors::   Yoshiyuki O. TAKAHASHI, Satoshi NODA, Yasuhiro MORIKAWA, Yukiko YAMADA
! Version::   $Id: radiation_short_income.f90,v 1.11 2010-02-24 08:24:30 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module radiation_short_income
  !
  != û ()
  !
  != Short wave (insolation) incoming
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! û () ׻ޤ.
  !
  ! Calculate short wave (insolation) incoming radiation. 
  !
  !== Procedures List
  !
  ! ShortIncoming      :: û () η׻
  ! ------------       :: ------------
  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
  !
  !== NAMELIST
  !
  ! NAMELIST#radiation_short_income_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! դӻμ갷
  ! Date and time handler
  !
  use dc_date_types, only: DC_DIFFTIME
                              ! κɽǡ. 
                              ! Data type for difference about date and time
  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: ShortIncoming

  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_short_income_inited = .false.
                              ! ե饰. 
                              ! Initialization flag.


  ! ѿ
  ! Private variables
  !

  real(DP), save:: SolarConst
                              ! . 
                              ! Solar constant.
  integer,  save:: AnnualMean
                              ! ǯʿͥե饰.
                              ! Flag for annual mean incoming radiation. 
  integer,  save:: DiurnalMean
                              ! ʿͥե饰.
                              ! Flag for diurnal mean incoming radiation. 
  real(DP), save:: YearLengthScld
                              ! ǥ 1 ǯǥ󥰤 1 ǯĹ.
                              ! Length of a year scaled by a year of model.
  real(DP), save:: DayLengthScld
                              ! ǥ 1 ǥ󥰤 1 Ĺ.
                              ! Length of a day scaled by a day of model.
  real(DP), save:: EpsOrb
                              ! ƻг.
                              ! Inclination of equator to orbit.
  real(DP), save:: EqnOrb
                              ! . 
                              ! 
  real(DP), save:: Eccentricity
                              ! ΥΨ.
                              ! Eccentricity.
  real(DP), save:: MeanAnomary_init
                              ! ׻ϻʿѶ (0.0 - 2*PI). 
                              ! Mean anomary (0.0 - 2*PI).
  integer,  save:: MaxItrEccAnomary
                              ! ΥѤ׻κ緫֤.
                              ! Maximum iteration number of times
                              ! to calculate eccentric anomary.
  real(DP), save:: ThreEccAnomaryError
                              ! ΥѤ׻θεƤ.
                              ! Threshold of error
                              ! to calculate eccentric anomary.
  real(DP), save:: IncomAIns
                              ! $ A_{ins} $ . ǯʿͤη. 
                              ! Coefficient of annual mean incoming radiation. 
  real(DP), save:: IncomBIns
                              ! $ B_{ins} $ . ǯʿͤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
  real(DP), save:: IncomAZet
                              ! $ A_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 
  real(DP), save:: IncomBZet
                              ! $ B_{\zeta} $ . ǯʿͳѤη. AIns Ʊ. 
                              ! Coefficient of annual mean incoming radiation. 
                              ! Same as "AIns". 


  real(DP), allocatable, save:: xy_IncomRadSFlux (:,:)
                              ! û () եå. 
                              ! Short wave (insolation) flux
  real(DP), allocatable, save:: xy_InAngle (:,:)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)


  character(*), parameter:: module_name = 'radiation_short_income'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: radiation_short_income.f90,v 1.11 2010-02-24 08:24:30 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface ShortIncoming
    module procedure ShortIncoming
  end interface

contains

  subroutine ShortIncoming( &
    & xy_IncomRadSFlux, xy_InAngle, DistFromStarScld, xy_CosZet  & ! (out)
    & )
    !
    ! û () ׻ޤ.
    !
    ! Calculate short wave (insolation) incoming radiation. 
    !

    ! ⥸塼 ; USE statements
    !

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: PI       ! $ \pi $ .
                                  ! ߼Ψ.  Circular constant
    ! 
    ! Time control
    !
    use timeset, only: TimeN

    ! դӻμ갷
    ! Date and time handler
    !
    use dc_date, only: DC_DIFFTIME, EvalDay, EvalSec

    use dc_date_types, only: DAY_SECONDS, YEAR_DAYS

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: y_Lat, & ! $ \varphi $ [rad.] . . Latitude
                     & x_Lon    ! $ \lambda $ [rad.] . . Longitude

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xy_IncomRadSFlux (0:imax-1, 1:jmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux
    real(DP), intent(out):: xy_InAngle (0:imax-1, 1:jmax)
                              ! sec (ͳ). 
                              ! sec (angle of incidence)
    real(DP), intent(out), optional :: DistFromStarScld
                                  ! ƻĹȾ¤ǥ󥰤εΥ
                                  ! Distance from the star scaled
                                  ! by semimajor axis of the planet's orbit
    real(DP), intent(out), optional :: xy_CosZet(0:imax-1, 1:jmax)
                              ! ͳ
                              ! Incidence angle

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: itr             ! ƥ졼˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in iteration direction
    real(DP):: SinDel         ! ְ
                              ! Declination
    real(DP):: CosZet         ! ͳ
                              ! Incidence angle
    real(DP):: HourAngle      ! 
                              ! Hour angle
    real(DP):: SeasonByYear   ! ǯɽ (0.0 - 1.0)
                              ! Season expressed by year (0.0 - 1.0)
    real(DP):: ClockByDay     ! ɽ (0.0 - 1.0)
                              ! Clock expressed by day (0.0 - 1.0)
    real(DP):: MeanAnomary    ! ʿѶ
                              ! Mean anomary
    real(DP):: EccAnomary     ! Υ
                              ! eccentric anomary
    real(DP):: EccAnomaryError ! ˥塼ȥˡˤΥѤθ
                               ! error of eccentric anomary in Newton method
    real(DP):: DistFromStarScldLR


    ! ¹ʸ ; Executable statement
    !

    ! 
    ! Initialization
    !
    if ( .not. radiation_short_income_inited ) call ShtIncomeInit

    ! ǯ, ʿͤη׻
    ! Calculate annual mean, daily mean insolation
    !

    if ( (AnnualMean == 1) .and. (DiurnalMean == 1) ) then


      do i = 0, imax - 1
        do j = 1, jmax
          xy_IncomRadSFlux(i,j) = &
            &  - SolarConst &
            &    * ( IncomAIns + IncomBIns * cos( y_Lat(j) )**2 )

          if ( xy_IncomRadSFlux(i,j) < 0.0_DP ) then
            xy_InAngle(i,j) = 1.0_DP / ( IncomAZet + IncomBZet * cos( y_Lat(j) )**2 )
          else
            xy_IncomRadSFlux(i,j) = 0.
            xy_InAngle(i,j) = 0.
          end if
        end do
      end do 

    else if ( (AnnualMean == 0) .and. (DiurnalMean == 0) ) then

    ! Ѳ, Ѳη׻
    ! Calculate with seasonal change and diurnal change
    !

      SeasonByYear = mod( EvalSec( TimeN )                                   &
                       &  / (YearLengthScld * YEAR_DAYS * DAY_SECONDS), &
                       &  1.0_DP )
      ClockByDay   = mod( EvalSec( TimeN )                      &
                       &  / (DayLengthScld * DAY_SECONDS), &
                       &  1.0_DP )
      MeanAnomary  = mod( 2.0_DP * PI * SeasonByYear + MeanAnomary_init, &
                       &  2.0_DP * PI )

    ! ˥塼ȥˡѤʿѶѤΥѤ.
    ! Calculate eccentric anomaly from mean anomary by using Newton method.

      EccAnomary = MeanAnomary
      do itr = 1, MaxItrEccAnomary
        EccAnomaryError = EccAnomary &
                        & - Eccentricity * sin(EccAnomary) - MeanAnomary
        if ( abs(EccAnomaryError) <= ThreEccAnomaryError ) exit
        EccAnomary = mod( EccAnomary                                       &
                        & - EccAnomaryError                                &
                        &   / ( 1.0_DP - Eccentricity * cos(EccAnomary) ), &
                        & 2.0 * PI )
      end do
      if ( itr > MaxItrEccAnomary ) then
        call MessageNotify( 'E', module_name, 'Calculation for eccentric anomary does not converge.' )
      end if

      DistFromStarScldLR = 1.0_DP - Eccentricity * cos( EccAnomary )

      SinDel = sin( EpsOrb/180.0_DP * PI ) &
            &  * sin( ( SeasonByYear - EqnOrb/360.0_DP ) * 2.0_DP * PI )

      do i = 0, imax - 1
        do j = 1, jmax

          HourAngle = ClockByDay * 2.0_DP * PI - PI + x_Lon(i)
          CosZet = sin( y_Lat(j) ) * SinDel &
                &  + cos( y_Lat(j) ) * sqrt( 1.0_DP - SinDel**2 ) * cos( HourAngle )

          if ( CosZet > 0.0_DP ) then
            xy_IncomRadSFlux(i,j) = &
              & - ( SolarConst / DistFromStarScldLR ** 2 ) &
              &   * CosZet
            xy_InAngle(i,j) = 1.0_DP / CosZet
          else
            xy_IncomRadSFlux(i,j) = 0.
            xy_InAngle(i,j) = 0.
          end if

          if ( present( xy_CosZet ) ) then
            xy_CosZet(i,j) = CosZet
          end if

        end do
      end do


      if ( present( DistFromStarScld ) ) then
        DistFromStarScld = DistFromStarScldLR
      end if

    else

    ! бƤʤͥ
    ! not implemented insolation type
    !

      call MessageNotify( 'E', module_name, 'This type of insolation is not impremented' )

    end if

    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'ISR', xy_IncomRadSFlux )


  end subroutine ShortIncoming

  !-------------------------------------------------------------------

  subroutine ShtIncomeInit
    !
    ! radiation_short_income ⥸塼νԤޤ. 
    ! NAMELIST#radiation_short_income_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "radiation_short_income" module is initialized. 
    ! "NAMELIST#radiation_short_income_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /radiation_short_income_nml/        &
      & SolarConst,                              &
      & AnnualMean, DiurnalMean,                 &
      & YearLengthScld, DayLengthScld, &
      & EpsOrb, EqnOrb,                          &
      & Eccentricity, MeanAnomary_init,          &
      & MaxItrEccAnomary, ThreEccAnomaryError,   &
      & IncomAIns, IncomBIns, IncomAZet, IncomBZet
          !
          ! ǥեͤˤĤƤϽ³ "radiation_short_income#ShtIncomeInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "radiation_short_income#ShtIncomeInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( radiation_short_income_inited ) return
    call InitCheck

    ! ǥեͤ
    ! Default values settings
    !
    SolarConst           = 1380.0_DP
    AnnualMean           = 1
    DiurnalMean          = 1
    YearLengthScld       = 1.0_DP
    DayLengthScld        = 1.0_DP
    EpsOrb               = 23.5_DP
    EqnOrb               = 110.0_DP
    Eccentricity         = 0.0_DP
    MeanAnomary_init     = 0.0_DP
    MaxItrEccAnomary     = 20
    ThreEccAnomaryError  = 1e-6_DP
    IncomAIns            = 0.127_DP
    IncomBIns            = 0.183_DP
    IncomAZet            = 0.410_DP
    IncomBZet            = 0.590_DP

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = radiation_short_income_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ¸Ѥѿγդ
    ! Allocate variables for saving
    !

    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
!!$    call HistoryAutoAddVariable( 'xxxxx' , &
!!$      & (/ 'lon ', 'lat ', 'sig', 'time'/), &
!!$      & 'xxxx', 'W m-2' )

    call HistoryAutoAddVariable( 'ISR' , &
      & (/ 'lon ', 'lat ', 'time'/),     &
      & 'incoming shortwave', 'W m-2' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, 'ShortIncomming:' )
    call MessageNotify( 'M', module_name, '  SolarConst          = %f', d = (/ SolarConst          /) )
    call MessageNotify( 'M', module_name, '  AnnualMean          = %d', i = (/ AnnualMean          /) )
    call MessageNotify( 'M', module_name, '  DiurnalMean         = %d', i = (/ DiurnalMean         /) )
    call MessageNotify( 'M', module_name, '  YearLengthScld      = %f', d = (/ YearLengthScld      /) )
    call MessageNotify( 'M', module_name, '  DayLengthScld       = %f', d = (/ DayLengthScld       /) )
    call MessageNotify( 'M', module_name, '  EpsOrb              = %f', d = (/ EpsOrb              /) )
    call MessageNotify( 'M', module_name, '  EqnOrb              = %f', d = (/ EqnOrb              /) )
    call MessageNotify( 'M', module_name, '  Eccentricity        = %f', d = (/ Eccentricity        /) )
    call MessageNotify( 'M', module_name, '  MeanAnomary_init    = %f', d = (/ MeanAnomary_init    /) )
    call MessageNotify( 'M', module_name, '  MaxItrEccAnomary    = %d', i = (/ MaxItrEccAnomary    /) )
    call MessageNotify( 'M', module_name, '  ThreEccAnomaryError = %f', d = (/ ThreEccAnomaryError /) )
    call MessageNotify( 'M', module_name, '  IncomAIns           = %f', d = (/ IncomAIns           /) )
    call MessageNotify( 'M', module_name, '  IncomBIns           = %f', d = (/ IncomBIns           /) )
    call MessageNotify( 'M', module_name, '  IncomAZet           = %f', d = (/ IncomAZet           /) )
    call MessageNotify( 'M', module_name, '  IncomBZet           = %f', d = (/ IncomBZet           /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    radiation_short_income_inited = .true.
  end subroutine ShtIncomeInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited

    ! 
    ! Time control
    !
    use timeset, only: timeset_inited

    ! ¹ʸ ; Executable statement
    !

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

    if ( .not. timeset_inited ) &
      & call MessageNotify( 'E', module_name, '"timeset" module is not initialized.' )

  end subroutine InitCheck

end module radiation_short_income
