!= ͥǡ
!
!= Prepare initial data
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: initial_data.F90,v 1.4 2010-01-22 07:17:25 yot Exp $ 
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module initial_data
  !
  != ͥǡ
  !
  != Prepare initial data
  !
  ! ͥǡΥץ󶡤ޤ. 
  ! 
  ! ߤϰʲΥǡ󶡤ޤ. 
  ! 
  ! * Small Disturbance of Temperature
  !   * ®: 0 [m/s], ɽ̵: 1.0e+5 [Pa], 漾: 1.0e-10 [kg kg-1]
  !   * : 250 [K] ä
  !
  ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
  !   * ®: 0 [m/s], ɽ̵: 1.0e+5 [Pa], 漾: 1.0e-10 [kg kg-1]
  !   * : 250 [K] ä
  ! 
  ! * Sugiyama et al. (2008)
  !   * 絤ꤷ, Sugiyama et al. (2008) ѤƤ
  !     ͤ魯. 
  !   * ®: 0 [m/s], ɽ̵: 3.0e+6 [Pa]
  !   * : $ \sigma = 1 $  490 [K] Ȥ,  1.0e+4 Ȥʤ٤ޤ, 
  !     ̰ (Ǯ˱ä) ٤ȼ٤򸺾. 
  !      1.0e+4 ʲι٤ǤϲٰȤ. 
  !   * 漾: $ \sigma = 1 $  6.11641e-3 [kg kg-1] Ȥ, 
  !     漾˰漾 75 % Ȥʤ٤ޤǤϰȤ. 
  !     ιٰʾǤ, 漾˰漾 75 % Ȥ. 
  !
  ! Prepare sample data of initial data (restart data)
  !
  ! Now, following data are provided. 
  ! 
  ! * Small Disturbance of Temperature
  !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa], 
  !     Specific humidity: 1.0e-10 [kg kg-1]
  !   * Temperature: 250 [K] and perturbation
  !
  ! * [AGCM 5.3]{http://www.gfd-dennou.org/library/agcm5} Default
  !   * Velocity: 0 [m/s], Surface pressure: 1.0e+5 [Pa], 
  !     Specific humidity: 1.0e-10 [kg kg-1]
  !   * Temperature: 250 [K] and perturbation
  ! 
  ! * Sugiyama et al. (2008)
  !   * Initial data like a Jovian atmosphere  
  !     that is used in Sugiyama et al. (2008) is imitated. 
  !   * Velocity: 0 [m/s], Surface pressure: 3.0e+6 [Pa]
  !   * Temperature: 490 [K] at $ \sigma = 1 $ . 
  !     And it is declined with constant potential temperature
  !     (along dry adiabat line) 
  !     below where air pressure is 1.0e+4. 
  !     It is constant above where air pressure is 1.0e+4. 
  !   * Specific humidity: 6.11641e-3 [kg kg-1] at $ \sigma = 1 $ .
  !     And it is constant below where it is same as 75 % of 
  !     saturation specific humidity. 
  !     Above that, specific humidity is 75 % of saturation specific humidity. 
  !
  !== Procedures List
  !
  ! SetInitData   :: ͥǡ
  ! ------------  :: ------------
  ! SetInitData   :: Get initial data
  !
  !== NAMELIST
  !
  ! NAMELIST#initial_data_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP     ! ټ¿. Double precision. 

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: SetInitData

  ! ѿ
  ! Public variables
  !
  logical, save, public:: initial_data_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  character(STRING), save, public:: Pattern
                              ! ͥǡΥѥ. 
                              ! ʲΥѥǽ. 
                              ! 
                              ! Initial data pattern
                              ! Available patterns are as follows.
                              ! 
                              ! * "Small Disturbance of Temperature" (default value)
                              ! * "AGCM 5.3 Default"
                              ! * "Sugiyama et al. (2008)"
                              ! 
  real(DP), save, public:: TempAvr
                              ! $ \bar{T} $ .     ʿ. Mean temperature
  real(DP), save, public:: PsAvr
                              ! $ \bar{p_s} $ .   ɽ̵ʿ. Mean surface pressure
  real(DP), save, public:: QVapAvr
                              ! $ \bar{q} $ .     漾ʿ. Mean specific humidity
  real(DP), save, public:: Ueq
                              ! $ u_{eq} $ .      ƻ®. Eastward wind on the equator

  ! ѿ
  ! Private variables
  !
  character(*), parameter:: saturate_scheme = &
#ifdef LIB_SATURATE_NHA1992
    & 'Nakajima et al. (1992)'
#elif LIB_SATURATE_T1930
    & 'Tetens (1930)'
#else
    & 'Tetens (1930)'
#endif

  character(*), parameter:: module_name = 'initial_data'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: initial_data.F90,v 1.4 2010-01-22 07:17:25 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !
  interface SetInitData
    module procedure SetInitData
  end interface

contains

  subroutine SetInitData( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
    & )
    !
    ! ͥǡΥץ󶡤ޤ. 
    ! 
    ! Prepare sample data of initial data
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. initial_data_inited ) call InitDataInit

    ! ʲپΤŻ߾
    ! Stationary field with small disturbance of temperature
    !
    select case ( LChar( trim(Pattern) ) )
    case ( 'small disturbance of temperature' )
      xyz_U    = 0.0_DP
      xyz_V    = 0.0_DP
      xyz_Temp = TempAvr
      xy_Ps    = PsAvr
      xyz_QVap = QVapAvr

      ! ٤˾Ϳ
      ! Add perturbation to temperature
      !
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax - 1
            xyz_Temp(i,j,k) = &
              &    xyz_Temp(i,j,k) &
              &  + 0.1_DP * sin ( x_Lon(i) * y_Lat(j) ) &
              &  - 0.1_DP * ( 1.0_DP - z_Sigma(k) )
          end do
        end do
      end do

      ! ®Ϳ
      ! Add eastward wind
      !
      do j = 1, jmax
        xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
      end do

    ! AGCM5.3 ΥǥեȽ
    ! AGCM5.3 default initial values
    !
    case ( 'agcm 5.3 default' )
      xyz_U    = 0.0_DP
      xyz_V    = 0.0_DP
      xyz_Temp = TempAvr
      xy_Ps    = PsAvr
      xyz_QVap = QVapAvr

      ! ٤˾Ϳ
      ! Add perturbation to temperature
      !
      do k = 1, kmax
        do j = 1, jmax
          do i = 0, imax - 1
            xyz_Temp(i,j,k) = &
              &    xyz_Temp(i,j,k) &
              &  + 0.1_DP &
              &    * sin ( real( ( i + 1 ) &
              &                  * ( jmax - j + 1 ) &
              &                  * ( kmax - k ), DP ) &
              &            / real( imax &
              &                    * jmax &
              &                    * kmax, DP ) * 10.0_DP &
              &                 )
          end do
        end do
      end do

      ! ®Ϳ
      ! Add eastward wind
      !
      do j = 1, jmax
        xyz_U(:,j,:) = Ueq * cos(y_Lat(j))
      end do

    ! Sugiyama et al. (2008) ν
    ! Initial values of Sugiyama et al. (2008)
    !
    case ( 'sugiyama et al. (2008)' )

      call Sugiyamaetal2008InitData( &
        & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
        & )

    end select

  end subroutine SetInitData

  !-------------------------------------------------------------------

  subroutine Sugiyamaetal2008InitData( &
    & xyz_U, xyz_V, xyz_Temp, xyz_QVap, xy_Ps &   ! (out)
    & )
    !
    ! Sugiyama et al. (2008) ν
    ! Initial values of Sugiyama et al. (2008)
    !

    ! ⥸塼 ; USE statements
    !

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon, &
                              ! $ \lambda $ [rad.] . . Longitude
      & y_Lat, &
                              ! $ \varphi $ [rad.] . . Latitude
      & z_Sigma
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: &
      & CpDry, &              ! $ C_p $ [J kg-1 K-1]. 
                              ! 絤갵Ǯ. 
                              ! Specific heat of air at constant pressure
      & GasRDry               ! $ R $ [J kg-1 K-1]. 
                              ! 絤ε. 
                              ! Gas constant of air

    ! ˰漾׻
    ! Evaluate saturation specific humidity
    !
#ifdef LIB_SATURATE_NHA1992
    use saturate_nha1992, only: CalcQVapSat
#elif LIB_SATURATE_T1930
    use saturate_t1930, only: CalcQVapSat
#else
    use saturate_t1930, only: CalcQVapSat
#endif

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none
    real(DP), intent(out):: xyz_U  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ .   ®. Eastward wind
    real(DP), intent(out):: xyz_V  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ .   ®. Northward wind
    real(DP), intent(out):: xyz_Temp  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .   . Temperature
    real(DP), intent(out):: xyz_QVap  (0:imax-1, 1:jmax, 1:kmax)
                              ! $ q $ .   漾. Specific humidity
    real(DP), intent(out):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s $ . ɽ̵. Surface pressure

    ! Sugiyama et al. (2008) Ѻѿ
    ! Work variables for Sugiyama et al. (2008)
    !
    real(DP):: xyz_PotTemp (0:imax-1, 1:jmax, 1:kmax)
                              ! . Potential temperature
    real(DP):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! . Air pressure
    real(DP):: xy_TempMin (0:imax-1, 1:jmax)
                              ! ٤κǾ. Minimum value of temperature
    real(DP):: xyz_QVapSat (0:imax-1, 1:jmax, 1:kmax)
                              ! ˰漾. Saturation specific humidity

    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    ! ¹ʸ ; Executable statement

    if ( .not. initial_data_inited ) call InitDataInit


    xyz_U    = 0.0_DP
    xyz_V    = 0.0_DP
    xyz_Temp = TempAvr
    xy_Ps    = PsAvr
    xyz_QVap = QVapAvr

    ! ٤η׻
    ! Calculate temperature
    !
    xyz_PotTemp = TempAvr
    xy_TempMin  = TempAvr

    do k = 1, kmax
      xyz_Temp(:,:,k) = xyz_PotTemp(:,:,k) &
        &                  * ( z_Sigma(k) )**( GasRDry / CpDry )

      if ( PsAvr * z_Sigma(k) < 1.0e+4_DP ) then
        xyz_Temp(:,:,k) = xy_TempMin
      else
        xy_TempMin = xyz_Temp(:,:,k)
      end if
    end do

    ! ٤˾Ϳ
    ! Add perturbation to temperature
    !
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax - 1
          xyz_Temp(i,j,k) = &
            &    xyz_Temp(i,j,k) &
            &  + 0.1_DP &
            &    * sin ( real( ( i + 1 ) &
            &                  * ( jmax - j + 1 ) &
            &                  * ( kmax - k ), DP ) &
            &            / real( imax &
            &                    * jmax &
            &                    * kmax, DP ) * 10.0_DP &
            &                 )
        end do
      end do
    end do

    ! ˰漾׻
    ! Calculate saturation specific humidity
    !
    do k = 1, kmax
      xyz_Press(:,:,k) = xy_Ps * z_Sigma(k)
    end do

    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax - 1
          xyz_QVapSat(i,j,k) = CalcQVapSat( xyz_Temp(i,j,k), xyz_Press(i,j,k) )
        end do
      end do
    end do

    ! 漾η׻
    ! Calculate specific humidity
    !
    where ( xyz_QVap > xyz_QVapSat * 0.75 )
      xyz_QVap = xyz_QVapSat * 0.75
    end where


  end subroutine Sugiyamaetal2008InitData

  !-------------------------------------------------------------------

  subroutine InitDataInit

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ʸ
    ! Character handling
    !
    use dc_string, only: LChar

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /initial_data_nml/ Pattern, &
      & TempAvr, PsAvr, QVapAvr, Ueq
          !
          ! ǥեͤˤĤƤϽ³ "initial_data#InitDataInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "initial_data#InitDataInit" for the default values. 
          !


    ! ¹ʸ ; Executable statement

    if ( initial_data_inited ) return
    call InitCheck

    ! ǥեͤ (ޤ Pattern Τ)
    ! Default values settings (At first, "Pattern" only)
    !
    Pattern = 'Small Disturbance of Temperature'
    !Pattern = 'AGCM 5.3 Default'

    ! NAMELIST ɤ߹ (ޤ Pattern Τ)
    ! NAMELIST is input (At first, "Pattern" only)
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = initial_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if

    ! ǥեͤ
    ! Default values settings
    !
    select case ( LChar( trim(Pattern) ) )
    case ( 'small disturbance of temperature' )
      TempAvr = 250.0_DP
      PsAvr   = 1.0e+5_DP
      QVapAvr = 1.0e-10_DP
      Ueq     = 0.0_DP
    case ( 'agcm 5.3 default' )
      TempAvr = 250.0_DP
      PsAvr   = 1.0e+5_DP
      QVapAvr = 1.0e-10_DP
      Ueq     = 0.0_DP
    case ( 'sugiyama et al. (2008)' )
      TempAvr = 490.0_DP
      PsAvr   = 3.0e+6_DP
      QVapAvr = 6.11641e-3_DP
      Ueq     = 0.0_DP
    case default
      call MessageNotify( 'E', module_name, 'Pattern=<%c> is invalid.', &
        & c1 = trim(Pattern) )
    end select

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &             ! (in)
        & nml = initial_data_nml, & ! (out)
        & iostat = iostat_nml )     ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  Pattern = %c', c1 = trim(Pattern) )
    call MessageNotify( 'M', module_name, '  TempAvr = %f', d = (/ TempAvr  /) )
    call MessageNotify( 'M', module_name, '  PsAvr   = %f', d = (/ PsAvr  /) )
    call MessageNotify( 'M', module_name, '  QVapAvr = %f', d = (/ QVapAvr  /) )
    call MessageNotify( 'M', module_name, '  Ueq     = %f', d = (/ Ueq  /) )
    call MessageNotify( 'M', module_name, '' )
    call MessageNotify( 'M', module_name, '  Scheme of saturation = %c', &
      & c1 = saturate_scheme )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    initial_data_inited = .true.
  end subroutine InitDataInit

  !-------------------------------------------------------------------

  subroutine InitCheck
    !
    ! ¸⥸塼νå
    !
    ! Check initialization of dependency modules

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_util_inited

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: gridset_inited

    ! ʪ
    ! Physical constants settings
    !
    use constants, only: constants_inited

    ! ɸǡ
    ! Axes data settings
    !
    use axesset, only: axesset_inited


    ! ¹ʸ ; Executable statement

    if ( .not. namelist_util_inited ) &
      & call MessageNotify( 'E', module_name, '"namelist_util" module is not initialized.' )

    if ( .not. gridset_inited ) &
      & call MessageNotify( 'E', module_name, '"gridset" module is not initialized.' )

    if ( .not. constants_inited ) &
      & call MessageNotify( 'E', module_name, '"constants" module is not initialized.' )

    if ( .not. axesset_inited ) &
      & call MessageNotify( 'E', module_name, '"axesset" module is not initialized.' )

  end subroutine InitCheck

end module initial_data
