module Dcl_Thermo_Graph
! ǮϳشطΥդμư롼
  use Thermo_Const
  use Thermo_Function
  use Statistics
  use dcl

contains

subroutine SkewT( title, slope, t_int, p_int,  &
  &               sondeT, sondeP, sondeQV,  &
  &               heiopt, viewx_int, viewy_int, undef )
! skew-T 롼
! ȽļΥȥϤ٤ height  temperature Ǹ.
  use Thermo_Const
  use Thermo_Function
  use Dcl
  implicit none
  character(*), intent(in) :: title  ! ɽΥȥ
  real, intent(in) :: slope  ! skewT η
  real, intent(in) :: t_int(2)  ! ʲ١ˤξü [K]
                      ! t_int(1)=tmin, t_int(2)=tmax
  real, intent(in) :: p_int(2)  ! ʵˤξü [Pa]
                      ! p_int(1)=pmin, p_int(2)=pmax
  real, intent(in), dimension(:) :: sondeT  ! Ǥβ [K]
  real, intent(in), dimension(size(sondeT)) :: sondeP  ! Ǥε [Pa]
  real, intent(in), dimension(size(sondeT)) :: sondeQV  ! Ǥκ [kg/kg]
  character(1), intent(in), optional :: heiopt  ! ļΤȤ
  ! heiopt='p' : logP ǽļȤ. ΤȤ, pmin, pmax, sondeP Ϥ٤
  !               Pa ñ̤ǤȤ뤳.
  ! heiopt='g' : geometric z ǽļȤ. ΤȤ, pmin, pmax, sondeP 
  !              ٤ m ñ̤Ȥ뤳.
  ! z=-logP δطˤʤ뤬, ǽΤ, ѼԤ
  ! ˤ, min Ϻ, max Ϻͤ OK.
  ! ǥեȤǤ, ǽļ.
  real, intent(in), optional :: viewx_int(2)  ! viewport  x ξü.
                                ! viewx_int(1)=viewxmin, viewx_int(2)=viewxmax
  real, intent(in), optional :: viewy_int(2)  ! viewport  y ξü.
                                ! viewy_int(1)=viewymin, viewy_int(2)=viewymax
  ! ǥեȤ, (0.25, 0.7, 0.2, 0.8) Ǹ.
  real, intent(in), optional :: undef  ! ̤, ǥեȤǤꤷʤ.
!-- ʾ, 
  real :: tmin  ! ʲ١ˤκ [K]
  real :: tmax  ! ʲ١ˤκǹ [K]
  real :: pmin  ! ļʵˤκ [Pa]
  real :: pmax  ! ļʵˤκǹ [Pa]
  real :: vxmin  ! viewport  xmin.
  real :: vxmax  ! viewport  xmin.
  real :: vymin  ! viewport  xmin.
  real :: vymax  ! viewport  xmin.
!-- ʾ, ֤ѿ
  integer, parameter :: nx=100, ny=100
  real, dimension(nx,ny) :: temp, pt, qvs, spt
  real, dimension(size(sondeT)) :: sondedT, sondedP, sondedTD
  real, dimension(nx) :: tempd
  real, dimension(ny) :: p
  integer :: i, j, k, nt
  real :: pdmax, pdmin
  real :: dp, dpd, dt
  real :: undeff

  nt=size(sondeT)

  if(present(undef))then
     undeff=undef
  end if

!-- ʹ, ץ
  if(present(viewx_int))then
     vxmin=viewx_int(1)
     vxmax=viewx_int(2)
  else
     vxmin=0.25
     vxmax=0.75
  end if

  if(present(viewy_int))then
     vymin=viewy_int(1)
     vymax=viewy_int(2)
  else
     vymin=0.1
     vymax=0.8
  end if

!-- ֤ѿ֤
  pmin=p_int(1)
  pmax=p_int(2)
  tmin=t_int(1)
  tmax=t_int(2)

  pdmin=pmin*1.0e-2
  pdmax=pmax*1.0e-2

  dt=(tmax-tmin)/(nx-1)
  tempd=(/((tmin+dt*(i-1)),i=1,nx)/)

  if(present(heiopt))then
     if(heiopt=='p')then
        dp=(pmax-pmin)/(ny-1)
        dpd=(pdmax-pdmin)/(ny-1)
        p=(/((pmax-dp*(i-1)),i=1,ny)/)
     else  ! ٷ׻, z  p ľʤ pt η׻Բǽ (׽)
        dp=(pmax-pmin)/(ny-1)
        dpd=(pdmax-pdmin)/(ny-1)
        p=(/((pmin+dp*(i-1)),i=1,ny)/)
     end if
  else
     dp=(pmax-pmin)/(ny-1)
     dpd=(pdmax-pdmin)/(ny-1)
     p=(/((pmax-dp*(i-1)),i=1,ny)/)
  end if

!-- ƶη׻
  do j=1,ny
     do i=1,nx
        temp(i,j)=tempd(i)+slope*log(p(j)/p0)
        pt(i,j)=theta_dry( temp(i,j), p(j) )
        spt(i,j)=thetaes_Bolton( temp(i,j), p(j) )
        qvs(i,j)=TP_2_qvs( temp(i,j), p(j) )*1.0e3
     end do
  end do

  do j=1,nt
     if(sondeT(j)==undeff.or.sondeP(j)==undeff.or.sondeQV(j)==undeff)then
        sondedT(j)=undeff
        sondedP(j)=undeff
        sondedTD(j)=undeff
     else
        sondedT(j)=sondeT(j)-slope*log(sondeP(j)/p0)  ! temp, tempd Ʊ.
        sondedP(j)=sondeP(j)*1.0e-2
        sondedTD(j)=es_TD(qvP_2_e(sondeQV(j),sondeP(j)))-slope*log(sondeP(j)/p0)
     end if
  end do

  call DclNewFrame

  call DclScalingPoint( sondedT, sondedP )
  call DclSetTransNumber( 2 )
  call DclSetWindow( tmin, tmax, pdmax, pdmin )
  call DclSetViewPort( vxmin, vxmax, vymin, vymax )
  call DclSetTransFunction

  call DclSetTitle( 'Temperature', 'height', '', '' )

  call DclDrawScaledAxis

  call UDISET('INDXMJ', 31)
  call UDISET('INDXMN', 31)
  call DclDrawContour( temp )
  call UDISET('INDXMJ', 22)
  call UDISET('INDXMN', 22)
  call DclDrawContour( pt )
  call UDISET('INDXMJ', 13)
  call UDISET('INDXMN', 13)
  call DclDrawContour( spt )
  call UDISET('INDXMJ', 1)
  call DclDrawContour( qvs )
  call DclDrawLine( sondedT, sondedP, index=43 )
  call DclDrawLine( sondedTD, sondedP, index=43, type=2 )
  call DclDrawTitle( 't', trim(title) )


end subroutine

!-----------------------------------------------

subroutine SkewT_vec( title, slope, t_int, p_int,  &
  &                   sondeT, sondeP, sondeQV,  &
  &                   sondeU, sondeV, heiopt,  &
  &                   viewx_int, viewy_int, vx, undef )
! skew-T  + vector ޤ롼
! ȽļΥȥϤ٤ height  temperature Ǹ.
  use Thermo_Const
  use Thermo_Function
  use Statistics
  use Dcl
  implicit none
  character(*), intent(in) :: title  ! ɽΥȥ
  real, intent(in) :: slope  ! skewT η
  real, intent(in) :: t_int(2)  ! ʲ١ˤξü [K]
                      ! t_int(1)=tmin, t_int(2)=tmax
  real, intent(in) :: p_int(2)  ! ʵˤξü [Pa]
                      ! p_int(1)=pmin, p_int(2)=pmax
  real, intent(in), dimension(:) :: sondeT  ! Ǥβ [K]
  real, intent(in), dimension(size(sondeT)) :: sondeP  ! Ǥε [Pa]
  real, intent(in), dimension(size(sondeT)) :: sondeQV  ! Ǥκ [kg/kg]
  real, intent(in), dimension(size(sondeT)) :: sondeU  ! Ǥ [m/s]
  real, intent(in), dimension(size(sondeT)) :: sondeV  ! Ǥ [m/s]
  character(1), intent(in), optional :: heiopt  ! ļΤȤ
  ! heiopt='p' : logP ǽļȤ. ΤȤ, pmin, pmax, sondeP Ϥ٤
  !               Pa ñ̤ǤȤ뤳.
  ! heiopt='g' : geometric z ǽļȤ. ΤȤ, pmin, pmax, sondeP 
  !              ٤ m ñ̤Ȥ뤳.
  ! z=-logP δطˤʤ뤬, ǽΤ, ѼԤ
  ! ˤ, min Ϻ, max Ϻͤ OK.
  ! ǥեȤǤ, ǽļ.
  real, intent(in), optional :: viewx_int(2)  ! viewport  x ξü.
                                ! viewx_int(1)=viewxmin, viewx_int(2)=viewxmax
  real, intent(in), optional :: viewy_int(2)  ! viewport  y ξü.
                                ! viewy_int(1)=viewymin, viewy_int(2)=viewymax
  ! ǥեȤ, (0.25, 0.7, 0.2, 0.8) Ǹ.
  integer, intent(in), optional :: vx  ! ٥ȥδְʻҿ.
  ! ְ, Ϥ˴ؤʻҾ֤.
  ! ǥեȤ 10 ʻ
  real, intent(in), optional :: undef  ! ̤, ǥեȤǤꤷʤ.
!-- ʾ, 
  real :: tmin  ! ʲ١ˤκ [K]
  real :: tmax  ! ʲ١ˤκǹ [K]
  real :: pmin  ! ļʵˤκ [Pa]
  real :: pmax  ! ļʵˤκǹ [Pa]
  real :: vxmin  ! viewport  xmin.
  real :: vxmax  ! viewport  xmin.
  real :: vymin  ! viewport  xmin.
  real :: vymax  ! viewport  xmin.
!-- ʾ, ֤ѿ
  integer, parameter :: nx=100, ny=100
  real, dimension(nx,ny) :: temp, pt, qvs, spt
  real, dimension(size(sondeT)) :: sondedT, sondedP, sondedTD, sondelogP
  real, dimension(nx) :: tempd
  real, dimension(ny) :: p
  integer :: i, j, k, nt, vecx
  real :: pdmax, pdmin
  real :: dp, dpd, dt, dpv
  real :: undeff
  real, allocatable, dimension(:,:) :: u, v
  real, allocatable, dimension(:) :: pv
  integer, allocatable, dimension(:) :: interpo

  nt=size(sondeT)

  if(present(vx))then
     vecx=vx
  else
     vecx=10
  end if

!-- ʹ, ץ
  if(present(viewx_int))then
     vxmin=viewx_int(1)
     vxmax=viewx_int(2)
  else
     vxmin=0.25
     vxmax=0.75
  end if

  if(present(viewy_int))then
     vymin=viewy_int(1)
     vymax=viewy_int(2)
  else
     vymin=0.1
     vymax=0.8
  end if

!-- ֤ѿ֤
  pmin=p_int(1)
  pmax=p_int(2)
  tmin=t_int(1)
  tmax=t_int(2)

  pdmin=pmin*1.0e-2
  pdmax=pmax*1.0e-2

  if(present(undef))then
     undeff=undef
  end if

  dt=(tmax-tmin)/(nx-1)
  tempd=(/((tmin+dt*(i-1)),i=1,nx)/)

  if(present(heiopt))then
     if(heiopt=='p')then
        dp=(pmax-pmin)/(ny-1)
        dpd=(pdmax-pdmin)/(ny-1)
        p=(/((pmax-dp*(i-1)),i=1,ny)/)
     else  ! ٷ׻, z  p ľʤ pt η׻Բǽ (׽)
        dp=(pmax-pmin)/(ny-1)
        dpd=(pdmax-pdmin)/(ny-1)
        p=(/((pmin+dp*(i-1)),i=1,ny)/)
     end if
  else
     dp=(pmax-pmin)/(ny-1)
     dpd=(pdmax-pdmin)/(ny-1)
     p=(/((pmax-dp*(i-1)),i=1,ny)/)
  end if

!-- ƶη׻
  do j=1,ny
     do i=1,nx
        temp(i,j)=tempd(i)+slope*log(p(j)/p0)
        pt(i,j)=theta_dry( temp(i,j), p(j) )
        spt(i,j)=thetaes_Bolton( temp(i,j), p(j) )
        qvs(i,j)=TP_2_qvs( temp(i,j), p(j) )*1.0e3
     end do
  end do

  do j=1,nt
     if(sondeT(j)==undeff.or.sondeP(j)==undeff.or.sondeQV(j)==undeff.or.sondeU(j)==undeff.or.sondeV(j)==undeff)then
        sondedT(j)=undeff
        sondedP(j)=undeff
        sondedTD(j)=undeff
        sondelogP(j)=undeff
     else
        sondedT(j)=sondeT(j)-slope*log(sondeP(j)/p0)  ! temp, tempd Ʊ.
        sondedP(j)=sondeP(j)*1.0e-2
        sondedTD(j)=es_TD(qvP_2_e(sondeQV(j),sondeP(j)))-slope*log(sondeP(j)/p0)
        sondelogP(j)=-log(sondeP(j))
     end if
  end do

!-- ٥ȥδְ
  allocate(pv(vecx))
  allocate(interpo(vecx))
  allocate(u(2,vecx))
  allocate(v(2,vecx))
  u(1,1:vecx)=0.0
  v(1,1:vecx)=0.0
  dpv=(pmax-pmin)/(vecx-1)
  do i=1,vecx
     pv(i)=-log(pmax-dpv*(i-1))  ! ٤Ȥ.
     if(sondelogP(nt)>pv(i))then
        call interpo_search_1d( sondelogP, pv(i), interpo(i), int(undeff) )
        
        if(sondeU(interpo(i))/=undeff.and.sondeU(interpo(i)+1)/=undeff.and.sondeV(interpo(i))/=undeff.and.sondeV(interpo(i)+1)/=undeff)then
!        call interpolation_1d( sondeZ(interpo(i)), sondeZ(interpo(i)+1),  &
!  &          sondeU(interpo(i)), sondeU(interpo(i)+1), pv(i), u(2,i))
!        call interpolation_1d( sondelogP(interpo(i)), sondelogP(interpo(i)+1),  &
!  &          sondeV(interpo(i)), sondeV(interpo(i)+1), pv(i), v(2,i))
!write(*,*) sondeU(interpo(i)), sondeU(interpo(i)+1)
! ϾΥȥȤΤ褦ޤΤ˷׻٤Ǥ뤬,
! ǡ٤Ȥ, äȤᤤǶƤ褤Ȥ.
           u(2,i)=sondeU(interpo(i))
           v(2,i)=sondeV(interpo(i))
        else
           u(2,i)=undeff
           v(2,i)=undeff
        end if
     else
        u(2,i)=undeff
        v(2,i)=undeff
     end if
  end do

  call DclNewFrame

  call DclScalingPoint( sondedT, sondedP )
  call DclSetTransNumber( 2 )
  call DclSetWindow( tmin, tmax, pdmax, pdmin )
  call DclSetViewPort( vxmin, vxmax, vymin, vymax )
  call DclSetTransFunction

  call DclSetTitle( 'Temperature', 'height', '', '' )

  call DclDrawScaledAxis

  call UDISET('INDXMJ', 31)
  call UDISET('INDXMN', 31)
  call DclDrawContour( temp )
  call UDISET('INDXMJ', 22)
  call UDISET('INDXMN', 22)
  call DclDrawContour( pt )
  call UDISET('INDXMJ', 13)
  call UDISET('INDXMN', 13)
  call DclDrawContour( spt )
  call UDISET('INDXMJ', 1)
  call DclDrawContour( qvs )
  call DclDrawLine( sondedT, sondedP, index=43 )
  call DclDrawLine( sondedTD, sondedP, index=43, type=2 )
  call DclDrawTitle( 't', trim(title) )

  call GRFIG
  call DclSetWindow( 0.0, 1.0, pdmax, pdmin )
  call DclSetViewPort( vxmax, vxmax+0.1, vymin, vymax )
  call DclSetTransNumber( 2 )
  call DclSetTransFunction

  CALL UZLSET( 'LABELYR', .FALSE. )
  CALL UZLSET( 'LABELYL', .FALSE. )

  call DclDrawAxis( 'v', pdmax/40.0, pdmax/10.0, section=vxmax+0.1 )

  call UGLSET( 'LMSG', .false. )

  call DclDrawVectors( u, v )
write(*,*) u(2,:)

end subroutine


end module
