module Dcl_Automatic  ! Dclf90 ưǹԤ⥸塼

use dcl

contains

subroutine Dcl_2D_cont_shade( outname,  &
  &  x, y, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid,  &
  &  xg, yg )
  ! 2  2 ѿȥ顼ɤ褹.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in), optional :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in), optional :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, intent(in), optional :: xg(:,:)  ! x 륰åκɸ
  real, intent(in), optional :: yg(:,:)  ! y 륰åκɸ
                    ! Ǥΰ֥ǡ, ʣ,
                    ! Ǥ 2 İʾˤ.
                    ! ǡľǤϤʤ, åɤ
                    ! Ȥǽ.
                    ! 3 ܤ, xg(:,1)  yg(:,1)  1 ܤ
                    ! ɽ褦˻ꤹ뤳.
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclScalingPoint( xg(:,i), yg(:,i) )
     end do
  end if

  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  if(present(cont_num))then
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  else
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
  end if
  call DclDrawContour( contour )

  if(present(xg))then
     do i=1,size(xg,2)
        call DclDrawLine( xg(:,i), yg(:,i) )
     end do
  end if


  if(present(color_num))then
     call tone_bar( color_num, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  else
     call tone_bar( 56, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_MapPro( map_pro, outname,  &
  &  x, y, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title, form_typec,  &
  &  form_types, viewx_min, viewx_max, viewy_min,  &
  &  viewy_max, color_num, cont_num, nongrid )
  ! 2  2 ѿȥ顼ɤ褹.
  !  map_pro Ͽֹ, Ͽƥ⡼ɤڤؤ.
  use dcl
  implicit none
  integer, intent(in) :: map_pro  ! DCL ϿѴؿֹ
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ [deg]
  real, intent(in) :: y(:)  ! y γʻɸ [deg]
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in), optional :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in), optional :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  real, parameter :: pi=3.14159265
  real, parameter :: radius=6.38e6
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: uratio
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  real :: map_lat_min, map_lat_max, map_lon_min, map_lon_max
  real :: mlat2dis_min, mlat2dis_max

  nx=size(x)
  ny=size(y)

!--  rad ñ̤Ѵ
  map_lon_min=x(1)*pi/180.0
  map_lon_max=x(nx)*pi/180.0
  map_lat_min=y(1)*pi/180.0
  map_lat_max=y(ny)*pi/180.0

  mlat2dis_min=log(tan(0.25*pi+0.5*map_lat_min))
  mlat2dis_max=log(tan(0.25*pi+0.5*map_lat_max))

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ϿȼΥץ ---
!-- MapFit 롼Ѥ, Ͽޤ vp ŪѹΤ,
!-- νԤ.
!-- u ɸϤǤΥڥȤ, ĹĹ vp ˤ,
!-- û vp .
  uratio=(mlat2dis_max-mlat2dis_min)/(map_lon_max-map_lon_min)  ! u ɸϤǤ ratio
  if( uratio>1.0 )then
  ! y ĹΤ, vratio  vxmin, vxmax  0.5 ˽.
  ! ϰʲΤȤ : 
  ! vxmax+vxmin=1.0, vxmax-vxmin=(vymax-vymin)/uratio
  ! 򤽤줾򤯤, vymax, vymin ϴϤʤΤǰΤΤѤ,
  ! vxmax=0.5*(1.0+(vymax-vymin)/uratio)
  ! vxmin=0.5*(1.0-(vymax-vymin)/uratio)
     vx_max=0.5*(1.0+(vy_max-vy_min)/uratio)
     vx_min=0.5*(1.0-(vy_max-vy_min)/uratio)
  else
  ! x ĹΤ, vratio  vymin, vymax  0.5 ˽.
  ! ϰʲΤȤ : 
  ! vymax+vymin=1.0, vymax-vymin=uratio*(vxmax-vxmin)
  ! 򤽤줾򤯤, vxmax, vxmin ϴϤʤΤǰΤΤѤ,
  ! vymax=0.5*(1.0+(uratio*(vxmax-vxmin))
  ! vymin=0.5*(1.0-(uratio*(vxmax-vxmin))
     vy_max=0.5*(1.0+uratio*(vx_max-vx_min))
     vy_min=0.5*(1.0-uratio*(vx_max-vx_min))
  end if
!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetParm( 'MAP:LGRIDMN', .false. )
  call DclSetParm( 'MAP:INDEXMJ', 1 )
  call DclSetParm( 'MAP:dgridmj', 1. )

  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransNumber( map_pro )
  call DclFitMapParm
  call DclSetTransFunction

  call DclSetParm( 'GRAPH:LCLIP', .true. )
!     call DclDrawViewPortFrame( 1 )
  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxis( 'bt', 1.0, 0.5 )
  call DclDrawAxis( 'rl', 1.0, 0.5 )
!  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )
  call DclDrawMap( 'coast_world' )
  call DclDrawGlobe()

  call DclSetContourLabelFormat(form_typec)
  if(present(cont_num))then
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  else
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
  end if
  call DclDrawContour( contour )

  if(present(color_num))then
     call tone_bar( color_num, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  else
     call tone_bar( 56, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_calendar( outname,  &
  &  x, y, contour, shade, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title, date, days,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid )
  ! 2  2 ѿȥ顼ɤ褹. calender б
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  character(6), intent(in), optional :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in), optional :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS

  nx=size(x)
  ny=size(y)

!-- դͿƤ뤫ɽ
  write(*,*) "start day is", date%year, date%month, date%day

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( 0.0, real(days), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  if(present(cont_num))then
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  else
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
  end if
  call DclDrawContour( contour )

  if(present(color_num))then
     call tone_bar( color_num, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  else
     call tone_bar( 56, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_vec( outname,  &
  &  x, y, contour, shade, vecx, vecy, vnx, vny, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid )
  ! 2  3 ѿ, 顼, ٥ȥ褹.
  !  4 ѿƱ褬ǽȤʤ.
  ! Ū˱˥顼СĤΤ, ˥åȥ٥ȥ
  ! 󥿡󥿡Хβʸɽ.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(inout) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(inout) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vnx  ! x Υ٥ȥʻ (ְ)
  integer, intent(in) :: vny  ! y Υ٥ȥʻ (ְ)
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  character(6), intent(in), optional :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in), optional :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: factx, facty
  real, dimension(vnx,vny) :: um, vm  ! ٥ȥְͤ
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS
  intrinsic :: nint

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
  if(nx<2.or.vnx<2.or.ny<2.or.vny<2)then
     write(*,*) "*****ERROR***** : nx or ny or vnx or vny is less than 2."
     stop
  end if

!-- ٹ
  if(mod((nx-1),(vnx-1))/=0.and.mod((ny-1),(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx and ny."
  else
     if(mod((nx-1),(vnx-1))/=0.or.mod((ny-1),(vny-1))/=0)then
        if(mod((nx-1),(vnx-1))/=0)then
           write(*,*) "****WARNING**** : vnx is not the factor of nx."
        else
           write(*,*) "****WARNING**** : vny is not the factor of ny."
        end if
     end if
  end if

!-- ٥ȥδְ
  factx=real(nx-1)/real(vnx-1)
  facty=real(ny-1)/real(vny-1)

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(i,1)=vecx(1+nint(factx*(i-1)),1)
     vm(i,1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,j)=vecx(1,1+nint((j-1)*facty))
     vm(1,j)=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(i,j)=vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(i,j)=vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  if(present(cont_num))then
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  else
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
  end if
  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

  if(present(color_num))then
     call tone_bar( color_num, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  else
     call tone_bar( 56, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_2D_cont_shade_vec_calendar( outname,  &
  &  x, y, contour, shade, vecx, vecy, vnx, vny, cont_min, cont_max,  &
  &  shade_min, shade_max, x_title, y_title, date, days,  &
  &  form_typec, form_types, viewx_min, viewx_max,  &
  &  viewy_min, viewy_max, color_num, cont_num, nongrid )
  ! 2  3 ѿ, 顼, ٥ȥ褹.
  !  4 ѿƱ褬ǽȤʤ.
  ! Ū˱˥顼СĤΤ, ˥åȥ٥ȥ
  ! 󥿡󥿡Хβʸɽ.
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  real, intent(inout) :: contour(size(x),size(y))  ! 
  real, intent(inout) :: shade(size(x),size(y))  ! 顼ɤ
  real, intent(inout) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(inout) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vnx  ! x Υ٥ȥʻ (ְ)
  integer, intent(in) :: vny  ! y Υ٥ȥʻ (ְ)
  real, intent(in) :: cont_min  ! Ǿ
  real, intent(in) :: cont_max  ! 
  real, intent(in) :: shade_min  ! ɤǾ
  real, intent(in) :: shade_max  ! ɤ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  character(6), intent(in), optional :: form_typec  ! contour ѤΥեޥå
  character(6), intent(in), optional :: form_types  ! shade ѤΥեޥå
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer, intent(in), optional :: color_num  ! 顼ο
  integer, intent(in), optional :: cont_num  ! ο
  character(2), intent(in), optional :: nongrid  ! ֳֳʻҤˤ뤫.
                                        ! nongrid = 'ox' Ƚ.
                                        ! 1 ʸܤ, 2 ʸܤļ.
                                        ! o = ֳ, x = ֳ.
                                        ! ǥեȤǤ 'xx'.
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: factx, facty
  real, dimension(vnx,vny) :: um, vm  ! ٥ȥְͤ
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS

  nx=size(x)
  ny=size(y)

 !-- դͿƤ뤫ɽ
  write(*,*) "start day is", date%year, date%month, date%day

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
  if(nx<2.or.vnx<2.or.ny<2.or.vny<2)then
     write(*,*) "*****ERROR***** : nx or ny or vnx or vny is less than 2."
     stop
  end if

!-- ٹ
  if(mod((nx-1),(vnx-1))/=0.and.mod((ny-1),(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx and ny."
  else
     if(mod((nx-1),(vnx-1))/=0.or.mod((ny-1),(vny-1))/=0)then
        if(mod((nx-1),(vnx-1))/=0)then
           write(*,*) "****WARNING**** : vnx is not the factor of nx."
        else
           write(*,*) "****WARNING**** : vny is not the factor of ny."
        end if
     end if
  end if

!-- ٥ȥδְ
  factx=real(nx-1)/real(vnx-1)
  facty=real(ny-1)/real(vny-1)

!--  1 Ϥ
  um(1,1)=vecx(1,1)
  vm(1,1)=vecy(1,1)

  do i=2,vnx
     um(i,1)=vecx(1+nint(factx*(i-1)),1)
     vm(i,1)=vecy(1+nint(factx*(i-1)),1)
  end do

  do j=2,vny
     um(1,j)=vecx(1,1+nint((j-1)*facty))
     vm(1,j)=vecy(1,1+nint((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(i,j)=vecx(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
        vm(i,j)=vecy(1+nint(factx*(i-1)),1+nint(facty*(j-1)))
     end do
  end do

!-- ޤ ---

  call undef_CReSS2Dcl( nx, ny, 1, contour)
  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( 0.0, real(days), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call DclSetTransFunction

  if(present(nongrid))then
     if(nongrid(1:1)=='o')then
        call DclSetXGrid( x )
     end if
     if(nongrid(2:2)=='o')then
        call DclSetYgrid( y )
     end if
  end if

  call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

  call DclSetContourLabelFormat(form_typec)
  if(present(cont_num))then
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/cont_num )
  else
     call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
  end if
  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

  if(present(color_num))then
     call tone_bar( color_num, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  else
     call tone_bar( 56, shade_min, shade_max, vx_max+0.05, 0.875, vy_min, vy_max, form_types )
  end if

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL( judge, outname, lnum, pnum, lstep, pstep,  &
  &  xline, yline, xpoint, ypoint, x_title, y_title,  &
  &  viewx_min, viewx_max, viewy_min, viewy_max, xmin, xmax, ymin, ymax )
  ! 2 ʿˤʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  integer, intent(in) :: lnum  ! ܿ
  integer, intent(in) :: pnum  ! ݥȤμ
  integer, intent(in) :: lstep  !  1 ܤ
  integer, intent(in) :: pstep  ! 1 ΥݥȤθĿ
  real, intent(in) :: xline(lstep, lnum)  !  x ɸ
  real, intent(in) :: yline(lstep, lnum)  !  y ɸ
  real, intent(in) :: xpoint(pstep, pnum)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(pstep, pnum)  ! ݥȷ y ɸ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  real, intent(in), optional :: xmin  ! x Υպü
  real, intent(in), optional :: xmax  ! x Υձü
  real, intent(in), optional :: ymin  ! y Υպü
  real, intent(in), optional :: ymax  ! y Υձü
  integer :: i, j, k  ! ź
  integer, parameter :: lim=990  ! 饤󥤥ǥåκ
  integer :: nnum
  real :: vx_min, vx_max, vy_min, vy_max

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ޤ ---

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  if(present(xmin))then
     call DclSetWindow( xmin, xmax, ymin, ymax )
  else
     if(judge=='p'.or.judge=='a')then
        do i=1,pnum
           call DclScalingPoint( xpoint(:,j), ypoint(:,j) )
        end do
     end if

     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           call DclScalingPoint( xline(:,j), yline(:,j) )
        end do
     end if
     call DclFitScalingParm
  end if
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(judge=='p'.or.judge=='a')then
     if(pnum==1)then
        call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
     else
        do i=1,pnum
           call DclDrawMarker( xpoint(:,j), ypoint(:,j), type=j )
        end do
     end if
  end if

  if(judge=='l'.or.judge=='a')then
     if(lnum==1)then
        call DclDrawLine( xline(:,1), yline(:,1) )
     else
        nnum=lim/lnum
        do j=1,lnum
           call DclDrawLine( xline(:,j), yline(:,j), index=(100+nnum*(j-1)+1) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

!  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL_vec( outname,  &
  &  x, y, lnum, pnum, lstep, pstep, xline, yline, xpoint, ypoint,  & 
  &  vecx, vecy, vnx, vny, x_title, y_title,  &
  &  viewx_min, viewx_max, viewy_min, viewy_max )
  ! 2 ʿˤƥ٥ȥʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(*), intent(in) :: outname  ! դΥȥ
  real, intent(in) :: x(:)  ! x γʻɸ
  real, intent(in) :: y(:)  ! y γʻɸ
  integer, intent(in) :: lnum  ! ܿ
  integer, intent(in) :: pnum  ! ݥȤμ
  integer, intent(in) :: lstep  !  1 ܤ
  integer, intent(in) :: pstep  ! 1 ΥݥȤθĿ
  real, intent(in) :: xline(lstep, lnum)  !  x ɸ
  real, intent(in) :: yline(lstep, lnum)  !  y ɸ
  real, intent(in) :: xpoint(pstep, pnum)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(pstep, pnum)  ! ݥȷ y ɸ
  real, intent(in) :: vecx(size(x),size(y))  ! x Υ٥ȥ
  real, intent(in) :: vecy(size(x),size(y))  ! x Υ٥ȥ
  integer, intent(in) :: vnx  ! x Υ٥ȥʻ (ְ)
  integer, intent(in) :: vny  ! y Υ٥ȥʻ (ְ)
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  integer :: i, j, k  ! ź
  integer :: nx, ny
  real :: factx, facty
  real, dimension(vnx,vny) :: um, vm  ! ٥ȥְͤ
  real :: vx_min, vx_max, vy_min, vy_max
  real :: undef, RMISS

  nx=size(x)
  ny=size(y)

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- 顼
  if(nx<vnx.or.ny<vny)then
     write(*,*) "*****ERROR***** : vnx > nx or vny > ny."
     stop
  end if
!-- ٹ
  if(mod(nx,(vnx-1))/=0.or.mod(ny,(vny-1))/=0)then
     write(*,*) "****WARNING**** : vnx or vny is not the factor of nx or ny."
  end if

!-- ٥ȥδְ
  factx=real(nx)/real(vnx-1)
  facty=real(ny)/real(vny-1)

!--  1 Ϥ
     um(1,1)=vecx(1,1)
     vm(1,1)=vecy(1,1)
  do i=2,vnx
     um(i,1)=vecx(int(factx*(i-1)),1)
     vm(i,1)=vecy(int(factx*(i-1)),1)
  end do
  do j=2,vny
     um(1,j)=vecx(1,int((j-1)*facty))
     vm(1,j)=vecy(1,int((j-1)*facty))
  end do

  do j=2,vny
     do i=2,vnx
        um(i,j)=vecx(int(factx*(i-1)),int(facty*(j-1)))
        vm(i,j)=vecy(int(factx*(i-1)),int(facty*(j-1)))
     end do
  end do

!-- ޤ ---

!  call undef_CReSS2Dcl( nx, ny, 1, contour)
!  call undef_CReSS2Dcl( nx, ny, 1, shade)

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  call DclSetWindow( x(1), x(nx), y(1), y(ny) )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawScaledAxis
  call DclDrawTitle( 'b', x_title, 0.0 )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(pnum==1)then
     call DclDrawMarker( xpoint(:,1), yline(:,1) )
  else
     do i=1,pnum
        call DclDrawMarker( xpoint(:,j), yline(:,j), type=j )
     end do
  end if

  if(lnum==1)then
     call DclDrawLine( xline(:,1), yline(:,1) )
  else
     do j=1,lnum
        call DclDrawLine( xline(:,j), yline(:,j), index=(90+10*j+1) )
     end do
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine Dcl_PL_calendar( judge, outname, lnum, pnum, lstep, pstep,  &
  &  xline, yline, xpoint, ypoint, x_title, y_title, date, days,  &
  &  viewx_min, viewx_max, viewy_min, viewy_max, xmin, xmax, ymin, ymax )
  ! 2 ʿˤʣζ, ݥȤ褹.
  ! ͿȥݥȤϤ줾̸ĤƤ,
  ! ˤĤƤ, x, y ɸ 2 , ݥȤˤĤƤƱͤ 2 ,
  ! ˶ x, y ɸǤ 1 ܤζϢ³
  ! ǤǶܿ. ݥȤˤĤƤƱ.
  ! Ĥޤ, ȤưʲΤ褦Ѱդ.
  ! 3 ܤζ, 5 ΥݥȤ, ˤĤƤ 1 ܤζ
  ! ˤ 1000 ĤϢ³, ݥȤˤĤƤ 1 
  ! ݥȤ 100 Ȥ,
  ! xline(1000, 3), yline(1000, 3), xpoint(100, 5), y(100, 5)
  ! Ȥưɤ߹ޤФ褤.
  ! ΤȤ, ΰбطϰʲΤȤǤ.
  ! lnum = 3, pnum = 5, lstep = 1000, pstep = 100
  use dcl
  implicit none
  character(1), intent(in) :: judge  ! դμ
                ! 'p' = ݥȤΤ, 'l' = 饤Τ, 'a' = ξ.
                ! 褷ʤǤ, ߡɤ߹ޤɬפ.
  character(*), intent(in) :: outname  ! դΥȥ
  integer, intent(in) :: lnum  ! ܿ
  integer, intent(in) :: pnum  ! ݥȤμ
  integer, intent(in) :: lstep  !  1 ܤ
  integer, intent(in) :: pstep  ! 1 ΥݥȤθĿ
  real, intent(in) :: xline(lstep, lnum)  !  x ɸ
  real, intent(in) :: yline(lstep, lnum)  !  y ɸ
  real, intent(in) :: xpoint(pstep, pnum)  ! ݥȷ x ɸ
  real, intent(in) :: ypoint(pstep, pnum)  ! ݥȷ y ɸ
  character(*), intent(in) :: x_title  ! x Υȥ
  character(*), intent(in) :: y_title  ! y Υȥ
  type(dcl_date), intent(in) :: date  !  [yyyy:mm:dd]
  integer, intent(in) :: days  !  [day]
  real, intent(in), optional :: viewx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in), optional :: viewx_max  ! ӥ塼ݡȤ x κ
  real, intent(in), optional :: viewy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in), optional :: viewy_max  ! ӥ塼ݡȤ y κ
  real, intent(in), optional :: xmin  ! x Υպü
  real, intent(in), optional :: xmax  ! x Υձü
  real, intent(in), optional :: ymin  ! y Υպü
  real, intent(in), optional :: ymax  ! y Υձü
  integer :: i, j, k  ! ź
  integer, parameter :: lim=990  ! 饤󥤥ǥåκ
  integer :: nnum
  real :: vx_min, vx_max, vy_min, vy_max

!-- optional ν ---
  if(present(viewx_min))then
     vx_min=viewx_min
  else
     vx_min=0.2
  end if

  if(present(viewx_max))then
     vx_max=viewx_max
  else
     vx_max=0.8
  end if

  if(present(viewy_min))then
     vy_min=viewy_min
  else
     vy_min=0.2
  end if

  if(present(viewy_max))then
     vy_max=viewy_max
  else
     vy_max=0.8
  end if

!-- ޤ ---

  call UWSGXZ(.FALSE.)
  call UWSGYZ(.FALSE.)

  call DclNewFrame
  if(present(xmin))then
     call DclSetWindow( xmin, xmax, ymin, ymax )
  else
     if(judge=='p'.or.judge=='a')then
        do i=1,pnum
           call DclScalingPoint( xpoint(:,j), ypoint(:,j) )
        end do
     end if

     if(judge=='l'.or.judge=='a')then
        do j=1,lnum
           call DclScalingPoint( xline(:,j), yline(:,j) )
        end do
     end if
     call DclFitScalingParm
  end if
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )

  call DclSetTransFunction

 ! call DclShadeContourEx( shade )
  CALL UZLSET( 'LABELYL', .TRUE. )
  CALL UZLSET( 'LABELYR', .FALSE. )
  call DclDrawAxisCalendar( 'bt', date, nd=days )
  call DclDrawScaledAxis( 'lr' )
  call DclDrawTitle( 'l', y_title, 0.0 )
  call DclDrawTitle( 't', outname, 0.0, 2 )

!-- ݥȤȶ ---
!-- num ˱ do 롼פǲ󤹤Τ, num Ǥդ OK.
!-- num = 1 ξϹǸ
  if(judge=='p'.or.judge=='a')then
     if(pnum==1)then
        call DclDrawMarker( xpoint(:,1), ypoint(:,1) )
     else
        do i=1,pnum
           call DclDrawMarker( xpoint(:,j), ypoint(:,j), type=j )
        end do
     end if
  end if

  if(judge=='l'.or.judge=='a')then
     if(lnum==1)then
        call DclDrawLine( xline(:,1), yline(:,1) )
     else
        nnum=lim/lnum
        do j=1,lnum
           call DclDrawLine( xline(:,j), yline(:,j), index=(100+nnum*(j-1)+1) )
        end do
     end if
  end if

!  call DclSetContourLabelFormat(form_typec)
!  call DclSetContourLevel( cont_min, cont_max, (cont_max-cont_min)/10 )
!  call DclDrawContour( contour )

!  call DclDrawVectors( um, vm )

end subroutine

!---------------------------------------------------------

subroutine auto_title( head, time, title, forma, factor, unite )
!  ȯŸ, ưŪ˥դΥȥ
  implicit none
  character(*), intent(in) :: head  ! ȥإå
  integer, intent(in) :: time  ! 
  character(*), intent(inout) :: title  ! 륿ȥ
  character(6), intent(in), optional :: forma  ! ץȤƥեޥå
  integer, intent(in), optional :: factor  ! time factor
  character(*), intent(in), optional :: unite  ! unit
  character(6) :: formb
  character(8) :: tmpname
  integer :: facttime, len_num

  if(present(forma))then
     formb=forma
  else
     formb='(i8.8)'
  end if

  if(present(factor))then
     facttime=time/factor
  else
     facttime=time
  end if

  write(tmpname,formb) facttime

  len_num=len_trim(tmpname)

  if(present(unite))then
     title=trim(head)//'_(t='//tmpname(1:len_num)//trim(unite)//')"'
  else
     title=trim(head)//'_(t='//tmpname(1:len_num)//'[s])"'
  end if

end subroutine

!---------------------------------------------------------

subroutine tone_bar( color_num, shade_min, shade_max, vx_min, vx_max, vy_min, vy_max, form_types )  ! ˥ȡСư
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ뿧ο
  real, intent(in) :: shade_min  ! Ǿ
  real, intent(in) :: shade_max  ! 
  real, intent(in) :: vx_min  ! ӥ塼ݡȤ x κǾ
  real, intent(in) :: vx_max  ! ӥ塼ݡȤ x κ
  real, intent(in) :: vy_min  ! ӥ塼ݡȤ y κǾ
  real, intent(in) :: vy_max  ! ӥ塼ݡȤ y κ
  character(6), intent(in) :: form_types  ! ٥եޥå
  integer :: k
  real :: pi(2,color_num+1)
  real :: dp
  real :: coldim1(color_num+1), coldim2(color_num/2+1)

  call GRFIG
  call DclSetWindow( 0.0, 1.0, shade_min, shade_max )
  call DclSetViewPort( vx_min, vx_max, vy_min, vy_max )
  call GRSTRN(1)
  call DclSetTransFunction

  dp = (shade_max-shade_min)/color_num

  do k=1,color_num+1
     PI(1,K) = shade_min + (K-1)*DP
     PI(2,K) = shade_min + (K-1)*DP
  end do

!-- ȡĴ.

  do k=1,color_num+1
     coldim1(k)=PI(1,k)
  end do
  do k=1,color_num/2+1
     coldim2(k)=PI(1,2*k-1)
  end do

  call DclSetXGrid( (/0.0,1.0/) )
  call DclSetYGrid( PI(1,:) )
  call DclShadeContourEx( PI )
  CALL SLPVPR( 3 )
  CALL UZLSET( 'LABELYR', .TRUE. )
  CALL UZLSET( 'LABELYL', .FALSE. )
  CALL UYSFMT( form_types )
  CALL UYAXNM( 'R', coldim1, color_num+1, coldim2, color_num/2+1 )
  CALL UYAXNM( 'L', coldim1, color_num+1, coldim2, color_num/2+1 )
!  CALL UYAXDV( 'R', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )
!  CALL UYAXDV( 'L', (shade_max-shade_min)/real(color_num), (shade_max-shade_min)/real(0.5*color_num) )

end subroutine

!-----------------------------------------------------------

subroutine undef_CReSS2Dcl( nx, ny, nz, val )  ! CReSS ̤ͤ Dcl ̤ͤѴ롼
  !  3 Ǥ뤬, ǿ 1 ʤɤꤹ뤳Ȥ,
  ! 1, 2 ФƤѴǽ.
  use dcl
  implicit none
  integer, intent(in) :: nx  !  1 Ǥǿ
  integer, intent(in) :: ny  !  2 Ǥǿ
  integer, intent(in) :: nz  !  3 Ǥǿ
  real, intent(inout) :: val(nx,ny,nz)  ! Ѵ
  integer :: i, j, k  ! 
  real :: RMISS, undef  ! ̤

!-- »ͽ ---
!-- Dcl ¦ undef ͥå
      CALL GLRGET( 'RMISS', RMISS )
      CALL GLLSET( 'LMISS', .TRUE. )

!-- CReSS ¦ undef ͥå
      call undef_get( undef )
!write(*,*) "undef=", undef

  do k=1,nz
  do j=1,ny
     do i=1,nx
        if(val(i,j,k)==undef)then
           val(i,j,k)=RMISS
        end if
     end do
  end do
  end do
    

end subroutine

!--------------------------------------------------------

subroutine color_setting( color_num, val_min, val_max, col_tab,   &
  &                       col_max, col_min, col_bg )  ! 顼ޥåפοȿͤб뼫ư롼
  use dcl
  implicit none
  integer, intent(in) :: color_num  ! Ѥ륫顼μ
  real, intent(in) :: val_min  ! 顼κǾ
  real, intent(in) :: val_max  ! 顼κ
  integer, intent(in), optional :: col_tab  ! dcl Υ顼ơ֥
  integer, intent(in), optional :: col_min  ! Ѥ륫顼ֹκǾ(2)
  integer, intent(in), optional :: col_max  ! Ѥ륫顼ֹκ(2)
  logical, intent(in), optional :: col_bg  ! طʿؤ ǥեȤʤ.
  integer :: map_num  ! 顼ޥåפΥޥåֹ (optional °Ĥ뤳)
  integer :: i, j, k  ! ź
  integer :: ipat
  real :: dv  ! 顼ޥåפбͤ
  integer :: cmap_min, cmap_max
  real :: tlev1, tlev2

  if(present(col_tab))then
     map_num=col_tab
  else
     map_num=1
  end if

  if(present(col_min))then
     cmap_min=col_min
  else
     cmap_min=14
  end if

  if(present(col_max))then
     cmap_max=col_max
  else
     cmap_max=85
  end if

  if(present(col_bg))then
     call SWpSET( 'LFGBG', col_bg )     
  end if

 write(*,*) "col_tab", map_num

  call sgscmn(map_num)

  call UEITLV

  dv=(val_max-val_min)/color_num
  do k=1,color_num
     TLEV1=val_min+(k-1)*dv
     TLEV2=TLEV1+dv
     IPAT=(cmap_min+int((k-1)*(real(cmap_max)/real(color_num))))*1000+199
     CALL UESTLV( TLEV1, TLEV2, IPAT )
  end do


end subroutine

!---------------------------------------------------

subroutine undef_get( undef )  ! CReSS ΥǥեȤ̤ͤ롼
  implicit none
  real, intent(inout) :: undef  ! ̤

  undef = -1.0e+35

end subroutine


subroutine format_make( val_type, order_num, form_name, frac_num )  ! ͥ٥ѥեޥåȺ롼
  implicit none
  character(1), intent(in) :: val_type  ! ٥벽ѿη : f = ¿(ץꤹ), i = 
  character(1), intent(in) :: order_num  ! ɽ
  character(1), intent(in), optional :: frac_num  ! ¿ΤȤΤ, 
  character(*), intent(out) :: form_name

  select case(val_type)
  case('f')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('F')
     form_name='('//val_type//order_num//'.'//frac_num//')'
     form_name=trim(form_name)
  case('i')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  case('I')
     form_name='('//val_type//order_num//')'
     form_name=trim(form_name)
  end select

end subroutine format_make

end module
