module complex_initialize
! ʣѿν
! ʣǿǤʬô

  use Derivation
  use val_define
  use read_namelist
  use val_alloc
  use val_coord

contains

subroutine complex_init( val )
  implicit none
  complex, intent(inout) :: val(:,:,:)
  integer :: nx, ny, nz, i, j, k

  nx=size(val,1)
  ny=size(val,2)
  nz=size(val,3)

  do k=1,nz
     do j=1,ny
        do i=1,nx
           val(i,j,k)=(0.0,0.0)
        end do
     end do
  end do

end subroutine

subroutine complex_grad_1d( x, val, grad_val )
! ʣǿζʬԤ.
  implicit none
  real, intent(in) :: x(:)
  complex, intent(in) :: val(size(x))
  complex, intent(inout) :: grad_val(size(x))
  real :: rval(size(x)), ival(size(x))
  real :: r_grad_val(size(x)), i_grad_val(size(x))
  integer :: i, nx

  nx=size(x)

  do i=1,nx
     rval(i)=real(val(i))
     ival(i)=aimag(val(i))
  end do

  call grad_1d( x, rval, r_grad_val )
  call grad_1d( x, ival, i_grad_val )

  do i=1,nx
     grad_val(i)=r_grad_val(i)+img*i_grad_val(i)
  end do

end subroutine

subroutine complex_grad_2d( x, y, val, grad_valx, grad_valy )
! ʣǿζʬԤ.
  implicit none
  real, intent(in) :: x(:)
  real, intent(in) :: y(:)
  complex, intent(in) :: val(size(x),size(y))
  complex, intent(inout) :: grad_valx(size(x),size(y))
  complex, intent(inout) :: grad_valy(size(x),size(y))
  real :: rval(size(x)), ival(size(x),size(y))
  real :: r_grad_val(size(x),size(y)), i_grad_val(size(x),size(y))
  integer :: i, j, nx, ny

  nx=size(x)
  ny=size(y)

  do j=1,ny
     do i=1,nx
        rval(i,j)=real(val(i,j))
        ival(i,j)=aimag(val(i,j))
     end do
  end do

  do j=1,ny
     call grad_1d( x, rval(:,j), r_grad_val(:,j) )
     call grad_1d( x, ival(:,j), i_grad_val(:,j) )
  end do

  do j=1,ny
     do i=1,nx
        grad_valx(i,j)=r_grad_val(i,j)+img*i_grad_val(i,j)
     end do
  end do

  do i=1,nx
     call grad_1d( y, rval(i,:), r_grad_val(i,:) )
     call grad_1d( y, ival(i,:), i_grad_val(i,:) )
  end do

  do j=1,ny
     do i=1,nx
        grad_valy(i,j)=r_grad_val(i,j)+img*i_grad_val(i,j)
     end do
  end do

end subroutine

end module
