module make_init
! 初期値データを作成する.

  use gtool_history
  use Derivation
  use Algebra
  use Ellip_Slv
  use Phys_Const
  use val_define
  use read_namelist
  use val_alloc
  use val_coord

contains

subroutine make_initialize()

  implicit none

  integer :: i, j, k

  if(trim(adjustl(init_type))=='psi')then  ! psi -> omega

     call HistoryGet( trim(finame), 'val', psi_old )

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              psi_old(i,j)=undef
           end if
        end do
     end do

     do j=1,ny
        call laplacian_1d( x, psi_old(:,j), do2dx2(:,j), undef=undef )
        call grad_1d( x, psi_old(:,j), dodx(:,j), undef=undef )
     end do
     do i=1,nx
        call laplacian_1d( y, psi_old(i,:), do2dy2(i,:), undef=undef )
     end do

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              omega_old(i,j)=undef
           else
              omega_old(i,j)=-(do2dx2(i,j)+dodx(i,j)*x_inv(i)+do2dy2(i,j)*x2_inv(i))
           end if
        end do
     end do

  else  ! omega -> psi

     call HistoryGet( trim(finame), 'val', omega_old )

     do j=1,ny
        do i=1,nx
           if(calc_flag(i,j).eqv..false.)then
              omega_old(i,j)=undef
              pois_force(i,j)=undef
           else
              pois_force(i,j)=-omega_old(i,j)
           end if
        end do
     end do

     call Ellip_Jacobi_2d( x, y, pois_force, eps, boundary, psi_old,  &
  &                        bound_opt=bndp, c=x2_inv_2d, d=x_inv_2d,  &
  &                        undef=undef, inner_bound=ibp )

  end if

end subroutine

end module
