program advection
  use ffts  ! FFT ルーチン
  use file_operate  ! 結果ファイル出力
  use Math_Const
  use gtool_history
  implicit none
  integer :: nx  ! x 方向の切断波数
  real :: dt  ! 計算時間間隔
  integer :: nt  ! 計算ステップ数
  real :: xmin  ! x 座標左端
  real :: dx  ! x 座標格子間隔
  real :: Lx  ! domain
  real :: coe
  integer :: j, k
  real, allocatable, dimension(:) :: x  ! x 座標
  real, allocatable, dimension(:) :: y  ! スカラー変数
  real, allocatable, dimension(:) :: time  ! 時間
  complex, allocatable, dimension(:) :: fm1  ! スペクトル用
  complex, allocatable, dimension(:) :: fm2  ! スペクトル用
  complex, allocatable, dimension(:) :: fm_tmp  ! ダンプ出力用
  complex, parameter :: i=(0.0,1.0)

  namelist /input /nx,dt,nt,xmin,dx
  read(5,input)

  if(mod(nx,2)/=0)then
     write(*,*) "*** ERROR ***"
     write(*,*) "nx must be even number. Stop."
     stop
  end if

  allocate(x(0:2*nx))
  allocate(y(0:2*nx))
  allocate(time(nt+1))
  allocate(fm1(0:2*nx))
  allocate(fm2(0:2*nx))
  allocate(fm_tmp(0:2*nx))

  x=(/((xmin+dx*real(j)),j=0,2*nx)/)
  time=(/((dt*real(j-1)),j=1,nt+1)/)

  Lx=x(2*nx)-x(0)
  coe=pi*dt/Lx

  do j=0,2*nx
     y(j)=sin(x(j))
!     y(j)=exp(-(x(j)-0.5*real(2*nx+1)*dx)**2)
     fm_tmp(j)=y(j)
  end do

  call ffttp_1d( 2*nx+1, fm_tmp, fm1, 'r', 'o' )

!-- gtool history (netcdf dump)

  call HistoryCreate( &                             ! ヒストリー作成
    & file='advection.nc', title='spectral advecting model', &
    & source='Sample program of gtool_history/gtool5',   &
    & institution='GFD_Dennou Club davis project',       &
    & dims=(/'x','t'/), dimsizes=(/2*nx+1,0/),               &
    & longnames=(/'X-coordinate','time        '/),       &
    & units=(/'m','s'/),                                 &
    & origin=0.0, interval=real(nt*dt) )

  call HistoryPut( 'x', x )                            ! 次元変数出力

  call HistoryAddVariable( &                           ! 変数定義
    & varname='amp', dims=(/'x','t'/), &
    & longname='amplitude', units='1', xtype='float')

!-- 時間積分開始
  do j=1,nt
!-- CR 法で時間積分
     fm2(0)=fm1(0)
     do k=1,nx
        fm2(k)=((1.0-2.0*i*coe*real(k)-(coe*real(k))**2)/  &
  &            (1.0+(coe*real(k))**2))*fm1(k)
        fm1(k)=fm2(k)  ! 次ステップへ渡す
     end do

     do k=1,nx
        fm2(nx+k)=conjg(fm2(nx-k+1))  ! 計算不要な配列に結果を渡す
     end do

     call ffttp_1d( 2*nx+1, fm2, fm_tmp, 'i', 'o' )

     do k=0,2*nx  ! 実数への変換
        y(k)=real(fm_tmp(k))
     end do

     call HistoryPut( 'amp', y(0:2*nx) )                         ! 変数出力

  end do

  call HistoryClose

end program
