program make_init
!-- producing initial data of zeta
!-- Version Kuo et al. (2016).

  use gtool_history

  implicit none

  integer, parameter :: nc=10

!-- namelist variables

  integer :: nx, ny
  integer :: nnum
  real, allocatable, dimension(:) :: xr, yr
  double precision :: xmin, ymin, dx, dy
  double precision :: zetabar, a, b
  character(1000) :: fname

  integer :: i, j, k
  double precision :: r, theta, pr
  double precision, dimension(nc) :: tcx, tcy
  double precision, allocatable, dimension(:) :: x, y
  double precision, allocatable, dimension(:,:) :: zeta

  namelist /initial /nx, ny, xmin, ymin, dx, dy, fname,  &
  &                  tcx, tcy
  namelist /vprof /zetabar, nnum, a, b
  read(5,nml=initial)
  read(5,nml=vprof)

  if(nnum>nc)then
     write(*,*) "*** ERROR (main) *** : namelist variable 'nnum' is <=", nnum, '.'
     write(*,*) "STOP."
     stop
  end if

  allocate(x(nx))
  allocate(y(ny))
  allocate(xr(nx))
  allocate(yr(ny))
  allocate(zeta(nx,ny))

  x=(/((xmin+dx*dble(i-1)),i=1,nx)/)
  y=(/((ymin+dy*dble(j-1)),j=1,ny)/)

  xr=(/((xmin+dx*real(i-1)),i=1,nx)/)
  yr=(/((ymin+dy*real(j-1)),j=1,ny)/)

  zeta=0.0d0

!$omp parallel default(shared)
!$omp do schedule(runtime) private(i,j,r,pr,theta)

  do j=1,ny
     do i=1,nx
        if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)>0.0d0)then
           theta=datan((y(j)-tcy(1))/(x(i)-tcx(1)))
        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)>0.0d0)then
           theta=dabs(dacos(-1.0d0))-datan((y(j)-tcy(1))/dabs(x(i)-tcx(1)))
        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)<0.0d0)then
           theta=dabs(dacos(-1.0d0))+datan(dabs(y(j)-tcy(1))/dabs(x(i)-tcx(1)))
        else if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)<0.0d0)then
           theta=2.0d0*dabs(dacos(-1.0d0))-datan(dabs(y(j)-tcy(1))/(x(i)-tcx(1)))
        else if(x(i)-tcx(1)==0.0d0.and.y(j)-tcy(1)<0.0d0)then
           theta=1.5d0*dabs(dacos(-1.0d0))
        else if(x(i)-tcx(1)==0.0d0.and.y(j)-tcy(1)>0.0d0)then
           theta=0.5d0*dabs(dacos(-1.0d0))
        else if(x(i)-tcx(1)>0.0d0.and.y(j)-tcy(1)==0.0d0)then
           theta=0.0d0
        else if(x(i)-tcx(1)<0.0d0.and.y(j)-tcy(1)==0.0d0)then
           theta=dabs(dacos(-1.0d0))
        end if

        r=dsqrt(((x(i)-tcx(1))/a)**2+((y(j)-tcy(1))/b)**2)
        r=r*(1.0d0-0.3d0*dsin(nnum*theta))
        if(r<1.0d0)then
           pr=1.0d0-dexp(-(30.0d0/r)*dexp(-1.0d0/(1.0d0-r)))
        else if(r==0.0d0)then
           pr=1.0d0
        else
           pr=0.0d0
        end if

        zeta(i,j)=zetabar*pr

     end do
  end do

!$omp end do
!$omp end parallel

  call HistoryCreate( file=trim(adjustl(fname)), title='BAROTRO initial data', &
  & source='test', institution='test', dims=(/'x', 'y'/),  &
  & dimsizes=(/ nx, ny /),  &
  & longnames=(/'X-coordinate','Y-coordinate'/),  &
  & units=(/'m', 'm'/) )

  call HistoryPut( 'x', xr )
  call HistoryPut( 'y', yr )

  call HistoryAddVariable( varname='zeta', dims=(/'x','y'/), &
  &    longname='vorticity', units='s-1', xtype='double' )

  call HistoryAddVariable( varname='xd', dims=(/'x'/), &
  &    longname='X-coord double', units='m', xtype='double' )

  call HistoryAddVariable( varname='yd', dims=(/'y'/), &
  &    longname='Y-coord double', units='m', xtype='double' )

  call HistoryPut( 'zeta', zeta )
  call HistoryPut( 'xd', x )
  call HistoryPut( 'yd', y )

  call HistoryClose()

end program
