subroutine p2z_conv( p, z, ui, vi, wi, phi, ti, qi,  &
  &                  uo, vo, wo, po, to, qo )
! Interpolating p-coord to z-coord.
! maintaining thermal wind balance.

  implicit none

  real, intent(in) :: p(:)          ! original pressure coordinate [Pa]
  real, intent(in) :: z(size(p))    ! converting geometric coordinate [m]
  real, intent(in) :: ui(:,:,size(p))   ! before zonal velovity [m/s]
  real, intent(in) :: vi(size(ui,1),size(ui,2),size(p))
                                    ! before meridional velovity [m/s]
  real, intent(in) :: wi(size(ui,1),size(ui,2),size(p))
                                    ! before vertical velovity [Pa/s]
  real, intent(in) :: phi(size(ui,1),size(ui,2),size(p))
                                    ! before geopotential height [m]
  real, intent(in) :: ti(size(ui,1),size(ui,2),size(p))
                                    ! before temperature [K]
  real, intent(in) :: qi(size(ui,1),size(ui,2),size(p))
                                    ! before water vapor mixing ratio [kg/kg]
  real, intent(inout) :: uo(size(ui,1),size(ui,2),size(p))
                                    ! after zonal velovity [m/s]
  real, intent(inout) :: vo(size(ui,1),size(ui,2),size(p))
                                    ! after meridional velovity [m/s]
  real, intent(inout) :: wo(size(ui,1),size(ui,2),size(p))
                                    ! after vertical velovity [m/s]
  real, intent(inout) :: po(size(ui,1),size(ui,2),size(p))
                                    ! after pressure [Pa]
  real, intent(inout) :: to(size(ui,1),size(ui,2),size(p))
                                    ! after temperature [K]
  real, intent(inout) :: qo(size(ui,1),size(ui,2),size(p))
                                    ! after water vapor mixing ratio [kg/kg]

  integer :: i, j, k, nx, ny, nz

  nx=size(ui,1)
  ny=size(ui,1)
  nz=size(p)

  do k=1,nz
     
  end do

end subroutine p2z_conv
