program initial_make
!  ǥη׻ɬפʽͥեץ
!  ɬפ˱ƥν񤭴ǽ.
!  ɤ߹ॵǥ󥰤ǱľʻҤꤹ.
  use file_operate
  use Thermo_Const
  use Math_Const
  use Phys_Const
  use Thermo_Function
  use Thermo_Routine
  use Algebra
  use Typhoon_analy
  use gtool_history
  use derivation
  use max_min

  implicit none

!-- namelist valiables
  integer :: nr, nz
  real :: dr, dz
  character(4) :: bc
  character(80) :: fname
  character(80) :: sound_name  ! ǥ󥰥ե̾

!-- internal valiables
  integer :: i, j, k
  integer :: maxnx, maxny, maxnz
  integer :: line_n
  real, allocatable, dimension(:) :: r, z, zd  ! о 2 ư, ľɸ
  real, allocatable, dimension(:) :: rm, vm  ! ƹ٤Ǥκ® MWR
  real, allocatable, dimension(:) :: r1, r2  ! inner, outer core boundary
  real, allocatable, dimension(:) :: pres_s, temp_s, pt_s, rho_s  ! ǥ
  real, allocatable, dimension(:,:) :: v0, pres, qv  ! , , ǮΨ
  real, allocatable, dimension(:,:) :: theta0, rho  ! β, ̩
  real, allocatable, dimension(:,:) :: x  ! ɸѿ
  real, allocatable, dimension(:,:) :: coril  ! ꥪѥ᡼
  real, allocatable, dimension(:,:) :: N2  ! Ͽư **2
  character(20), allocatable :: val(:,:)
  real :: nibun_left, nibun_right, func_left, func_right
  real :: err, max_val
  real, allocatable, dimension(:) :: ac

!-- constant value
  integer, parameter :: sline=2  ! ǥ󥰥եɤФ
  integer, parameter :: n=1  ! eye Ǥ®٤η
  integer, parameter :: m_bell=2  ! ǮǮΥ٥ؿμ
  real, parameter :: x1=300.0e3
  real, parameter :: r_qv=-2.0e3   ! qv  rm εΥ
  real, parameter :: dRm=16.0/18.0  ! Rmax η (dr/dz)
  real, parameter :: rmax=30.0e3  ! ɽ̤Ǥ Rmax
  real, parameter :: vmax=50.0  ! ɽ̤Ǥ Vmax
  real, parameter :: z_v0=18.0e3  ! vmax ˤʤ (ɽ餳ޤ˸)
  real, parameter :: z_qv=18.0e3  ! qv ˤʤ
  real, parameter :: dr12=20.0e3  ! r1  r2 εΥ
  real, parameter :: err_max=1.0e-5  ! ʬˡμ«

!-- function name
  real :: func_a, Bell

!-- namelist Υѥ᡼
  namelist /input /nr, nz, dr, dz, bc, fname, sound_name
  read(5,nml=input)

!-- γ
  allocate(r(nr))
  allocate(z(nz))
  allocate(zd(nz))  ! ǮǮʬ۷׻Ѥ.
  allocate(rm(nz))
  allocate(vm(nz))
  allocate(r1(nz))
  allocate(r2(nz))
  allocate(pres_s(nz))
  allocate(temp_s(nz))
  allocate(pt_s(nz))
  allocate(rho_s(nz))
  allocate(val(4,nz))
  allocate(v0(nr,nz))
  allocate(pres(nr,nz))
  allocate(qv(nr,nz))
  allocate(theta0(nr,nz))
  allocate(rho(nr,nz))
  allocate(x(nr,nz))
  allocate(coril(nr,nz))
  allocate(N2(nr,nz))
  allocate(ac(nz))

  coril=2.0*omega*sin(20.0*pi/180.0)

!-- ǥ󥰤ܾǮϳѿľɸ.
!-- ǥ󥰤Υǡ namelist ꤵƤΤƱ.

  call read_file_text( trim(sound_name), 4, nz, val, skip=sline )

  do i=1,nz
     read(val(1,i),*) z(i)
     read(val(2,i),*) temp_s(i)
     read(val(3,i),*) pres_s(i)
     read(val(4,i),*) pt_s(i)
     rho_s(i)=TP_2_rho( temp_s(i), pres_s(i) )
write(*,*) rho_s(i)
  end do

!-- ɸͤ
  r=(/(dr*real(i-1),i=1,nr)/)

!-- ɬפʥѥ᡼
  rm(1)=rmax
  vm(1)=vmax
  do j=2,nz
     rm(j)=rm(1)+dRm*z(j)
     vm(j)=vm(1)-vm(1)*(z(j)/z_v0)
!     vm(j)=vm(1)*func_a((z_v0-z(j))/z_v0)
  end do

!-- r1, r2 η (Willoughby 2006)
  do j=1,nz
     ac(j)=(real(n)*x1)/(real(n)*x1+rm(j))
!-- r1 뤿, ͤ 0, 1 Ȥʬˡ
     nibun_left=0.0
     nibun_right=1.0
     func_left=func_a(nibun_left)-ac(j)
     func_right=func_a(nibun_right)-ac(j)
     do while(func_left>err_max)
        err=0.0
        func_left=func_a((nibun_left+nibun_right)*0.5)-ac(j)
        func_right=func_a(nibun_right)-ac(j)
        if(func_left*func_right<0.0)then
           nibun_left=(nibun_left+nibun_right)*0.5
        else
           nibun_right=(nibun_left+nibun_right)*0.5
        end if
     end do
     r1(j)=rm(j)-dr12*0.5*(nibun_left+nibun_right)
     r2(j)=r1(j)+dr12
  end do

  do j=1,nz
     do i=1,nr
        x(i,j)=(r(i)-r1(j))/(r2(j)-r1(j))
     end do
  end do

!-- ͤ
!-- 
  do j=1,nz
     do i=1,nr
        if(r(i)<r1(j))then
           v0(i,j)=vm(j)*(r(i)/rm(j))**n
        else
           if(r1(j)<=r(i).and.r(i)<=r2(j))then
              v0(i,j)=(vm(j)*(r(i)/rm(j))**n)*(1.0-func_a(x(i,j)))  &
  &                   +(vm(j)*exp(-(r(i)-rm(j))/x1))*func_a(x(i,j))
           else
              v0(i,j)=vm(j)*exp(-(r(i)-rm(j))/x1)
           end if
        end if
        if(z(j)>=z_v0)then
           v0(i,j)=0.0
        end if
     end do
  end do

!-- ǥ󥰤ȼоήϳءʿվ.

  call hydro_grad_eqb( r, z, coril, v0, pres_s, rho_s, pres, rho )

do j=1,nz
do i=1,nr
if(rho(i,j)<=0.0)then
write(*,*) "solv afte", rho(i,j), i, j
end if
end do
end do
!-- Фɬפ pt ׻

  do j=1,nz
     do i=1,nr
        theta0(i,j)=theta_dry( rhoP_2_T( rho(i,j), pres(i,j) ), pres(i,j) )
     end do
  end do

!-- ǮΨη׻
!-- Ͽưη׻
  do i=1,nr
     call grad_1d( z, theta0(i,:), N2(i,:) )
     do j=1,nz
        N2(i,j)=g*N2(i,j)/theta0(i,j)
     end do
  end do

!  call max_val_2d( N2, maxnx, maxny, max_val )  ! ͤŬѹ
  max_val=1.5e-4

!-- zd 
  zd=(/(((z_qv-z(j))/(z_qv-5.0e3)),j=1,nz)/)

  do j=1,nz
     do i=1,nr
        qv(i,j)=max_val*func_a(zd(j))*Bell( m_bell, x(i,j) )
     end do
  end do


!-- եؤν񤭹

!-- ʲ GrADS 
!  call write_file( trim(fname), nr, nz, 1, v0 )
!  call write_file( trim(fname), nr, nz, 2, pres, mode='old' )
!  call write_file( trim(fname), nr, nz, 3, theta0, mode='old' )
!  call write_file( trim(fname), nr, nz, 4, rho, mode='old' )
!  call write_file( trim(fname), nr, nz, 5, qv, mode='old' )

!-- ʲ netcdf 
  call HistoryCreate( file=trim(fname), title='SEQ initial data', &
    & source='test', institution='test', dims=(/'r','z'/), dimsizes=(/nr,nz/),  &
    & longnames=(/'r-coordinate','z-coordinate'/),  &
    & units=(/'m','m'/), origin=0.0, interval=0.0 )

write(*,*) "########"
  call HistoryPut( 'r', r )
  call HistoryPut( 'z', z )
write(*,*) "########"

  call HistoryAddVariable( varname='v', dims=(/'r','z'/), &
    & longname='tangential wind', units='m/s', xtype='float')

write(*,*) "########"
  call HistoryPut( 'v',v0 )

write(*,*) "########"
  call HistoryAddVariable( varname='pres', dims=(/'r','z'/), &
    & longname='pressure', units='Pa', xtype='float')

  call HistoryPut( 'pres',pres )

write(*,*) "########"
  call HistoryAddVariable( varname='theta0', dims=(/'r','z'/), &
    & longname='potential temperature', units='K', xtype='float')

  call HistoryPut( 'theta0', theta0 )

  call HistoryAddVariable( varname='rho', dims=(/'r','z'/), &
    & longname='density', units='kg/m3', xtype='float')

  call HistoryPut( 'rho', rho )

  call HistoryAddVariable( varname='qv', dims=(/'r','z'/), &
    & longname='heating rate', units='J/s', xtype='float')

  call HistoryPut( 'qv',qv )

  call HistoryClose

!-- λΤΤ餻

  write(*,*) "initial_make is normally conplete."

end program


real function func_a( val )
  implicit none
  real, intent(in) :: val  ! ɸѿ

  if(val<=0.0)then
     func_a=0.0
  end if

  if(val>=1.0)then
     func_a=1.0
  end if

  if(val>0.0.and.val<1.0)then
     func_a=(10.0-15.0*val+6.0*val*val)*val*val*val
  end if

  return

end function


real function Bell( n, val )
!  Willoughby 2006 󾧤줿٥뷿ؿ׻.
  implicit none
  integer, intent(in) :: n  ! 
  real, intent(in) :: val  ! 

  if(val>=0.0.and.val<=1.0)then
     Bell=(2.0**(2*n))*((val*(1.0-val))**n)
  else
     Bell=0.0
  end if

  return

end function
