# -*- coding: japanese-cp932 -*-
require "numru/gfdnavi_data/knowledge"

module NumRu::GfdnaviData
  class KnowledgeRemote < NumRu::GfdnaviData::Knowledge

    def to_knlge
      get_object("knlge")
    end

    def initialize(hash={})
      @@figure_paths    = []
      @@figure_captions = []
      super(hash)
    end

    # == KnowledgeRemotep̃\bh`B
    #    app/models/knowledge.rb Œ`ꂽ\bh𗘗p
    meths = ["category","creator","textbody","default_layout",\
             "horizontal_figures","figures_size_height_or_width", \
             "figures_size_units","figures_size_number",\
             "comment_on","comment_number"]
    meths.collect!{|me| /\A(.+)_id\z/ =~ me ? $1 : me}
    meths += ["get_contents", "relational_images", "relational_variables",\
              "figures", "insert_figures", "swap_figures", "delete_figure",\
              "comments", "make_new_comment", "save", "delete"]

    # * L̖OɂāAL̓eŃ\bh`
    meths.each do |name|
        eval <<-EOL, binding, __FILE__, __LINE__+1
        def #{name}=(arg)
          get_object("knlge") unless @new_data
          @representation[\"knlge\"] ||= {\"gfdnavi_knowledge\"=>Hash.new}
          @representation[\"knlge\"][\"gfdnavi_knowledge\"][\"#{name}\"] = arg
        end
        EOL

        eval <<-EOL, binding, __FILE__, __LINE__+1
        def #{name}
          unless @representation[\"knlge\"] && @representation[\"knlge\"][\"gfdnavi_knowledge\"]
            return nil
          end
          @representation[\"knlge\"][\"gfdnavi_knowledge\"][\"#{name}\"]
        end
        EOL
    end

    # == 摜𖖔ɑ}郁\bh
    #    @representation ɉ摜 URL  YAML ̂
    #    (YAML͕̂̔z܂Ƃ߂Ĉ̕ɂ邽)
    #    }͉摜ꖇƂȂB
    def add_figure(image, caption)
      # QƂA@@figure_paths  @@figure_captions ̒gɒǋLĂ
      unless caption
        caption = ""
      end

      if String === image
        @@figure_paths    << image
      else
        # @@figure_paths    << image.url
        @@figure_paths    << image.path  # http://͂̎_łȂƂɂ
        # knowledgeo^ƂȂpathAłȂȂurlƂ̂
        # ẑ͂B
      end
      @@figure_captions << caption

      # Local(T[o)֕𑗂B
      # ́ALocal figures= \bḧƂȂ(add_figure ł͂ȂB)
      # Local̕ł́Aꂽ YAML t@CQƂA̐}xɓdlɂȂĂB
      # Remote  add_figure Ăяox @@figure_paths  @@figure_captions ̒g
      # ǋLĂA Hash ̒gXVĂB
      @representation["knlge"] ||= {"gfdnavi_knowledge"=>Hash.new}
      @representation["knlge"]["gfdnavi_knowledge"]["figures"] = String.new
      @representation["knlge"]["gfdnavi_knowledge"]["figures"] = YAML.dump(@@figure_paths + @@figure_captions)
    end

    def update_save_data(hash)
      # * hash 󂯎鑤(Local, T[o) 
      #   gl.key = value Ƃ`ɂȂB
      #   ܂Akey Ƃ\bhɁA value ƂnB
      #   value ͕̂ݑΉB
      hash.update(@representation["knlge"]["gfdnavi_knowledge"])
    end
  end
end
