require File.dirname(__FILE__) + '/../test_helper'

class CrossControllerTest < ActionController::TestCase
  fixtures :nodes, :directories, :variables, :draw_methods, :value_types, :functions, :function_arguments, :function_outputs, :images, :knowledges, :keyword_attributes, :users, :groups, :node_relations
  test "index" do
    # index
    get :index
    assert_response :success
  end

  test "check box" do
    get :index
    xhr :post, :check_box
    assert_response :success
  end

  test "check box_direct" do
    get :check_box # direct access by robots
    assert_response :redirect
  end

  test "reset" do
    get :reset
    assert_response :redirect
  end

  #test "show_keyvalues" do
  #  get :index
  #  xhr :post, :show_keyvalues # appropriate parameters should be given
  #  assert_response :success
  #end

  test "show_keyvalues" do
    get :show_keyvalues# direct access by robots
    assert_response :redirect
  end


  #test "hide_keyvalues" do
  #  get :index
  #  xhr :post, :hide_keyvalues # appropriate parameters should be given
  #  assert_response :success
  #end

  test "hide_keyvalues" do
    get :hide_keyvalues# direct access by robots
    assert_response :redirect
  end

  #test "close_subpathtree" do
  #  get :index
  #  xhr :post, :close_subpathtree # appropriate parameters should be given
  #  assert_response :success
  #end

  test "close_subpathtree_direct" do
    get :close_subpathtree # direct access by robots
    assert_response :redirect
  end

  #test "get_subpathtree" do
  #  get :index
  #  xhr :post, :get_subpathtree # appropriate parameters should be given
  #  assert_response :success
  #end

  test "get_subpathtree_direct" do
    get :close_subpathtree # direct access by robots
    assert_response :redirect
  end

  test "cross_kw" do
    get :index
    xhr :post, :cross_kw
    assert_response :success
  end

  test "cross_kw_direct" do
    get :cross_kw # direct access by robots
    assert_response :redirect
  end

  test "cross_freeword" do
    get :index
    xhr :post, :cross_freeword
    assert_response :success
  end

  test "cross_freeword_direct" do
    get :cross_freeword # direct access by robots
    assert_response :redirect
  end

  test "cross_space" do
    get :index
    xhr :post, :cross_space
    assert_response :success
  end

  test "cross_space_direct" do
    get :cross_space # direct access by robots
    assert_response :redirect
  end

  test "cross_time" do
    get :index
    xhr :post, :cross_time
    assert_response :success
  end

  test "cross_time_direct" do
    get :cross_time # direct access by robots
    assert_response :redirect
  end

  test "queryconditions_selection" do
    get :index
    xhr :post, :queryconditions_selection
    assert_response :success
  end

  test "queryconditions_selection_direct" do
    get :queryconditions_selection # direct access by robots
    assert_response :redirect
  end

  test "get_servers" do
    get :index
    xhr :post, :get_servers
    assert_response :success
  end

  test "get_servers_direct" do
    get :get_servers # direct access by robots
    assert_response :redirect
  end

  test "nodetype_selection" do
    get :index
    xhr :post, :nodetype_selection
    assert_response :success
  end

  test "nodetype_selection_direct" do
    get :nodetype_selection # direct access by robots
    assert_response :redirect
  end
end
