# load configuration for gfdnavi

require "ftools"
require "yaml"
require "rubygems"
require "action_mailer"

def gfdnavi_path( path )
  path = path.gsub( /RAILS_ROOT/, File.expand_path(RAILS_ROOT) )
  path.sub(/\/$/, "")
end

def gfdnavi_configuration( key, allow_nil = false )
  val = @gfdnavi_configuration[key]
  if allow_nil || val
    return val
  else
    STDERR.print <<-EOS
*************************
 Error occuered while reading the gfdnavi configuration file (#{@gfdnavi_configuration_file}).
 Key "#{key}" was not found in your configuration file.
 See config/gfdnavi.yml.example and you need to update it.
*************************
    EOS
    abort
  end
end


@gfdnavi_configuration_file = File.join(File.dirname(__FILE__), 'gfdnavi.yml')
begin
  @gfdnavi_configuration = YAML::load( File.read(@gfdnavi_configuration_file) )
rescue IOError, SystemCallError
  $! = nil
  STDERR.print <<-EOS
*************************
 Error occuered while reading the gfdnavi configuration file (#{@gfdnavi_configuration_file}).
 You probably need to copy config/gfdnavi.yml.example (and to edit it if needed).
 *************************
  EOS
  abort
end

if (disp = gfdnavi_configuration('display',true))
  STDERR.print "'display' is obsolete; use 'DISPLAY' in 'env'"
  ENV['DISPLAY'] = disp
end

env = gfdnavi_configuration('env', true)
if Hash === env
  env.each{|key, val|
    ENV[key] = val
  }
elsif ! env.nil?
  raise "env must be a Hash"
end

RAILS_ENV.replace(ENV['RAILS_ENV']) if defined?(RAILS_ENV) && ENV['RAILS_ENV']

require File.join(File.dirname(__FILE__), 'boot')


GFDNAVI_DATA_PATH = gfdnavi_path( gfdnavi_configuration('data_path') )
GFDNAVI_PUBLIC_PATH = File.join(File.expand_path(RAILS_ROOT), 'public')
if Regexp.new('^'+GFDNAVI_PUBLIC_PATH+'(.*)') =~ GFDNAVI_DATA_PATH
  # data are directly accessible
  GFDNAVI_DATA_URL_PREFIX = $1                   # path after '/public'
  #  GFDNAVI_DATA_URL_PREFIX.sub!(/([^\/])$/,'\1/')     # Add trailing '/'
else
  # data are NOT directly accessible
  GFDNAVI_DATA_URL_PREFIX = nil
end

GFDNAVI_REMOTE_DATA_PATHS = gfdnavi_configuration('remote_data_paths',true)
if GFDNAVI_REMOTE_DATA_PATHS and !GFDNAVI_REMOTE_DATA_PATHS.is_a?(Array)
  raise "gfdnavi config file error : remote_data_paths must be an array"
end

GFDNAVI_TEMP_DATA_PATH = gfdnavi_path( gfdnavi_configuration('temp_data_path') )
unless /^#{GFDNAVI_PUBLIC_PATH}/ =~ GFDNAVI_TEMP_DATA_PATH
  raise "temp_data_path must be under public path (#{GFDNAVI_PUBLIC_PATH})"
end
GFDNAVI_DIAGRAM_PATH = gfdnavi_path( gfdnavi_configuration('diagram_path') )
unless /^#{GFDNAVI_PUBLIC_PATH}/ =~ GFDNAVI_DIAGRAM_PATH
  raise "diagram_path must be under public path (#{GFDNAVI_PUBLIC_PATH})"
end
GFDNAVI_USER_PATH = gfdnavi_path( gfdnavi_configuration('user_path') )
raise("Name of the user directory must be 'usr'") if File.basename(GFDNAVI_USER_PATH) != 'usr'

GFDNAVI_WORK_PATH = gfdnavi_path( gfdnavi_configuration('work_path') )


[GFDNAVI_DATA_PATH, GFDNAVI_DIAGRAM_PATH, GFDNAVI_USER_PATH, GFDNAVI_WORK_PATH].each{|path|
  File.makedirs(path) unless File.exist?(path)
}

GFDNAVI_DISABLE_DIAGRAM_CACHE = (gfdnavi_configuration("disable_diagram_cache",true) == true)
unless GFDNAVI_DISABLE_DIAGRAM_CACHE
  GFDNAVI_DIAGRAM_CACHE_PATH = gfdnavi_path( gfdnavi_configuration('diagram_cache_path') )
  File.makedirs(GFDNAVI_DIAGRAM_CACHE_PATH) unless File.exist?(GFDNAVI_DIAGRAM_CACHE_PATH)
end


GFDNAVI_IGNORED_DIRS = gfdnavi_configuration('ignored_dirs')

GFDNAVI_DEBUG = (gfdnavi_configuration("debug",true) == true)

GFDNAVI_BENCHMARK = (gfdnavi_configuration("benchmark",true) == true)

GFDNAVI_DISABLE_USER = (gfdnavi_configuration("disable_user",true) == true)

GFDNAVI_GOOGLE_MAP_KEY = gfdnavi_configuration('google_map_key')

GFDNAVI_PASSPHRASE = gfdnavi_configuration('passphrase')

GFDNAVI_SECRET = gfdnavi_configuration('secret')

GFDNAVI_SESSION_DURATION = gfdnavi_configuration('session_duration')

admin = gfdnavi_configuration('admin')
GFDNAVI_ADMIN_NAME = admin['name']
GFDNAVI_ADMIN_EMAIL = admin['email']

GFDNAVI_ENABLE_EMAIL = (gfdnavi_configuration("enable_email",true) == true)

if GFDNAVI_ENABLE_EMAIL
  ActionMailer::Base.smtp_settings = gfdnavi_configuration('smtp')
end

GPHYS_READ_SIZE_LIMIT_1 = sl = 
    gfdnavi_configuration("soft_limit_array_size",true)
GPHYS_READ_SIZE_LIMIT_2 = hl = 
    gfdnavi_configuration("hard_limit_array_size",true)
if hl && sl && hl <= sl
  raise "hard limit must be greather than soft limit" 
end

# clean up
@gfdnavi_configuration_file = nil
@gfdnavi_configuration = nil
