class NodeController < ApplicationController

  layout "gfdnavi"

  before_filter :login_required, :only => :change_mode

  def change_mode
    if GFDNAVI_DISABLE_USER || !(user = session[:user])
      redirect_back_or_default :controller => "search", :action => "index"
      return
    end
    path = params[:path]
    unless node = Node.find(:first, :conditions => ["path=?",path], :user => user)
      redirect_back_or_default :controller => "search", :action => "index"
      return
    end
    unless user.super_user? || node.owner == user
      redirect_back_or_default :controller => "search", :action => "index"
      return
    end
    case request.method
    when :post
      if Array === (rgs=params[:rgroups])
        if rgs[0] == 'everyone'
          node.other_mode = 4
          rgs.shift
        else
          node.other_mode = 0
        end
        if rgs.length > 0
          node.set_rgroups(rgs)
        else
          node.rgroups = 0
        end
      else
        node.other_mode = 0
        node.rgroups = 0
      end
      if Array === (wgs=params[:wgroups]) && wgs.length > 0
        node.set_wgroups(wgs)
      else
        node.wgroups = 0
      end
      if node.update
        flash[:notice] = "update sucessed"
      else
        flash[:notice] = "update failed"
      end
      redirect_back_or_default :controller => "search", :action => "index"
      return
    when :get
      @node = node
      @groups = user.belonging_groups
    end
  end

end
