! GTContSave - }ϐƂĕۑ
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine GTContSave(cont, name, name_result)
    use gtgraph_generic, only: Save, GTGraphSaveName
    use gtgraph_types, only: GT_CONTOURS
    use gtdata_types, only: GT_VARIABLE
    use gtdata_generic, only: Create, Close, Put_Attr, get_attr, add_member, url
    use iso_varying_string
    type(GT_CONTOURS), intent(inout):: cont
    type(VARYING_STRING), intent(in), optional:: name
    type(VARYING_STRING), intent(out), optional:: name_result
    type(VARYING_STRING):: vname, title, member
    type(GT_VARIABLE):: var
continue
    if (present(name)) then
        vname = name
    else
        vname = GTGraphSaveName()
    endif
    call get_attr(cont%var, "long_name", title)
    title = "contours of " // title
    call Create(var, char(vname), xtype="int", overwrite=.TRUE., &
        long_name=char(title))
    call Put_Attr(var, "gt_structure_class", "contours")
    call Put_Attr(var, "gt_contours_draw_shade", cont%shade)
    call Put_Attr(var, "gt_contours_draw_contours", cont%contours)
    if (cont%interval /= 0.0) then
        call Put_Attr(var, "gt_contours_interval", (/cont%interval/))
    endif
    if (cont%icycle /= 0) then
        call Put_Attr(var, "gt_contours_major_contour_cycle", (/cont%icycle/))
    endif
    if (associated(cont%levels)) then
        call Put_Attr(var, "gt_contours_levels", cont%levels)
    endif
    if (associated(cont%skiplevels)) then
        call Put_Attr(var, "gt_contours_skiplevels", cont%skiplevels)
    endif
    if (associated(cont%tones)) then
        call Put_Attr(var, "gt_contours_tones", cont%tones)
    endif

    ! }̃oɂȂĂ̂̏o
    call add_member(var, url(cont%var), link_name="data")
    if (associated(cont%v_axis)) then
        if (cont%v_axis%saved /= "") then
            call add_member(var, cont%v_axis%saved, link_name="vaxis")
        else
            call Save(cont%v_axis, resultname=member)
            call add_member(var, member, link_name="vaxis")
        endif
    endif
    if (associated(cont%h_axis)) then
        if (cont%h_axis%saved /= "") then
            call add_member(var, cont%h_axis%saved, link_name="haxis")
        else
            call Save(cont%h_axis, resultname=member)
            call add_member(var, member, link_name="haxis")
        endif
    endif
    
    call Close(var)
    print *, char(title), " stored at ", char(vname)
    if (present(name_result)) name_result = vname
end subroutine
