! dc_error.f90 - G[̏u
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

module dc_error

    use iso_varying_string, only: VARYING_STRING
    implicit none
    public

    ! G[ێ

    integer, private:: errno = 0
    integer, private:: cause_int = 0
    type(VARYING_STRING), private:: cause_string
    type(VARYING_STRING), private:: cause_location 

    ! ̃G[ԍ libc VXeG[bZ[Ŵ߂
    ! ĂBVXeˑ傫Aɑ傫Ȑl
    ! p̂ŋ󂫗̈mۂ͍̂łB
    !
    ! ̃G[ԍ netCDF gĂBX̊gŁA
    ! -99 ܂ł͎gȂŒuB

    integer, parameter:: GT_EFAKE = -100
    !
    ! -101 ȉ: f[^\̃G[
    !
    integer, parameter:: GT_ENOMOREDIMS = -101
    integer, parameter:: GT_EDIMNODIM = -102
    integer, parameter:: GT_EDIMMULTIDIM = -103
    integer, parameter:: GT_EDIMOTHERDIM = -104
    integer, parameter:: GT_EBADDIMNAME = -105
    !
    ! -200 ȉ: \̃G[
    !
    integer, parameter:: GT_EFIGNOHAXIS = -200
    integer, parameter:: GT_EFIGNOVAXIS = -201

    public:: StoreError, DumpError, GetErrorMessage
    !
    ! === 葱pdl ===
    !
    ! ꍷւ悤ɊO֐ɂĂB

    interface
        subroutine DumpError()
        end subroutine
    end interface

contains

    subroutine GetErrorMessage(msg)
        use iso_varying_string, only: VARYING_STRING, &
                assignment(=), operator(//), len
        use netcdf_f77, only: nf_strerror
        type(VARYING_STRING), intent(out):: msg
        character(len = 80):: message
    continue
        select case(errno)
        case(GT_EFAKE)
            msg = ": function not implemented"
        case(GT_ENOMOREDIMS)
            write(message, "(': dimension number', i4, ' is out of range')") cause_int
            msg = trim(message)
        case(GT_EBADDIMNAME)
            msg = '(' // cause_string // '): unknown dimension name'
        case(GT_EDIMNODIM)
            msg = ": dimension variable has no dimension"
        case(GT_EDIMMULTIDIM)
            msg = ": dimension variable has many dimensions"
        case(GT_EDIMOTHERDIM)
            msg = ": dimension variable has another dimension"
        case(GT_EFIGNOHAXIS)
            msg = ": hozirontal axis is missing"
        case(GT_EFIGNOVAXIS)
            msg = ": vertical axis is missing"
        case default
            goto 1000
        end select
        msg = cause_location // msg
        return

    1000 continue
        if (len(cause_string) > 0) then
            message = nf_strerror(errno)
            msg = cause_location // "(" // cause_string // ")" &
                // (": " // trim(message))
        else
            message = nf_strerror(errno)
            msg = cause_location // (": " // trim(message))
        endif
    end subroutine

    ! T^ICu֐̂߂ɍꂽG[֐B
    !
    ! G[ԍ number  errno Ɋi[BɕtI
    ! where, cause_s, cause_i  cause_location, cause_string,
    ! cause_int Ɋi[B 
    ! err ^ĂꍇAerr  number  0 ̏ꍇUɂȂB
    ! number  0 ȂΑAB
    ! err ^ĂȂ΃G[bZ[W𑕒u * ɏo͂
    ! vOIB

    subroutine StoreError(number, where, err, cause_s, cause_i)
        use iso_varying_string, only: VARYING_STRING, assignment(=)
        integer, intent(in):: number
        character(len = *), intent(in):: where
        logical, intent(out), optional:: err
        type(VARYING_STRING), intent(in), optional:: cause_s
        integer, intent(in), optional:: cause_i
    continue
        errno = number
        cause_location = where
        if (present(cause_s)) then
            cause_string = cause_s
        else
            cause_string = ""
        endif
        if (present(cause_i)) cause_int = cause_i
        if (present(err)) then
            err = (number /= 0)
            return
        endif
        if (number == 0) return
        call DumpError
    end subroutine

end module

subroutine DumpError()
    use iso_varying_string, only: VARYING_STRING, put_line
    use dc_error, only: GetErrorMessage
    use sysdep, only: AbortProgram
    type(VARYING_STRING):: message
    call GetErrorMessage(message)
    call AbortProgram(message)
end subroutine

