! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine ANVarGetAttrSC(var, name, value, default)
    use iso_varying_string
    use an_types, only: AN_VARIABLE
    use netcdf_f77
    use dc_string, only: toString
    use dc_error
    implicit none
    type(AN_VARIABLE), intent(in):: var
    character(len = *), intent(in):: name
    type(VARYING_STRING), intent(out):: value
    character(len = *), intent(in), optional:: default
    character(len = 64):: buffer
    double precision, allocatable:: dbuf(:)
    integer, allocatable:: ibuf(:)
    character, allocatable:: cbuf(:)
    integer:: xtype, stat, attrlen, i
continue
    stat = nf_inq_att(var%fileid, var%varid, name, xtype=xtype, len=attrlen)
    if (stat /= NF_NOERR) goto 800
    if (xtype == NF_CHAR .and. attrlen <= len(buffer)) then
        stat = nf_get_att_text(var%fileid, var%varid, name, buffer)
        if (stat /= NF_NOERR) goto 800
        value = buffer(1: attrlen)
    else if (xtype == NF_CHAR) then
        ! UNIDATA NetCDF Cuł͕̒
        ! ܂擾ĂȂ̂Ő擪Ă OK ̂͂
        allocate(cbuf(attrlen))        
        stat = nf_get_att_text(var%fileid, var%varid, name, cbuf(1))
        if (stat /= NF_NOERR) goto 800
        value = ""
        do, i = 1, attrlen
            value = value // cbuf(i)
        enddo
        value = value // cbuf(i)
        deallocate(cbuf)
    else if (xtype == NF_DOUBLE .or. xtype == NF_FLOAT) then
        allocate(dbuf(attrlen))
        stat = nf_get_att_double(var%fileid, var%varid, name, dbuf)
        if (stat /= NF_NOERR) goto 800
        value = toString(dbuf)
        deallocate(dbuf)
    else
        allocate(ibuf(attrlen))
        stat = nf_get_att_int(var%fileid, var%varid, name, ibuf)
        if (stat /= NF_NOERR) goto 800
        value = toString(ibuf)
        deallocate(ibuf)
    endif
    return
    ! ftHg
800 continue
    value = ""
    if (present(default)) value = default
    return
end subroutine
