! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.

subroutine ANVarCreate(var, url, xtype, dims, overwrite, err)
    use iso_varying_string
    use an_types, only: AN_VARIABLE
    use an_file, only: ANFileOpen, ANFileDefineMode
    use an_url, only: ANUrlSplit
    use netcdf_f77, only: NF_NOERR, nf_def_var, NF_REAL, NF_INT
    use dc_error, only: StoreError
    use dc_string, only: EquivNoCase
    type(AN_VARIABLE), intent(inout):: var
    character(len = *), intent(in):: url
    character(len = *), intent(in):: xtype
    type(AN_VARIABLE), intent(in):: dims(:)
    logical, intent(in), optional:: overwrite
    logical, intent(out), optional:: err
    type(VARYING_STRING):: filename, varname
    integer:: stat, nvdims
    integer:: nc_xtype
    integer, allocatable:: dimids(:)
continue
    call ANUrlSplit(var_str(url), filename, varname)
    call ANFileOpen(var%fileid, filename, stat=stat, writable=.TRUE., &
        overwrite=overwrite)
    if (stat /= NF_NOERR) goto 999
    stat = ANFileDefineMode(var%fileid)
    if (stat /= NF_NOERR) goto 999
    nvdims = size(dims)
    allocate(dimids(1: nvdims))
    dimids(1: nvdims) = dims(1: nvdims)%dimid
    nc_xtype = NF_REAL
    if (EquivNoCase(xtype, "int") .or. EquivNoCase(xtype, "INTEGER")) then
        nc_xtype = NF_INT
    endif
    stat = nf_def_var(var%fileid, char(varname), xtype=nc_xtype, ndims=nvdims, dimids=dimids, &
        varid=var%varid)
    allocate(var%dimids(nvdims), var%allcount(nvdims))
    allocate(var%start(nvdims), var%count(nvdims), var%stride(nvdims))
999 continue
    call StoreError(stat, 'ANVarCreate', err)
end subroutine
