program test
	use netcdf
	implicit none

	integer, parameter::	LATGRIDS = 128
	integer, parameter::	LONGRIDS = 64

	type(NC_FILE)::		file
	type(NC_ERROR)::	err
	type(NC_DIMENSION)::	lat, lon
	type(NC_VARIABLE)::	u
	type(NC_LIMIT)::	lim
	real::			uvalue(LATGRIDS, LONGRIDS, 1, 1, 1, 1, 1)
	real, pointer::		upointer(:, :, :, :, :, :, :)
	integer::		i, j
	logical::		ok

	call create(file, 'test.nc')
	print *, 'test file test.nc created'

	lat = Dimension(file, 'lat', LATGRIDS)
	if (.error. lat) call assert(NetcdfLastError())
	lon = Dimension(file, 'lon', LONGRIDS)
	if (.error. lon) call assert(NetcdfLastError())

	u = Variable(file, 'u', NF_FLOAT, (/lat, lon/))
	call assert(NetcdfLastError())

	err = EndDefine(file)

	uvalue = reshape((/((i * j, i = 1, LATGRIDS), j = 1, LONGRIDS)/), &
		& (/LATGRIDS, LONGRIDS, 1, 1, 1, 1, 1/))
	
	ok = put_real(u, uvalue)
	if (.not. ok) call assert(NetcdfLastError())
	uvalue = 0

	lim = WholeVariable(u)
	if (.not. Slice(lim, 'lon', 1)) stop 'slice'
	upointer => get_real(u, lim)
	print *, char(string(lim))
	print *, upointer(1:6, 1, 1, 1, 1, 1, 1)
	call dispose(lim)
	deallocate(upointer)

	call close(file)
end program
