! gtool_contours.f90 - gtool4 graphic objects - contours
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_contours

    use gtool_data
    use dcl
    implicit none

    type GT_CONTOURS
	type(NC_VARIABLE):: var
	type(NC_LIMIT):: limit
    end type

    interface Contours
	module procedure GtoolContoursDefault
    end interface

    interface Display
	module procedure GtoolContoursDisplay
    end interface

contains

    type(GT_CONTOURS) function GtoolContoursDefault(var) result(result)
	type(GT_VARIABLE), intent(in):: var
	integer:: i
	logical:: ok
    continue
	if (Class(var) /= GT_VARIABLE_NETCDF) then
	    print *, 'non-netcdf variable currently not implemented'
	    stop
	endif
	result%var = var%ncvar
	result%limit = WholeVariable(var%ncvar)
	do, i = 3, DimensionsNumber(result%var)
	    ok = Slice(result%limit, i, 1)
	enddo
    end function

    subroutine GtoolContoursDisplay(contours)
	type(GT_CONTOURS), intent(in):: contours
	real, pointer:: buffer7(:, :, :, :, :, :, :)
	real, pointer:: buffer2(:, :)
	integer:: myshape(7)
    continue
	buffer7 => get_real(contours%var, contours%limit)
	myshape(:) = shape(buffer7)
	allocate(buffer2(myshape(1), myshape(2)))
	buffer2 = reshape(buffer7, myshape(1:2))
	call DclSetShadeLevel(buffer2, 0.0)
	call DclShadeContour(buffer2)
	call DclDrawScaledAxis
	call DclDrawContour(buffer2)
	deallocate(buffer7)
	deallocate(buffer2)
    end subroutine

end module
