! gtool_file.f90 - gtool4 file interface
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_file 

    use netcdf
    use dc_string
    implicit none

    ! gtt@C\
    ! [Uɂ͕ϐȂAt@C̕̕ϐ
    ! JƂɓt@CJȂ悤ɁAsB
    ! gtϐ\̂Ep邲ƂɎQƐ𑝌A
    ! QƂȂȂt@CB

    type GT_FILE
	type(NC_FILE)::		ncfile
	integer::		nlink
    end type

    interface Create
	module procedure GtoolFileCreate
    end interface

    interface Open
	module procedure GtoolFileOpen
    end interface

    integer, parameter:: GT_FILE_UNKNOWN = 0
    integer, parameter:: GT_FILE_NETCDF = 1
    integer, parameter:: GT_FILE_GTOOL3 = 2

    interface Class
	module procedure GtoolFileClass
    end interface

    interface Close
	module procedure GtoolFileClose
    end interface

    interface Name
	module procedure GtoolFileName
    end interface

contains

    ! internal
    ! 
    subroutine FVASplit(fullname, file, var, attr)
	type(VARYING_STRING), intent(in)::	fullname
	type(VARYING_STRING), intent(out), optional::	file, var, attr
	type(VARYING_STRING):: varpart
	integer:: hash, colon
    continue
	hash = index(char(fullname), '#', back=.TRUE.)
	if (hash == 0) then
	    if (present(file)) file = fullname
	    if (present(var)) var = ''
	    if (present(attr)) attr = ''
	    return
	endif
	if (present(file)) file = extract(fullname, 1, hash - 1)
	varpart = extract(fullname, hash + 1)
	colon = index(var, ':')
	if (colon == 0) then
	    if (present(var)) var = varpart
	    if (present(attr)) attr = ''
	    varpart = ''
	    return
	endif
	if (present(var)) var = extract(varpart, 1, colon - 1)
	if (present(attr)) attr = extract(varpart, colon + 1)
	varpart = ''
    end subroutine

    subroutine GtoolFileCreate(file, fullname, fail)
	type(GT_FILE), intent(inout)::		file
	type(VARYING_STRING), intent(in)::		fullname
	type(VARYING_STRING):: 		filename, varname
	type(NC_FILE)::					ncfile
	logical, intent(out), optional:: fail
    continue
	if (present(fail)) fail = .FALSE.
	! try to open netCDF file
	call FVASplit(fullname, filename, varname)
	allocate(file%ncfile)
	ncfile = NetcdfOpenFile(char(filename), writable=.TRUE.)
	if (.error. ncfile) ncfile = NetcdfCreateFile(char(fullname))
	if (.not..error. ncfile) then
	    file%ncfile = File(ncfile, char(varname))
	    if (.not..error. (file%ncfile)) then
		return
	    endif
	endif
	! if opening netCDF fail
	deallocate(file%ncfile)
	nullify(file%ncfile)
	if (present(fail)) then
	    fail = .TRUE.
	else
	    call NetcdfAssert()
	endif
    end subroutine

    subroutine GtoolFileOpen(file, fullname, fail)
	type(GT_FILE), intent(inout)::		file
	type(VARYING_STRING), intent(in)::		fullname
	type(VARYING_STRING):: filename, varname
	type(NC_FILE)::					ncfile
	logical, intent(out), optional:: fail
    continue
	if (present(fail)) fail = .FALSE.
	! try to open netCDF file
	call FVASplit(fullname, filename, varname)
	allocate(file%ncfile)
	ncfile = NetcdfOpenFile(char(filename))
	if (.not..error. ncfile) then
	    file%ncfile = File(ncfile, char(varname))
	    if (.not..error. file%ncfile) then
		return
	    endif
	endif
	! if opening netCDF fail
	deallocate(file%ncfile)
	nullify(file%ncfile)
	if (present(fail)) then
	    fail = .TRUE.
	else
	    call NetcdfAssert()
	endif
    end subroutine

    integer function GtoolFileClass(file) result(result)
	type(GT_FILE), intent(in)::		file
    continue
	if (associated(file%ncfile)) then
	    result = GT_FILE_NETCDF
	    return
	endif
	result = GT_FILE_UNKNOWN
    end function

    subroutine GtoolFileClose(file, fail)
	type(GT_FILE), intent(inout)::		file
	logical, optional, intent(out):: fail
    continue
	if (Class(file) == GT_FILE_NETCDF) then
	    deallocate(file%ncfile)
	    if (present(fail)) fail = .FALSE.
	else
	    if (present(fail)) then
		fail = .TRUE.
	    else
		print "('Close: invalid GT_FILE handle')"
		stop
	    endif
	endif
    end subroutine

    type(VARYING_STRING) function GtoolFileName(file) result(result)
	type(GT_FILE), intent(in):: file
    continue
	if (Class(file) == GT_FILE_NETCDF) then
	    result = Name(file%ncfile)
	else
	    result = ''
	endif
    end function

end module
