! gt3read.f90 - GTOOL3 file input module
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gt3read

    use dcl
    implicit none

    private

    type GT3_HEADER
	integer:: version  ! idfm
	character(len = 16):: dataset, item
	character(len = 16):: edit(8)
	integer:: file_number, data_number
	character(len = 16 * 2):: title
	character(len = 16):: unit
	character(len = 16):: edit_title(8)
	integer:: time
	character(len = 16):: datetime, time_unit
	integer:: time_duration
	character(len = 16):: axis_item(3)
	integer:: axis_start(3), axis_end(3)
	character(len = 16):: format
	real:: missing_value, range_max, range_min
	real:: div_small, div_large
	integer:: scaling
	character(len = 16):: option(3), memo(12)
	character(len = 16):: create_date, create_user
	character(len = 16):: modify_date, modify_user
	integer:: record_size
    end type

    ! GTOOL3 `̃t@Cɂ͓ ITEM Lqq Ȃ
    ! قȂ鎲jbg (GTOOL3 p) ݂\B
    ! Ńjbg̓ǂݎ育ƂɕϐƂ̑Ήi[B
    ! GetHeader  newvariable ͕ϐ̍ŏ̃jbg̓ǂݎ
    ! ʒmBϐ̃jbgmȂĂ悯1pX\łB
    ! 2pXeȂ BuildVariables ĂяoĂ
    ! CurrentVariableLength ֐ĂяoB

    type GT3_VAR_SPEC
	! netcdf ϐƂĐȌ`ɕϊꂽϐ
	type(VARYING_STRING):: netcdf_name
    	! ȉׂ̂Ă̗jbg͓ϐɑΉ̂Ƃ݂Ȃ
	character(len = 16):: item, axis_item(3)
    end type

    type GT3_FILE
	private
	integer:: number
	! ȉ͕̐ϐG~[V@\Ŏgp
	integer:: cur_record, num_record
	integer, pointer:: record_to_var(:)
	integer:: num_vars
	type(GT3_VAR_SPEC), pointer:: var_spec(:)
    end type

    public GT3_FILE, GT3_HEADER, Open, Close, GetHeader, GetData

    interface Open;  module procedure Gt3Open;  end interface
    interface Close;  module procedure Gt3Close;  end interface
    interface GetHeader;  module procedure Gt3GetHeader;  end interface
    interface GetData;  module procedure Gt3GetData;  end interface

contains

    subroutine Gt3Open(unit, file)
	type(GT3_FILE), intent(out):: unit
	character(len = *), intent(in):: file
	integer:: ios
    continue
	unit%number = DclGetUnitNum()
	unit%cur_records = 0
	unit%cur_vars = 0
	allocate(unit%record_to_var(128))
	allocate(unit%var_spec(4))
	open(unit=unit%number, file=file, access='SEQUENTIAL', &
	    & form='UNFORMATTED', iostat=ios)
	if (ios /= 0) then
	    print *, 'Open: cannot open ', trim(file)
	    stop
	endif
    end subroutine

    subroutine Gt3Close(unit)
	type(GT3_FILE), intent(inout):: unit
    continue
	close(unit=unit%number)
	unit%number = -unit%number
	if (associated(unit%record_to_var)) then
	    deallocate(unit%record_to_var)
	    nullify(unit%record_to_var)
	endif
	if (associated(unit%var_spec)) then
	    deallocate(unit%var_spec)
	    nullify(unit%var_spec)
	endif
    end subroutine

    subroutine Gt3GetHeader(unit, header)
	type(GT3_FILE), intent(in):: unit
	type(GT3_HEADER), intent(out):: header
	integer:: ios
	character(len = 16):: buffer(64)
    continue
	read(unit=unit%number, iostat=ios) buffer
	if (ios /= 0) stop 'Gtool3.GetHeader: read error for file'
	call BufferToHeader
    contains

	type(GT3_VAR_SPEC) function HeaderToVarSpec(header) result(result)
	    type(GT3_HEADER), intent(in):: header
	    character(len = *), parameter:: NameSet = &
	& '-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_'
	continue
	    result%netcdf_name = trim(result%item)
	    if (verify(result%netcdf_name, NameSet) > 0) then
		stop 'gt3read#HeaderToVarSpec barf'
	    endif
	    result%item = header%item
	    result%axis_item = header%axis_item
	end function

	logical function EquivalentVarSpec(spec1, spec2) result(result)
	    type(GT3_VAR_SPEC), intent(in):: 
	continue
	    result = (spec1%item == spec2%item) .and. &
		& (spec1%axis_item == spec2%axis_item)
	end function

	subroutine BufferToHeader
	    read(buffer(1), fmt="(i16)", iostat=ios) header%version
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad version'
	    header%dataset = buffer(2)
	    header%item = buffer(3)
	    header%edit(1: 8) = buffer(4: 11)
	    read(buffer(12), fmt="(i16)", iostat=ios) header%file_number
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad file_number'
	    read(buffer(13), fmt="(i16)", iostat=ios) header%data_number
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad data_number'
	    header%title = transfer(buffer(14: 15), header%title)
	    header%unit = buffer(16)
	    header%edit_title(1: 8) = buffer(17: 24)
	    read(buffer(25), fmt="(i16)", iostat=ios) header%time
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad time'
	    header%time_unit = buffer(27)
	    header%datetime = buffer(26)
	    read(buffer(28), fmt="(i16)", iostat=ios) header%time_duration
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad time_duration'
	    header%axis_item(1: 3) = buffer(29: 35: 3)
	    read(buffer(30), fmt='(i16)', iostat=ios) header%axis_start(1) 
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad axis_start'
	    read(buffer(33), fmt='(i16)', iostat=ios) header%axis_start(2) 
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad axis_start'
	    read(buffer(36), fmt='(i16)', iostat=ios) header%axis_start(3) 
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad axis_start'
	    read(buffer(31), fmt='(i16)', iostat=ios) header%axis_end(1) 
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad axis_end'
	    read(buffer(34), fmt='(i16)', iostat=ios) header%axis_end(2) 
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad axis_end'
	    read(buffer(37), fmt='(i16)', iostat=ios) header%axis_end(3) 
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad axis_end'
	    header%format = buffer(38)
	    read(buffer(39), fmt='(e)', iostat=ios) header%missing_value
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad missing_value'
	    read(buffer(40: 43), fmt='(4e15.7)', iostat=ios) &
	    & header%range_max, header%range_min, header%div_small, header%div_large
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad range/div'
	    read(buffer(44), fmt="(i16)", iostat=ios) header%scaling
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad scaling'
	    header%option(1: 3) = buffer(45: 47)
	    header%memo(1: 12) = buffer(48: 59)
	    header%create_date = buffer(60)
	    header%create_user = buffer(61)
	    header%modify_date = buffer(62)
	    header%modify_user = buffer(63)
	    read(buffer(64), fmt="(i16)", iostat=ios) header%record_size
	    if (ios /= 0) stop 'Gtool3.GetHeader: bad record_size'

    end subroutine

    ! O\Ɠ\Ɋւ鉼肪
    !
    subroutine Gt3GetData(unit, header, array)
	type(GT3_FILE), intent(in):: unit
	type(GT3_HEADER), intent(in):: header
	real, pointer:: array(:, :, :)
	double precision, pointer:: darray(:, :, :)
	integer:: xs, xe, ys, ye, zs, ze
    continue
	if (header%format == 'UR4' .or. header%format == 'UR8') then
	    xs = header%axis_start(1)
	    ys = header%axis_start(2)
	    zs = header%axis_start(3)
	    xe = header%axis_end(1)
	    ye = header%axis_end(2)
	    ze = header%axis_end(3)
	    if (header%format == 'UR4') then
		allocate(array(xs:xe, ys:ye, zs:ze))
		read(unit=unit%number) array(:, :, :)
	    else if (header%format == 'UR8') then
		allocate(darray(xs:xe, ys:ye, zs:ze))
		read(unit=unit%number) darray(:, :, :)
	    endif
	else
	    print "('GT3 external format <', a, '> not supported')", &
		& trim(header%format)
	    stop "Gt3GetData"
	endif
    end subroutine

end module
