! vi: set ts=8 sw=4:

program gt3conv
    use gt3read
    use gtool

    type(VARYING_STRING):: fnam
    type(GT3_FILE):: input
    type(GT3_HEADER):: hdr
    real, pointer:: array(:, :, :)

    type(NC_FILE):: file
    type(NC_DIMENSION):: dims(3)
    type(NC_VARIABLE):: var
    type(NC_ATTRIBUTE):: attrib
    logical:: ok
    integer:: ncshape(7), ndims, d

    fnam = GtoolArgument(1, default='gtool.out')
    call Open(input, char(fnam))
    call GetHeader(input, hdr)
    call GetData(input, hdr, array)

    call Create(file, char(GtoolArgument(2, default='gtool.nc')))
    ndims = 0
    do, d = 1, 3
	if (hdr%axis_item(d) /= '') then
	    ndims = ndims + 1
	    dims(ndims) = Dimension(file, trim(hdr%axis_item(d)), &
		& (hdr%axis_end(d) - hdr%axis_start(d) + 1))
	    call NetcdfAssert
	endif
    enddo
    var = Variable(file, trim(hdr%item), NF_FLOAT, dims(1: ndims))
    call NetcdfAssert
    call Assert( EndDefine(file))
    ncshape = 1
    ncshape(1: 3) = shape(array)
    ok = Put_Real(var, reshape(array, ncshape), WholeVariable(var))
    call Close(file)

    deallocate(array)
    call Close(input)

end program
