! netcdf_file.f90 - object-oriented netCDF file interface (file)
! vi: set sw=4:
! Copyright (C) TOYODA Eizi, 2000.  All rights reserved.
!
! 2000-01-10 ˭ıѻ	
! 2000-01-13 ˭ıѻ	̾
! 2000-01-15 ˭ıѻ	Ѥ
! 2000-01-17 ˭ıѻ	⡼ɤȤη NC_FILE 
! 2000-02-22 ˭ıѻ	Ĺʸ

module netcdf_file

    use netcdf_v3
    use netcdf_error
    use netcdf_filename
    use iso_varying_string
    implicit none

    character(len=*), private, parameter:: RCSID = &
    & "$Id:$"

    type NC_FILE
	integer::		id
	logical::		writable
	logical::		defmode
    end type

    type(NC_FILE), parameter:: &
	& NC_FILE_CLOSED = NC_FILE(0, .FALSE., .FALSE.), &
	& NC_FILE_ERROR = NC_FILE(-1, .FALSE., .FALSE.)

    !
    ! --- 롢Ĥ ---
    !

    interface Create
	module procedure NetcdfCreateFile2
    end interface

    interface Open
	module procedure NetcdfOpenFile2
    end interface

    interface Close
	module procedure NetcdfCloseFile
    end interface

    !
    ! --- ⡼ѹ ---
    ! 

    interface Redefine
	module procedure NetcdfRedefineFile
    end interface

    interface EndDefine
	module procedure NetcdfFileEndDefmode
    end interface

    !
    ! --- μ ---
    !

    interface Id
    	module procedure NetcdfFileId
    end interface

    interface Filename
	module procedure NetcdfFileFilename
    end interface

    interface operator(==)
	module procedure NetcdfFileEquiv
    end interface

    interface operator(.error.)
	module procedure NetcdfFileError
    end interface

contains

    ! 顼å
    !
    logical function NetcdfFileError(file)
    	type(NC_FILE), intent(in)::	file
    continue
	NetcdfFileError = (file%id < 0)
    end function

    !
    ! --- / ---
    !

    ! 
    ! ¸ե뤬оõ
    function NetcdfCreateFile(path, overwrite) result(result)
	type(NC_FILE):: result
	character(len=*), intent(in):: path
	logical, intent(in), optional:: overwrite
	integer:: status, mode
    continue
	mode = NF_CLOBBER
	if (present(overwrite)) then
	    if (.not. overwrite) mode = NF_NOCLOBBER
	endif
	status = nf_create(path, mode, result%id)
	if (status == NF_NOERR) then
	    result%defmode = .TRUE.
	    result%writable = .TRUE.
	    call NetcdfSaveFilename(result%id, path)
	else
	    call NetcdfSaveError(status, 'NetcdfCreateNewFile', path)
	    result = NC_FILE_ERROR
	endif
    end function

    ! ʰ
    subroutine NetcdfCreateFile2(file, path, overwrite, fail)
	type(NC_FILE), intent(out):: file
	character(len=*), intent(in):: path
	logical, intent(in), optional:: overwrite
	logical, intent(out), optional:: fail
    continue
	file = NetcdfCreateFile(path, overwrite)
	if (present(fail)) then
	    fail = .error. file
	else
	    call NetcdfAssert()
	endif
    end subroutine

    ! 
    !
    function NetcdfOpenFile(path, writable) result(result)
	type(NC_FILE):: result
	character(len=*), intent(in):: path
	logical, optional, intent(in):: writable
	integer:: mode, status
    continue
	mode = NF_NOWRITE
	if (present(writable) .and. writable) then
	    mode = ior(mode, NF_WRITE)
	    result%writable = .TRUE.
	else
	    result%writable = .FALSE.
	endif
	status = nf_open(path, mode, result%id)
	if (status == NF_NOERR) then
	    call NetcdfSaveFilename(Id(result), path)
	    result%defmode = .FALSE.
	else
	    call NetcdfSaveError(status, 'NetcdfOpenFile', path)
	    result = NC_FILE_ERROR
	endif
    end function

    ! ʰ
    subroutine NetcdfOpenFile2(file, path, writable, fail)
	type(NC_FILE), intent(out):: file
	character(len=*), intent(in):: path
	logical, optional, intent(in):: writable
	logical, optional, intent(out):: fail
    continue
	file = NetcdfOpenFile(path, writable=writable)
	if (present(fail)) then
	    fail = .error. file
	else
	    call NetcdfAssert()
	endif
    end subroutine

    ! Ĥ
    !
    subroutine NetcdfCloseFile(file, fail)
	type(NC_FILE), intent(inout):: file
	logical, intent(out), optional:: fail
	integer:: status
    continue
	status = nf_close(Id(file))
	call NetcdfSaveError(status, 'NetcdfCloseFile', Filename(file))
	if (present(fail)) then
	    fail = (status /= NF_NOERR)
	else
	    call NetcdfAssert()
	endif
	file = NC_FILE_CLOSED
    end subroutine

    !
    ! --- ⡼ѹ ---
    !

    function NetcdfRedefineFile(file) result(result)
	type(NC_ERROR):: result
	type(NC_FILE), intent(inout):: file
    continue
	if (file%defmode) then
	    result = NF_NOERR
	    return
	endif
	result = NC_ERR(nf_redef(Id(file)), &
	    & 'NetcdfRedefineFile', Filename(file))
	if (.error. result) return
	file%defmode = .true.
    end function

    function NetcdfFileEndDefmode(file) result(result)
	type(NC_ERROR):: result
	type(NC_FILE), intent(inout):: file
    continue
	if (.not. file%defmode) then
	    result = NF_NOERR
	    return
	endif
	result = NC_ERR(nf_enddef(Id(file)), &
	    & 'NetcdfFileEndDefmode', Filename(file))
	if (.error. result) return
	file%defmode = .false.
    end function

    !
    ! --- ե˴ؤ ---
    !

    ! ID μ
    !
    integer function NetcdfFileId(file) result(result)
	type(NC_FILE), intent(in)::	file
    continue
	result = file%id
    end function

    ! ե̾μ
    !
    function NetcdfFileFilename(file) result(result)
	type(VARYING_STRING)::		result
    	type(NC_FILE), intent(in)::	file
    continue
    	result = NetcdfIdToFilename(Id(file))
    end function

    ! ƱȽ
    !
    logical function NetcdfFileEquiv(lhs_file, rhs_file) result(result)
    	type(NC_FILE), intent(in)::	lhs_file, rhs_file
    continue
	result = (lhs_file%id == rhs_file%id)
    end function


end module
