! gtool_figure.f90 - gtool4 graphic objects - figure
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_figure 

    use gtool_axis
    use gtool_contours
    implicit none

    type GT_FIGURE
	integer:: h_axes, v_axes, contours
    end type

    interface Init
	module procedure GtoolFigureInit
    end interface

    interface Put
	module procedure GtoolFigurePutAxis
	module procedure GtoolFigurePutContours
    end interface

contains

    subroutine GtoolFigureInit(fig)
	type(GT_FIGURE), intent(out):: fig
    continue
	fig%h_axes = 0
	fig%v_axes = 0
	fig%contours = 0
    end subroutine

    subroutine GtoolFigurePutAxis(fig, axis, vertical)
	type(GT_FIGURE), intent(inout):: fig
	type(GT_AXIS), intent(in):: axis
	logical, optional, intent(in):: vertical
    continue
    end subroutine

    subroutine GtoolFigurePutContours(fig, contours)
	type(GT_FIGURE), intent(inout):: fig
	type(GT_CONTOURS), intent(in):: contours
    continue
    end subroutine

end module
