! gtool_device.f90 - gtool4 graphic objects - device
! Copyright (C) by TOYODA Eizi, 2000.  All rights reserved.
! vi: set sw=4 ts=8:

module gtool_device 

    use gtool_frame
    implicit none

    type GT_DEVICE
	integer:: ws_id
    end type

    interface Open
	module procedure GtoolDeviceOpen
    end interface

    interface Close
	module procedure GtoolDeviceClose
    end interface

    interface Display
	module procedure GtoolFigureDisplay
    end interface

    logical, private, save:: First = .TRUE.

contains

    subroutine GtoolDeviceOpen(dev, ws_id)
	type(GT_DEVICE), intent(out):: dev
	integer, optional, intent(in):: ws_id
	integer:: wsn
    continue
	wsn = 1
	if (present(ws_id)) wsn = ws_id
	call DclOpenGraphics(wsn)
	dev%ws_id = wsn
	First = .false.
    end subroutine

    subroutine GtoolDeviceClose(dev)
	type(GT_DEVICE), intent(inout):: dev
    continue
	if (First) return
	call DclCloseGraphics()
    	dev%ws_id = -1
    end subroutine

    subroutine GtoolFigureDisplay(dev, fig)
	type(GT_DEVICE), intent(inout):: dev
	type(GT_FIGURE), intent(in):: fig
    continue
    end subroutine

end module
