!= 
!
!= Routines for GABLS tests
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: gabls.f90,v 1.1 2015/01/31 06:16:26 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module gabls
  !
  != 
  !
  != Routines for GABLS tests
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 
  !
  ! 
  !
  !== Procedures List
  !
!!$  ! ShortIncoming      :: 短波入射 (太陽入射) の計算
!!$  ! ------------       :: ------------
!!$  ! ShortIncoming      :: Calculate short wave (insolation) incoming radiation. 
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#rad_short_income_nml
  !

  ! モジュール引用 ; USE statements
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING, &  ! 文字列.       Strings. 
    &                 TOKEN      ! キーワード.   Keywords.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 物理・数学定数設定
  ! Physical and mathematical constants settings
  !
  use constants0, only: &
    & PI                    ! $ \pi $.
                            ! 円周率. Circular constant

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only: imax, & ! 経度格子点数. 
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数. 
                             ! Number of grid points in latitude
    &                kmax    ! 鉛直層数. 
                             ! Number of vertical level

  ! 時刻管理
  ! Time control
  !
  use timeset, only: &
    & TimeN,                & !
    & InitialDate             ! 計算開始日時.
                              ! Start date of calculation

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public :: SetGabls2SurfTemp
  public :: GablsInit

  ! 公開変数
  ! Public variables
  !
  logical, save :: gabls_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag.


  ! 非公開変数
  ! Private variables
  !

!!$  logical,  save:: FlagAnnualMean
!!$                              ! 年平均入射フラグ.
!!$                              ! Flag for annual mean incoming radiation. 

  character(*), parameter:: module_name = 'gabls'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: gabls.f90,v 1.1 2015/01/31 06:16:26 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

contains

  !--------------------------------------------------------------------------------------

  subroutine SetGabls2SurfTemp(     &
    & xy_SurfTemp                   & ! (out)
    & )
    !
    ! 
    !
    ! Set surface temperature
    !

    ! モジュール引用 ; USE statements
    !

    ! 日付および時刻の取り扱い
    ! Date and time handler
    !
    use dc_calendar, only: DC_CAL_DATE, DCCalDateCreate, DCCalDateDifference, DCCalInquire

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! 宣言文 ; Declaration statements
    !
    implicit none
    real(DP), intent(out) :: xy_SurfTemp(0:imax-1, 1:jmax)
                              ! 
                              ! surface temperature


    ! 作業変数
    ! Work variables
    !
    integer         :: hour_in_a_day
    integer         :: min_in_a_hour
    real(DP)        :: sec_in_a_min

    integer           :: Year
    integer           :: Month
    integer           :: Day
    integer           :: Hour
    integer           :: Min
    real(DP)          :: Sec
    type(DC_CAL_DATE) :: Date1999Oct22UT0000

    real(DP) :: Time1999Oct22UT0000

    real(DP) :: HourFrom1999Oct22UT0000


    ! 実行文 ; Executable statement
    !

    ! 初期化確認
    ! Initialization check
    !
    if ( .not. gabls_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    call DCCalInquire( &
      & hour_in_day      = hour_in_a_day,     & ! (out)
      & min_in_hour      = min_in_a_hour,     & ! (out)
      & sec_in_min       = sec_in_a_min       & ! (out)
      & )


    Year  = 1999
    Month =   10
    Day   =   22
    Hour  =    0
    Min   =    0
    Sec   =    0.0_DP
    call DCCalDateCreate( &
      & year = Year, month = Month, day = Day, &
      & hour = Hour, min   = Min  , sec = Sec, &
      & date = Date1999Oct22UT0000             &
      & )

    Time1999Oct22UT0000 = &
      & DCCalDateDifference( Date1999Oct22UT0000, InitialDate )

    HourFrom1999Oct22UT0000 = TimeN + Time1999Oct22UT0000
    HourFrom1999Oct22UT0000 = &
      & HourFrom1999Oct22UT0000 / ( min_in_a_hour * sec_in_a_min )


    if ( HourFrom1999Oct22UT0000 <= 17.4_DP ) then
      xy_SurfTemp = &
        & - 10.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 0.2_DP )
    else if ( HourFrom1999Oct22UT0000 <= 30.0_DP ) then
      xy_SurfTemp = &
        & - 0.54_DP * HourFrom1999Oct22UT0000 + 15.2_DP
    else if ( HourFrom1999Oct22UT0000 <= 41.9_DP ) then
      xy_SurfTemp = &
        & -  7.0_DP - 25.0_DP * cos( 0.21 * HourFrom1999Oct22UT0000 + 1.8_DP )
    else if ( HourFrom1999Oct22UT0000 <= 53.3_DP ) then
      xy_SurfTemp = &
        & - 0.37_DP * HourFrom1999Oct22UT0000 + 18.0_DP
    else if ( HourFrom1999Oct22UT0000 <= 65.6_DP ) then
      xy_SurfTemp = &
        & -  4.0_DP - 25.0_DP * cos( 0.22 * HourFrom1999Oct22UT0000 + 2.5_DP )
    else
      xy_SurfTemp = &
        &    4.4_DP
    end if

    xy_SurfTemp = xy_SurfTemp + 273.15_DP


  end subroutine SetGabls2SurfTemp

  !--------------------------------------------------------------------------------------

  subroutine GablsInit
    !
    ! rad_short_income モジュールの初期化を行います. 
    ! NAMELIST#rad_short_income_nml の読み込みはこの手続きで行われます. 
    !
    ! "rad_short_income" module is initialized. 
    ! "NAMELIST#rad_short_income_nml" is loaded in this procedure. 
    !

    ! モジュール引用 ; USE statements
    !

    ! 種別型パラメタ
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! 暦と日時の取り扱い
    ! Calendar and Date handler
    !
    use dc_calendar, only: &
      & DC_CAL_DATE, &          ! 日時を表現するデータ型.
                                ! Data type for date and time
      & DCCalDateInquire, DCCalDateCreate, DCCalDateDifference, &
      & DCCalConvertByUnit

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! 宣言文 ; Declaration statements
    !
    implicit none

!!$    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read


    ! NAMELIST 変数群
    ! NAMELIST group name
    !
!!$    namelist /gabls_nml/                                     &
!!$      & FlagRadSynchronous
          !
          ! デフォルト値については初期化手続 "rad_short_income#RadShortIncomeInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "rad_short_income#RadShortIncomeInit" for the default values. 
          !

    ! 実行文 ; Executable statement
    !

    if ( gabls_inited ) return


    ! デフォルト値の設定
    ! Default values settings
    !
!!$    FlagRadSynchronous       = .false.


    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml, &                ! (in)
!!$        & nml = gabls_nml, &           ! (out)
!!$        & iostat = iostat_nml )        ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, '  FlagRadSynchronous       = %b', l = (/ FlagRadSynchronous /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    gabls_inited = .true.

  end subroutine GablsInit

  !-------------------------------------------------------------------

end module gabls
