=begin JA
= DCPAM の Git リポジトリを使用するためのローカル側のセットアップ
=end JA
=begin EN
= Setup to use DCPAM Git repository
=end EN

=begin JA
履歴
* 2015-03-29 高橋芳幸 更新
* 2015-03-15 高橋芳幸（https://www.gfd-dennou.org/arch/ruby/products/gphys/develop/git_repo_setup.htm を基に新規作成)
=end JA


=begin JA
== 注意
=end JA
=begin EN
== NOTE
=end EN

=begin JA
((:<font size=5 color="#ff0000">:))
DCPAM の Git リポジトリでは文字コードの制限をしているため, 
下に説明しているフックを設定しておくことを勧めます. 
((:</font>:))
=end JA
=begin EN
((:<font size=5 color="#ff0000">:))
In DCPAM Git source codes, Japanese letters are used to describe comments. 
In order to avoid to mix Japanese character codes, only UTF-8 is accepted. 
It is recommended to set hooks to avoid commiting source codes with 
character codes other than UTF-8. Example is shown below. 
((:</font>:))
=end EN

=begin JA
== 概要
=end JA
=begin EN
== Description
=end EN

=begin JA
=== 共有リポジトリの場所

共有リポジトリは

  dennou-k:/GFD_Dennou_Club/ftp/library/dcpam/git_repos/dcpam.git
  http://www.gfd-dennou.org/library/dcpam/git_repos/dcpam.git/

とする.
=end JA
=begin EN
=== Repository

  dennou-k:/GFD_Dennou_Club/ftp/library/dcpam/git_repos/dcpam.git
  http://www.gfd-dennou.org/library/dcpam/git_repos/dcpam.git/

=end EN

=begin JA
=== リポジトリのルール

現在の DCPAM の共有リポジトリは次のルールを課しています. 
* commit メッセージの文字コードは UTF-8 とする.
* push するファイルの文字コードは UTF-8 とする.
#* master ブランチには特定ユーザのみ push できる.
#  * 開発用には develop ブランチが用意されている. 
#  * 全体方針には "A successful Git branching model" ((<英語|URL:http://nvie.com/posts/a-successful-git-branching-model/>))|((<日本語|URL:http://keijinsonyaban.blogspot.jp/2010/10/successful-git-branching-model.html>)) に従う予定.


#dcpam は, これまでに cvs で dcpam0, dcpam1, ..., dcpam5, dcpam5-primitive 
#を管理してきたが, ここでは dcpam5 のみ cvsimport し, dcpam のリポジトリ
#として管理する. 
#今後バージョン番号はタグで管理することとし, バージョンが上がっても 
#(dcpam6 になっても) リポジトリ自体は新規作成しない. 
#(dcpam5-primitive の扱いは要検討.)
=end JA
=begin EN
=== Some rules

* Only UTF-8 for commit messages is accepted.
* Only UTF-8 for source codes is accepted.
#* Only some users can push source codes to master branch. 
#  * There is "develop" branch, which can be pushed by users. 

=end EN


=begin JA
== 基本ユーザ情報の設定 (git を使い始める際に一度やれば良い)

at 手元の計算機.

Git の確認 (あまり意味はないが)

  > git --version
  git version 1.7.10.4

ユーザ情報の設定

  > git config --global user.name xxx
  > git config --global user.email "xxx _AT_ mail.address"

Git の出力に色を付ける (らしい)

  > git config --global color.ui auto

使用するエディタの設定

  > git config --global core.editor "emacs -nw -q -l ~/.emacs-utf8"

日本語ファイル名を使えるようにする (らしい)

  > git config --global core.quotepath off

ページャの設定 (less が良いらしい. その他の場合には log が文字化けしたりする.)

  > git config --global core.pager less
=end JA


=begin JA
== 手元にクローンを作成
=end JA

=begin JA
at 手元の計算機.
=end JA

=begin JA
=== 手元にクローンを作成

ローカルの適当なディレクトリ (git_repos とする) に clone を作成．

電脳サーバにアカウントのあるユーザの場合.

  > mkdir git_repos
  > cd git_repos
  > git clone -v dennou-k.gfd-dennou.org:/GFD_Dennou_Club/ftp/library/dcpam/git_repos/dcpam.git

dcpam という名のレポジトリができるので cd

  > cd dcpam
=end JA

=begin JA
== 手元のフックの設定

((:<font size=5 color="#ff0000">:))
DCPAM の Git リポジトリでは, UTF-8 以外の commit ログを拒否
するため, 各自のリポジトリでこの設定をしておくことを勧めます. 
((:</font>:))
=end JA
=begin JA
== Local hook setup
=end JA

=begin JA
=== commit-msg フックの設定

commit-msg フックを使って commit ログの文字コードを UTF-8 に限定する.

  > cd .git/hooks

hooks/commit-msg を作成し, ファイルに実行権限を与えておく.
ファイルの中身は((<こちら|URL:./git_scripts/commit-msg>)).

ファイルを置いたら実行権限を与えておく.

  > chmod 775 commit-msg
  > cd ../..
=end JA
=begin EN
=== commit-msg hook

((<This|URL:./git_scripts/commit-msg>)) is an example of commit-msg script. 

  > cd .git/hooks

Place a commit-msg script. 

  > chmod 775 commit-msg
  > cd ../..
=end EN

=begin JA
=== pre-commit フックの設定

pre-commit フックを使って commit されるファイルの文字コードを UTF-8 に限定する.

  > cd .git/hooks

hooks/pre-commit を作成し, ファイルに実行権限を与えておく.
ファイルの中身は((<こちら|URL:./git_scripts/pre-commit>)). 

ファイルを置いたら実行権限を与えておく.

  > chmod 775 pre-commit
  > cd ../..
=end JA
=begin EN
=== pre-commit フックの設定

((<This|URL:./git_scripts/pre-commit>)) is an example of pre-commit script. 

  > cd .git/hooks

Place a pre-commit script. 

  > chmod 775 pre-commit
  > cd ../..
=end EN

=begin JA
=== リポジトリの確認

gitk で log 等を眺めてみる．

  > gitk

git log を眺めてみる.

  > git log

なお, この時, Git の pager は less が良いらしい. その他の場合には文字化けしたりする.
=end JA


=begin JA
#== 無視するファイルパターンを登録
#
#無視するファイルパターンを登録
#
#  $ cat > .gitignore 
#  *.[oa]
#  *~
#  *.so
#  Makefile
#  ChangeLog
#  ^D
#(先頭にスペースは入れない. ChangeLogは自動生成に切り替えるので無視ファイルに.)
#
#  $ git add .gitignore 
#  $ git commit -m "Registered files (patterns) to ignore in the repository"
#
#ChangeLog を mv
#
#  $ git mv ChangeLog .ChangeLog.until201303
#  $ git commit -m "Renamed the current ChangeLog to back up."


#== 手元のレポジトリの設定 (commitできない .git/ 内の設定)
#
#ChangeLog 自動生成の設定．以下の内容を
#.git/hooks/post-commit と .git/hooks/post-merge として設定
#
#  $ cat > post-commit
#  #!/bin/sh
#  git log --branches=master --date=short --name-status --pretty=format:"%ad  %an%n%B" > ChangeLog
#  ^D
#(先頭にスペースは入れない)
#  $ chmod +x post-commit
#  $ cp post-commit post-merge
#  $ ls -ltr

=end JA
