!= 火星ダスト関系ルーチン
!
!= Mars dust-related routines
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: cloud_utils.f90,v 1.7 2015/02/11 11:55:19 yot Exp $
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
module dust_utils
  !
  != 火星ダスト関系ルーチン
  !
  != Mars dust-related routines
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! ダスト関係ルーチン
  !
  ! In this module, ...
  ! This module is under development and is still a preliminary version.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: 放射フラックスの計算
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
  !
  !== NAMELIST
  !
  ! NAMELIST#dust_utils_nml
  !

  ! モジュール引用 ; USE statements

  !
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  ! メッセージ出力
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! 格子点設定
  ! Grid points settings
  !
  use gridset, only: imax, & ! 経度格子点数.
                             ! Number of grid points in longitude
    &                jmax, & ! 緯度格子点数.
                             ! Number of grid points in latitude
    &                kmax    ! 鉛直層数.
                             ! Number of vertical level

  implicit none

  private


  ! 公開手続き
  ! Public procedure
  !
  public :: DustUtilsGravSed
  public :: DustUtilsInit


  ! 公開変数
  ! Public variables
  !


  ! 非公開変数
  ! Private variables
  !

  logical, save :: dust_utils_inited = .false.
                              ! 初期設定フラグ.
                              ! Initialization flag

  character(*), parameter:: module_name = 'dust_utils'
                              ! モジュールの名称.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: cloud_utils.f90,v 1.7 2015/02/11 11:55:19 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine DustUtilsGravSed(      &
    & xyr_Press,                    & ! (in)
    & xyr_Height,                   & ! (in)
    & xyz_QDust                     & ! (inout)
    & )

    ! USE statements
    !

    ! 時刻管理
    ! Time control
    !
    use timeset, only: &
      & TimeN                ! ステップ $ t $ の時刻. 
                             ! Time of step $ t $. 

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSedAdjust


    real(DP), intent(in   ) :: xyr_Press    (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in   ) :: xyr_Height   (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(inout) :: xyz_QDust    (0:imax-1, 1:jmax, 1:kmax)


    ! Local variables
    !
    real(DP) :: xyr_DustGravSedMassFlux   (0:imax-1, 1:jmax, 0:kmax)
    real(DP) :: xy_SurfDustGravSedMassFlux(0:imax-1, 1:jmax)

    real(DP) :: PartDen = 3.0e3_DP
    real(DP) :: PartRad = 1.0e-6_DP
    real(DP) :: xyz_PartDen(0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xyz_PartRad(0:imax-1, 1:jmax, 1:kmax)


    ! 実行文 ; Executable statement
    !

    ! 初期化確認
    ! Initialization check
    !
    if ( .not. dust_utils_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    xyz_PartDen     = PartDen
    xyz_PartRad     = PartRad

    call GravSedAdjust(                                 &
      & xyr_Press, xyr_Height,                          & ! (in   )
      & xyz_PartDen, xyz_PartRad,                       & ! (in   )
      & xyz_QDust,                                      & ! (inout)
      & xyr_DustGravSedMassFlux                         & ! (out  ) optional
      & )

    xy_SurfDustGravSedMassFlux = xyr_DustGravSedMassFlux(:,:,0)
    call HistoryAutoPut( TimeN, 'SurfDustGravSedFlux', xy_SurfDustGravSedMassFlux )


  end subroutine DustUtilsGravSed

  !--------------------------------------------------------------------------------------

  subroutine DustUtilsInit

    ! ファイル入出力補助
    ! File I/O support
    !
!!$    use dc_iounit, only: FileOpen

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
!!$    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ヒストリデータ出力
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! 座標データ設定
    ! Axes data settings
    !
    use axesset, only: &
      & AxnameX, &
      & AxnameY, &
      & AxnameZ, &
      & AxnameR, &
      & AxnameT

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    use grav_sed, only : GravSedInit


    ! 宣言文 ; Declaration statements
    !

    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号.
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT.
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
!!$    namelist /dust_utils_nml/  &
!!$      & CloudOverlapType,       &
!!$      & CCNMixRatPerUnitMass
          !
          ! デフォルト値については初期化手続 "dust_utils#CloudUtilsInit"
          ! のソースコードを参照のこと.
          !
          ! Refer to source codes in the initialization procedure
          ! "dust_utils#DustUtilsInit" for the default values.
          !

    ! 実行文 ; Executable statement
    !

    if ( dust_utils_inited ) return



    ! デフォルト値の設定
    ! Default values settings
    !



    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = dust_utils_nml,           & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if



    ! Initialization of modules used in this module
    !

    ! 重力沈降過程
    ! Gravitational sedimentation process
    !
    call GravSedInit


    ! ヒストリデータ出力のためのへの変数登録
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'SurfDustGravSedFlux' , &
      & (/ AxNameX, AxNameY, AxNameT /), &
      & 'surface dust gravitational sedimentation flux', 'kg m-2 s-1' )


    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, 'CloudOverlapType     = %c', c1 = trim(CloudOverlapType) )
!!$    call MessageNotify( 'M', module_name, 'CCNMixRatPerUnitMass = %f', d = (/ CCNMixRatPerUnitMass /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    dust_utils_inited = .true.

  end subroutine DustUtilsInit

  !--------------------------------------------------------------------------------------

!!$  subroutine DustUtilsFinalize
!!$
!!$
!!$    ! 宣言文 ; Declaration statements
!!$    !
!!$
!!$    ! 実行文 ; Executable statement
!!$    !
!!$
!!$    if ( dust_utils_inited ) return
!!$
!!$
!!$    dust_utils_inited = .false.
!!$
!!$  end subroutine DustUtilsFinalize

  !--------------------------------------------------------------------------------------


end module dust_utils
