program main

  use vtype_module

  use netcdf
  use ni3_module

  use fi_module

  use set_1d_profile, only : Set1DProfileAtm
  use interpolate, only : Interpolate1D

  implicit none

  integer                 :: NcID
  character(extstr)       :: Mode
  character(extstr)       :: Name
  character(extstr)       :: StdName
  character(extstr)       :: LongName
  character(extstr)       :: Units
  integer                 :: NDims
  character(extstr), allocatable :: a_DimNames(:)


  real(dp)                :: TempConst

  real(dp)                :: Ps
  real(dp)                :: Ts

  integer , parameter     :: HITRANNMol = 47
  real(dp)                :: VMR(HITRANNMol)

!!$  integer                 :: NLevTmp
!!$  real(dp), allocatable   :: r_PressTmp(:)

  integer                 :: NLev
  real(dp), allocatable   :: r_Sigma(:)

  real(dp), allocatable   :: r_Press(:)
  integer                 :: NMol
  integer , allocatable   :: m_MolNum(:)             ! Molecular number
!!$  real(dp), allocatable   :: m_MolWt(:)              ! Molecular weight
  real(dp)                :: m_MolWt(1:3)              ! Molecular weight

  real(dp), allocatable   :: r_Temp  (:)
  real(dp), allocatable   :: rm_VMR  (:,:)

  real(dp), allocatable   :: r_MMRH2O(:)
  real(dp), allocatable   :: r_MMRO3 (:)

  real(dp)                :: MolWt

  real(dp), parameter     :: MeanMolWt = 28.966d-3

  real(dp), allocatable   :: r_Height(:)
  real(dp), parameter     :: GasConst = 8.314d0 / MeanMolWt
  real(dp), parameter     :: Grav     = 9.8d0

  character(128) :: ctlfn = 'mkprofile.conf'

  character(128) :: InNcFn
  character(128) :: OutNcFn
  character(128) :: PressName
  character(128) :: TempName
  character(128) :: H2OVapName
  character(128) :: O3Name

  integer, parameter :: MaxNmlArySize = 256
  real(8)            :: Sigma(MaxNmlArySize)

  integer :: FileUnit
  integer :: iostat

  integer :: k
  integer :: k2
  integer :: m


  namelist /file_nml/ &
    & InNcFn, OutNcFn, &
    & PressName, TempName, H2OVapName, O3Name

  namelist /atmosphere_nml/ &
    & NLev, Sigma, &
    & TempConst, &
    & NMol, VMR

  TempConst      = -1.0d0

  InNcFn      = ''
  OutNcFn     = ''
  !
  NLev     = 0
  Sigma(:) = 0.0d0
  !
  NMol        = 0
  VMR(:)      =  0.0d0
  VMR(1)      = -1.0d0
  VMR(2)      = 300.0d-6
  VMR(3)      = -1.0d0


  call fi_open( CtlFN, "read", FileUnit )
  !
  rewind( FileUnit )
  read( FileUnit, nml = file_nml, iostat = iostat )
  if ( iostat > 0 ) then
    stop 'Namelist, file_nml, is something wrong.'
  end if
  write( 6, nml = file_nml )
  !
  rewind( FileUnit )
  read( FileUnit, nml = atmosphere_nml, iostat = iostat )
  if ( iostat > 0 ) then
    stop 'Namelist, atmosphere_nml, is something wrong.'
  end if
  write( 6, nml = atmosphere_nml )
  !
  close( FileUnit )


  if ( NMol <= 0 ) then
    stop 'NMol has to be positive.'
  end if
  allocate( m_MolNum(NMol) )
!!$  allocate( m_MolWt (NMol) )
  do m = 1, NMol
    m_MolNum(m) = m
  end do
!!$  do m = 1, NMol
  do m = 1, min(NMol,3)
    m_MolNum(m) = m
    !
    select case ( m )
    case ( 1 )
      MolWt = 0.0180152636021376
    case ( 2 )
      MolWt = 0.044009767472744
    case ( 3 )
      MolWt = 0.0479970946907997
    case default
      write( 6, * ) 'Unexpected case'
      stop
    end select
    m_MolWt (m) = MolWt
  end do


  !
  ! Input
  !

  if ( NLev <= 0 ) then

    Mode = "read"
    call ni3_open( InNcFN, Mode, NcID )
    call ni3_inq_dimlen( NcID, "plev", NLev )

    allocate( r_Press ( NLev ) )
    allocate( r_Temp  ( NLev ) )
    allocate( r_MMRH2O( NLev ) )
    allocate( r_MMRO3 ( NLev ) )

    call ni3_get_var( NcID, PressName , r_Press  )
    call ni3_get_var( NcID, TempName  , r_Temp   )
    call ni3_get_var( NcID, H2OVapName, r_MMRH2O )
    call ni3_get_var( NcID, O3Name    , r_MMRO3  )

    call ni3_close( NcID )


!!$    do k = 1, NLev
!!$!      r_Temp(k) = 220.0d0 - 20.0d0 * log10(r_Press(k)/r_Press(1))
!!$      r_Temp(k) = 280.0d0 + 20.0d0 * log10(r_Press(k)/r_Press(1))
!!$    end do


    ! Set uniform temperature and mixing ratios
    !
    Ps = r_Press(1)
    if ( TempConst > 0.0d0 ) then
      r_Temp = TempConst
    end if
    Ts = r_Temp (1)

  else

    allocate( r_Sigma ( NLev ) )

!!$    r_Sigma(1) = 1.0d0
!!$    do k = 1+1, NLev
!!$      r_Sigma(k) = r_Sigma(k-1) * exp( - 1.0d0 / 20.0d0 )
!!$    end do
    r_Sigma = Sigma(1:NLev)
    ! check
    if ( r_Sigma(1) /= 1.0d0 ) then
      write( 6, * ) 'Sigma(1) has to be 1, but is ', r_Sigma(1), '.'
      stop
    end if
!!$    if ( r_Sigma(NLev) /= 0.0d0 ) then
!!$      write( 6, * ) 'Sigma(Nlev) has to be 0, but is ', r_Sigma(NLev), '.'
!!$      stop
!!$    end if

    allocate( r_Press ( NLev ) )
    allocate( r_Temp  ( NLev ) )
    allocate( r_MMRH2O( NLev ) )
    allocate( r_MMRO3 ( NLev ) )

    call Set1DProfileAtm(      &
      & InNcFN, PressName, TempName, H2OVapName, O3Name, &
      & NLev, r_Sigma,       &
      & Ps, r_Press, Ts, r_Temp, r_MMRH2O, r_MMRO3       &
      & )

    deallocate( r_Sigma )

  end if


  allocate( rm_VMR(NLev, NMol) )
  !
  if ( NMol >= 1 ) then
    if ( VMR(1) >= 0.0d0 ) then ! H2O
      rm_VMR(:,1) = VMR(1)
    else
      rm_VMR(:,1) = r_MMRH2O * MeanMolWt / m_MolWt(1)
    end if
  end if
  if ( NMol >= 2 ) then
    rm_VMR(:,2) = VMR(2)
  end if
  if ( NMol >= 3 ) then
    if ( VMR(3) >= 0.0d0 ) then ! O3
      rm_VMR(:,3) = VMR(3)
    else
      rm_VMR(:,3) = r_MMRO3  * MeanMolWt / m_MolWt(3)
    end if
  end if
  do m = 4, NMol
    rm_VMR(:,m) = VMR(m)
  end do



!!$  do k = NLev, 1+1, -1
!!$    r_Press(k)  = r_Press(k-1)
!!$    r_Temp(k)   = r_Temp(k-1)
!!$    do m = 1, NMol
!!$      rm_VMR(k,m) = rm_VMR(k-1,m)
!!$    end do
!!$  end do
!!$  k = 1
!!$  r_Press(k)  = 1120.0d2
!!$  r_Temp (k)  = ( r_Temp(3) - r_Temp(2) ) / ( r_Press(3) - r_Press(2) ) * ( r_Press(1) - r_Press(2) ) + r_Temp(2)
!!$  do m = 1, NMol
!!$    rm_VMR(k,m) = rm_VMR(k+1,m)
!!$  end do



  allocate( r_Height(NLev) )
  r_Height(1) = 0.0d0
  do k = 1+1, NLev
    r_Height(k) = r_Height(k-1) &
      & - GasConst * ( r_Temp(k) + r_Temp(k-1) ) / 2.0d0 / Grav &
      &   * log( r_Press(k) / r_Press(k-1) )
  end do


  r_Press  = r_Press * 1.0d-2
  rm_VMR   = rm_VMR * 1.0d6
  r_Height = r_Height * 1.0d-3

  r_Press = max( r_Press, 1.0d-3 )
  do k = 1+1, NLev
    if ( r_Press(k) >= r_Press(k-1) ) then
      write( 6, * ) 'Pressure does not change monotonically'
      do k2 = 1, NLev
        write( 6, * ) k2, r_Press(k2)
      end do
      stop
    end if
  end do

  write( 6, * ) '-----------------------'
  write( 6, * ) 'Output for LBLRTM TAPE5'
  write( 6, * ) '-----------------------'
  !
  do k2 = 1, NLev, 8
    write( 6, '(8f10.3)' ) ( ( r_Height(k) ), k = k2, min(k2+8-1,NLev) )
  end do
  write( 6, '(i5,a24)' ) NLev, trim( InNcFN )
  do k = 1, NLev
    write( 6, '(f10.3,f10.3,f10.3,5x,a1,a1,1x,a1,1x,28a1)' ) &
      & r_Height(k), r_Press(k), r_Temp(k), &
      & 'A', & ! unit of pressure (hPa)
      & 'A', & ! unit of temperature (K)
      & ' ', & ! short record for molecular information (blank)
      & ( 'A', m = 1, NMol )  ! unit of molecular amount (ppmv)
    write( 6, '(8E10.3)' ) ( rm_VMR(k,m), m = 1, min(NMol,8) )
  end do
  !
!!$  do k2 = 1, NLev, 8
!!$    write( 6, '(8f10.3)' ) ( ( r_Press(k) ), k = k2, min(k2+8-1,NLev) )
!!$  end do
!!$  write( 6, '(i5,a24)' ) -NLev, trim( InNcFN )
!!$  do k = 1, NLev
!!$    write( 6, '(f10.3,f10.3,f10.3,5x,a1,a1,1x,a1,1x,28a1)' ) &
!!$      & r_Height(k), r_Press(k), r_Temp(k), &
!!$      & 'A', & ! unit of pressure (hPa)
!!$      & 'A', & ! unit of temperature (K)
!!$      & ' ', & ! short record for molecular information (blank)
!!$      & ( 'A', m = 1, NMol )  ! unit of molecular amount (ppmv)
!!$    write( 6, '(8E10.3)' ) ( rm_VMR(k,m), m = 1, min(NMol,8) )
!!$  end do
  !
!!$  do k2 = 1, NLev, 8
!!$    write( 6, '(8f10.3)' ) ( ( r_Press(NLev-k+1) ), k = k2, min(k2+8-1,NLev) )
!!$  end do
!!$  write( 6, '(i5,a24)' ) -NLev, trim( InNcFN )
!!$  do k = NLev, 1, -1
!!$    write( 6, '(e10.3,e10.3,e10.3,5x,a1,a1,1x,a1,1x,28a1)' ) &
!!$      & 0.0d0, r_Press(k), r_Temp(k), &
!!$      & 'A', & ! unit of pressure (hPa)
!!$      & 'A', & ! unit of temperature (K)
!!$      & ' ', & ! short record for molecular information (blank)
!!$      & ( 'A', m = 1, NMol )  ! unit of molecular amount (ppmv)
!!$    write( 6, '(8E10.3)' ) ( rm_VMR(k,m), m = 1, min(NMol,8) )
!!$  end do

  ! Output

  call ni3_open( OutNcFN, "new", NcID )

  Name     = "Press"
  StdName  = Name
  LongName = "Pressure"
  Units    = "hPa"
  call ni3_set_dim( NcID, Name, NF90_DOUBLE, r_Press, &
    & StdName, LongName, Units )
  Name     = "MolNum"
  StdName  = Name
  LongName = "Molecular number"
  Units    = "1"
  call ni3_set_dim( NcID, Name, NF90_DOUBLE, m_MolNum, &
    & StdName, LongName, Units )


  NDims = 1
  allocate( a_DimNames( NDims ) )
  !
  Name     = "Temp"
  StdName  = Name
  LongName = "Temperature"
  Units    = "K"
  a_DimNames( 1 ) = "Press"
  call ni3_def_var( NcID, Name, NF90_DOUBLE, NDims, a_DimNames, &
    & StdName, LongName, Units )
  call ni3_put_var( NcID, Name, r_Temp )
!!$  !
!!$  Name     = "MolWt"
!!$  StdName  = Name
!!$  LongName = "Molecular weight"
!!$  Units    = "kg mol-1"
!!$  a_DimNames( 1 ) = "MolNum"
!!$  call ni3_def_var( NcID, Name, NF90_DOUBLE, NDims, a_DimNames, &
!!$    & StdName, LongName, Units )
!!$  call ni3_put_var( NcID, Name, m_MolWt )
  !
  deallocate( a_DimNames )


  NDims = 2
  allocate( a_DimNames( NDims ) )
  !
  Name     = "VMR"
  StdName  = Name
  LongName = "Volume mixing ratio"
  Units    = "1e-6"
  a_DimNames( 1 ) = "Press"
  a_DimNames( 2 ) = "MolNum"
  call ni3_def_var( NcID, Name, NF90_DOUBLE, NDims, a_DimNames, &
    & StdName, LongName, Units )
  call ni3_put_var( NcID, Name, rm_VMR )
  !
  deallocate( a_DimNames )

  !-------------------

  NDims = 0
  allocate( a_DimNames( NDims ) )
  !
  Name     = "Ts"
  StdName  = Name
  LongName = "Surface temperature"
  Units    = "K"
  call ni3_def_var( NcID, Name, NF90_DOUBLE, NDims, a_DimNames, &
    & StdName, LongName, Units )
  call ni3_put_var( NcID, Name, Ts )
  !
  Name     = "Ps"
  StdName  = Name
  LongName = "Surface pressure"
  Units    = "Pa"
  call ni3_def_var( NcID, Name, NF90_DOUBLE, NDims, a_DimNames, &
    & StdName, LongName, Units )
  call ni3_put_var( NcID, Name, Ps )
  !
  deallocate( a_DimNames )

  call ni3_close( NcID )


end program main
