
module interpolate

  use vtype_module

  implicit none

  private


  public :: Interpolate1D


  !--------------------------------------------------------------------------------------

contains

  !--------------------------------------------------------------------------------------

  subroutine Interpolate1D( &
    & NLev, a_Press, a_Array,         &
    & kmax, z_Press,                  &
    & z_Array                         &
    & )

    integer , intent(in ) :: NLev
    real(DP), intent(in ) :: a_Press  (1:NLev)
    real(DP), intent(in ) :: a_Array  (1:NLev)
    integer , intent(in ) :: kmax
    real(DP), intent(in ) :: z_Press(1:kmax)
    real(DP), intent(out) :: z_Array(1:kmax)


    !
    ! local variables
    !
    integer :: k
    integer :: kk


    do k = 1, kmax

      if( z_Press(k) <= a_Press(NLev) ) then
        z_Array(k) = a_Array(NLev)
      else
        search_loop : do kk = 2, NLev
          if( a_Press( kk ) < z_Press(k) ) exit search_loop
        end do search_loop
        if( kk > NLev ) &
          stop 'Unexpected error in setting temperature profile'
        z_Array(k) =                                     &
          &   ( a_Array( kk ) - a_Array( kk-1 ) )        &
          & / ( log( a_Press(kk  ) / a_Press( kk-1 ) ) ) &
          & * ( log( z_Press(k   ) / a_Press( kk-1 ) ) ) &
          & + a_Array( kk-1 )
      end if

    end do


  end subroutine Interpolate1D

  !--------------------------------------------------------------------------------------

end module interpolate
