  program main

    use vtype_module
    use ni3_module
    use fi_module

    implicit none

    character(len=extstr)            :: infn
    integer(i4b)                     :: fu


    integer(i4b)                     :: nheader
    integer(i4b)                     :: km

    integer     , allocatable        :: a_Lev     ( : )
    real(dp)    , allocatable        :: a_Press   ( : )
    real(dp)    , allocatable        :: a_UwFlux  ( : )
    real(dp)    , allocatable        :: a_DwFlux  ( : )
    real(dp)    , allocatable        :: a_NetFlux ( : )
    real(dp)    , allocatable        :: a_Tendency( : )


    character(len=extstr)            :: ncfn
    integer(i4b)                     :: ncid
    character(len=extstr)            :: mode, title, com, ref, &
         name, stdname, longname, units
    integer(i4b)         , parameter :: ndims = 1
    character(len=extstr)            :: dimname( ndims )
!!$    real(dp)                         :: fillvalue

    integer(i4b)          :: k
    integer(i4b)          :: l

    integer(i4b)          :: IDPro


    ! Seiff et al.
    IDPro = 1
    ! Hourdin
!!$    IDPro = 2


    title   = 'LBLRTM result'
    infn    = '../OUTPUT_RADSUM'
    ncfn    = "out/LBLRTM_Flux_Tendency.nc"
    ref     = ""
    nheader = 5
    km      = fi_lc( infn, nheader )

    allocate( a_Lev     ( km ) )
    allocate( a_Press   ( km ) )
    allocate( a_UwFlux  ( km ) )
    allocate( a_DwFlux  ( km ) )
    allocate( a_NetFlux ( km ) )
    allocate( a_Tendency( km ) )

    !
    ! Input
    !
    fu = 50
    open( fu, file = infn, status='unknown' )
    do l = 1, nheader
      read( fu, * )
    end do
    do k = 1, km
      read( fu, * ) a_Lev( k ), a_Press( k ), a_UwFlux( k ), a_DwFlux( k ), a_NetFlux( k ), a_Tendency( k )
    end do

    close( fu )

    a_Press    = a_Press    * 1.0d2
    a_Tendency = a_Tendency / 86400.0d0

!!$    a_Press = a_Press / a_Press(km)
!!$    write( 6, * ) (a_Press(k),k=km,1,-1)


    !
    ! Output to a NetCDF file
    !
    mode = "new"
    call ni3_open( ncfn, mode, ncid )

!    com   = "Mixing ratio of H2O and O3 are converted from mass density with the use of mean atmospheric molecular weight of 28.966e-3 kg mol-1."
!!$    call ni3_set_ga( ncid, title = title, com = com, ref = ref )
    call ni3_set_ga( ncid, title = title, ref = ref )


    name     = "plev"
    stdname  = "plev"
    longname = 'pressure'
    units    = "Pa"
    call ni3_set_dim( ncid, name, NI3_REAL, a_Press, &
      stdname = stdname, longname = longname, units  = units )
    call ni3_put_att( ncid, name, 'positive', 'down' )
    !
    dimname( 1 ) = "plev"


    name         = "lev"
    stdname      = "lev"
    longname     = stdname
    units        = "1"
    call ni3_def_var( ncid, name, NI3_INT, ndims, dimname, &
         stdname = stdname, longname = longname, units = units )
    call ni3_put_var( ncid, name, a_Lev )

    name         = "RadUwFlux"
    stdname      = "upward_flux"
    longname     = stdname
    units        = "W m-2"
    call ni3_def_var( ncid, name, NI3_REAL, ndims, dimname, &
         stdname = stdname, longname = longname, units = units )
    call ni3_put_var( ncid, name, a_UwFlux )

    name         = "RadDwFlux"
    stdname      = "downward_flux"
    longname     = stdname
    units        = "W m-2"
    call ni3_def_var( ncid, name, NI3_REAL, ndims, dimname, &
         stdname = stdname, longname = longname, units = units )
    call ni3_put_var( ncid, name, a_DwFlux )

    name         = "NetFlux"
    stdname      = "net_flux"
    longname     = stdname
    units        = "W m-2"
    call ni3_def_var( ncid, name, NI3_REAL, ndims, dimname, &
         stdname = stdname, longname = longname, units = units )
    call ni3_put_var( ncid, name, a_NetFlux )

    name         = "DTempDt"
    stdname      = "tendency"
    longname     = stdname
    units        = "K s-1"
    call ni3_def_var( ncid, name, NI3_REAL, ndims, dimname, &
         stdname = stdname, longname = longname, units = units )
    call ni3_put_var( ncid, name, a_Tendency )

    call ni3_close( ncid )


  end program main
