!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_integral_module
!
!  2002/05/25  ݹ 
!
module w_integral_module
  use w_base_module, only : im, jm, x_lon_weight, y_lat_weight

  implicit none

  private
 
  public intlonlat_xy                      ! ٷʬ
  public y_intlon_xy, intlon_x             ! ʬ    
  public x_intlat_xy, intlat_y             ! ʬ    
  public avrlonlat_xy                      ! ٷʿ
  public y_avrlon_xy, avrlon_x             ! ʿ    
  public x_avrlat_xy, avrlat_y             ! ʿ    

  contains

  !--------------- ʬ׻ -----------------
    function intlonlat_xy(xy_data)        ! ٷʬ
      real(8), intent(in)   :: xy_data(im,jm)         ! ʻ(im,jm)
      real(8) :: intlonlat_xy                         ! ʬ

      intlonlat_xy = intlon_x(x_intlat_xy(xy_data))
    end function intlonlat_xy

    function x_intlat_xy(xy_data)          ! ʬ
      real(8), intent(in) :: xy_data(im,jm)           ! ʻ(im,jm)
      real(8)             :: x_intlat_xy(im)          ! ʻ(im)
      integer :: j

      x_intlat_xy = 0
      do j=1,jm
         x_intlat_xy = x_intlat_xy + xy_data(:,j) * y_lat_weight(j)
      enddo

    end function x_intlat_xy

    function y_intlon_xy(xy_data)          ! ʬ
      real(8), intent(in) :: xy_data(im,jm)            ! ʻ(im,jm)
      real(8)             :: y_intlon_xy(jm)           ! ʻ(jm)
      integer :: i

      y_intlon_xy = 0
      do i=1,im
         y_intlon_xy = y_intlon_xy + xy_data(i,:) * x_lon_weight(i)
      enddo

    end function y_intlon_xy

    function intlat_y(y_data)          ! ʬ
      real(8), intent(in) :: y_data(jm)                ! ʻ(jm)
      real(8)             :: intlat_y                  ! ʬ

      intlat_y = sum(y_data * y_lat_weight)

    end function intlat_y

    function intlon_x(x_data)          ! ʬ
      real(8), intent(in) :: x_data(im)                ! ʻ(im)
      real(8)             :: intlon_x                  ! ʬ

      intlon_x = sum(x_data * x_lon_weight)

    end function intlon_x

  !--------------- ʿѷ׻ -----------------
    function avrlonlat_xy(xy_data)        ! ٷʿ
      real(8), intent(in)   :: xy_data(im,jm)        ! ʻ(im,jm)
      real(8) :: avrlonlat_xy                        ! ʿ

      avrlonlat_xy = avrlon_x(x_avrlat_xy(xy_data))
    end function avrlonlat_xy

    function x_avrlat_xy(xy_data)          ! ʿ
      real(8), intent(in) :: xy_data(im,jm)          ! ʻ(im,jm)
      real(8)             :: x_avrlat_xy(im)         ! ʻ(im)

      x_avrlat_xy = x_intlat_xy(xy_data)/sum(y_lat_weight)

    end function x_avrlat_xy

    function y_avrlon_xy(xy_data)          ! ʿ
      real(8), intent(in) :: xy_data(im,jm)          ! ʻ(im,jm)
      real(8)             :: y_avrlon_xy(jm)         ! ʻ(jm)

      y_avrlon_xy = y_intlon_xy(xy_data)/sum(x_lon_weight)

    end function y_avrlon_xy

    function avrlat_y(y_data)          ! ʿ
      real(8), intent(in) :: y_data(jm)              ! ʻ(jm)
      real(8)             :: avrlat_y                ! ʿ

      avrlat_y = intlat_y(y_data)/sum(y_lat_weight)

    end function avrlat_y

    function avrlon_x(x_data)          ! ʿ
      real(8), intent(in) :: x_data(jm)               ! ʻ(im,*)
      real(8)             :: avrlon_x                 ! ʿ

      avrlon_x = intlon_x(x_data)/sum(x_lon_weight)

    end function avrlon_x

  end module w_integral_module
