!----------------------------------------------------------------------
!     Copyright (c) 2002 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  yt_module
!      ΥȥȻ
!
!  2002/02/04  ݹ
!      2002/04/11  ݹ  ⥸塼̾ѹ
!
program ytdiff2

  use yt_module
  use gtool_history
  implicit none

 !---- ֲ ----
  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)

 !---- ɸѿʤ ----
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

 !---- ѿ ----
  real(8), dimension(im,jm,0:km)     :: ggg_torvel   ! ȥ®
  real(8), dimension((nm+1)**2,0:lm) :: yt_torvel    ! ȥ®
  real(8), dimension((nm+1)**2,0:lm) :: yt_torvelr   ! ȥ®/r

 !---- ʬѥ᥿ ----
  real(8), parameter :: dt=1e-5                 ! ֥ƥå״ֳ
  integer, parameter :: nt=10000, ndisp=1000    ! ʬ, ɽƥå

 !---- ʪѥ᥿ ----
  character(len=2), parameter :: tvbc='NN'      ! ®ٶ(DD/DN/ND/NN)
  real(8), parameter :: nu=1.0                  ! Ǵ

  real(8), parameter :: pi=3.1415926535897932385D0
  real(8), parameter :: lon1=pi                 ! ʬ۰ٺɸ
  real(8), parameter :: lat1=0.0                ! ʬ۷ٺɸ
  real(8), parameter :: rad1=(ri+ro)/2.0        ! ʬưºɸ
  real(8), parameter :: sigma=0.2               ! ʬۤ礭

 !---- ¾ ----
  integer :: it

 !---------------- ɸͤ ---------------------
  call yt_initial(im,jm,km,nm,lm,ri,ro)

 !-------------------  ----------------------
  ggg_torvel =  exp(-((ggg_lon-lon1)**2+(ggg_lat-lat1)**2+(ggg_rad-rad1)**2)&
                 /(2*sigma**2))
  yt_torvel = yt_ggg(ggg_torvel)

  call output_gtool4_init
  call output_gtool4

 !------------------- ʬ ----------------------
  do it=1,nt                                         ! Euler ˡˤʬ
     yt_torvel = yt_torvel + dt *( nu * yt_lapla_yt(yt_torvel))

     yt_torvelr = yt_yg(yg_yt(yt_torvel)/yg_rad)
     call ytboundaries(yt_torvelr,cond=tvbc)
     yt_torvel = yt_yg(yg_yt(yt_torvelr)*yg_rad)

     if(mod(it,ndisp) .eq. 0)then                    ! 
        ggg_torvel = ggg_yt(yt_torvel)
        call output_gtool4
     endif
  enddo
  call output_gtool4_close

contains

  subroutine output_gtool4_init
    call HistoryCreate( &                                  ! ҥȥ꡼
           file='yt_diff2.nc', title='Diffusion model in a spherical shell', &
           source='Sample program of spmodel library', &
           institution='GFD_Dennou Club SPMODEL project',     &
           dims=(/'lon','lat','rad','t  '/), dimsizes=(/im,jm,km+1,0/),&
           longnames=(/'Longitude','Latitude ','Radius   ','time     '/),&
           units=(/'1','1','1','1'/),   &
           origin=0.0, interval=real(ndisp*dt) )

    call HistoryPut('lon',g_lon/pi*180)                       ! ѿ
    call HistoryPut('lat',g_lat/pi*180)                       ! ѿ
    call HistoryPut('rad',g_rad)                              ! ѿ

    call HistoryAddVariable( &                                ! ѿ
           varname='torvel', dims=(/'lon','lat','rad','t  '/), & 
           longname='toriodal velocity potential', units='1', xtype='double')
  end subroutine output_gtool4_init

  subroutine output_gtool4
    write(6,*) 'it = ',it
    call HistoryPut('t',real(it*dt))
    call HistoryPut('torvel',ggg_torvel)
  end subroutine output_gtool4

  subroutine output_gtool4_close
    call HistoryClose
  end subroutine output_gtool4_close

end program ytdiff2
