=begin
=RubyNetCDF Reference Manual

* ((<Index>))

---------------------------------------------

==Overview

RubyNetCDF is the Ruby interface of the NetCDF library. Ruby is a free 
object-oriented scripting language and is available from
http://www.ruby-lang.org/. To handle numeric data, RubyNetCDF uses
NArray, which is the standard numeric multi-dimensional array class
for Ruby (http://www.ruby-lang.org/en/raa-list.rhtml?name=NArray).
An NArray object holds numeric data in a consecutive memory area
pointed by a C pointer. Thus, it is computationally efficient.
NArray is similar to NumPy for Python, but results of some benchmark
tests suggests that NArray is more efficient than NumPy.

====Structure

RubyNetCDF consists of the four class in the following.

* ((<class NetCDF>)) -- the file class

  An NetCDF object represents a NetCDF file

* ((<class NetCDFDim>)) -- the dimension class

  Although in its C version a NetCDF dimension is represented by a
  combination of a file ID and a dimension ID, it is represented by
  only one NetCDFDim object in RubyNetCDF.

* ((<class NetCDFVar>)) -- the variable class

  Although in its C version a NetCDF variable is represented by a
  combination of a file ID and a variable ID, it is represented by
  only one NetCDFVar object in RubyNetCDF.

* ((<class NetCDFAtt>)) -- the attribute class

  Although in its C version a NetCDF attribute is represented by a
  combination of file ID, variable ID, and its name, it is represented
  by only one NetCDFAtt object in RubyNetCDF.

====Error handling

Errors are basically handled by raising exceptions. However, light
errors in value-returning methods are handled by returning nil (e.g.,
if a non-existent attribute name is specified in attribute reading).
Those methods that returns nil on error are explicitly written as such 
in the following.

====Security features

Security handling is done just as in the pre-defined File class.

---------------------------------------------

==How to read this manual

--- method_name(argument1, argument2, ...) -- arguments that can be omitted are expressed as Argument_name=Default_value

     Explanation of its function

     Arguments
     * name of argument1 (its class or possible values): explanation
     * name of argument2 (its class or possible values): explanation
     * ...

     Return value
     * Explanation of the return value

     Corresponding (dependent) function(s) in the C library of NetCDF
     * Name(s) in NetCDF ver 3. The function equivalent to the current
       method, if not in parenthesis. If no direct correspondence,
       dependent functions are listed in parentheses.

---------------------------------------------

==Index
* ((<class NetCDF>))

  Class Methods
    * ((<NetCDF.open>))     Opens a file (class method). If mode="w" and non-existent, a new
    * ((<NetCDF.new>))     Aliased to NetCDF.open
    * ((<NetCDF.create>))     Creates a NetCDF file (class method)

  Instance Methods
    * ((<close>))     Closes the file.
    * ((<ndims>))     Returns the number of dimensions in the file
    * ((<nvars>))     Returns the number of variables in the file
    * ((<natts>))     Returns the number of global attributes in the file
    * ((<unlimited>))     Returns the unlimited dimension in the file
    * ((<path>))     Returns the path of the file (contents of the filename specified when opened/created)
    * ((<redef>))     Switches to the define mode. Does nothing if already in it.
    * ((<enddef>))     Switches to the data mode. Does nothing if already in it.
    * ((<sync>))     Synchronizes the disk copy of a netCDF dataset with in-memory buffer
    * ((<def_dim>))     Define a dimension
    * ((<put_att>))     Sets a global attribute
    * ((<def_var>))     Defines a variable
    * ((<var>))     Opens an existing variable in the file
    * ((<dim>))     Opens an existing dimension in the file
    * ((<att>))     Opens an existing global attribute in the file
    * ((<fill=>))     Sets a fill mode. (Default behavior of NetCDF is FILL.)
    * ((<each_dim>))     Iterator regarding the dimensions in the file.
    * ((<each_var>))     Iterator regarding the variables in the file.
    * ((<each_att>))     Iterator regarding the global attributes of the file.
    * ((<dim_names>))     Returns the names of all dimensions in the file
    * ((<var_names>))     Returns the names of all variables in the file
    * ((<att_names>))     Returns the names of all the global attributes of the file
* ((<class NetCDFDim>))

  Class Methods

  Instance Methods
    * ((<length>))     Returns the length of the dimension
    * ((<name=>))     Rename the dimension
    * ((<name>))     Returns the name of the  dimension
    * ((<unlimited?>))     Inquires whether the dimension is unlimited or not
* ((<class NetCDFVar>))

  Class Methods

  Instance Methods
    * ((<dim>))     Inquires the dim_num-th dimension of the variable (dim_num=0,1,2,..)
    * ((<dims>))     Returns an array of all the dimensions of the variable
    * ((<each_att>))     Iterator regarding the global attributes of the variables.
    * ((<dim_names>))     Returns the names of all the dimensions of the variable
    * ((<att_names>))     Returns the names of all the attributes of the variable
    * ((<name>))     Returns the name of the variable
    * ((<name=>))     Rename the variable
    * ((<ndims>))     Number of dimensions of the variable (which is rank of the variable).
    * ((<ntype>))
    * ((<vartype>))     Data value type of the variable
    * ((<natts>))     Returns the number of the attributes of the variable
    * ((<file>))     Inquires the file that the variable is in
    * ((<att>))     Returns the attribute specified by its name
    * ((<put_att>))     Sets an attribute
    * ((<put>))     Set the values of the variable
    * ((<get>))     Returns values of the variable
* ((<class NetCDFAtt>))

  Class Methods

  Instance Methods
    * ((<name>))     Returns the name of the attribute
    * ((<name=>))     Rename the attribute
    * ((<copy>))     Copies an attribute to a variable or a file. If file, becomes an global attribute
    * ((<delete>))     Delete an attribute
    * ((<put>))     Sets the value of the attribute
    * ((<get>))     Returns the values of the attribute
    * ((<atttype>))     Inquires the type of attribute values

---------------------------------------------

=class NetCDF
====Class Methods
---NetCDF.open(filename, mode="r", share=false)
     Opens a file (class method). If mode="w" and non-existent, a new
     file is created.

     Arguments
     * filename (String): file name (path)
     * mode (String) : IO mode "r"(read only), "w"(writable)
     * share (true or false) : Whether to use the "shared" mode or not 
       (set true if a file being written may be read from other
       processes. See nc_open in Ch.5 of users' guide of the C version)

     Return value
     * a NetCDF object

     Corresponding (dependent) function(s) in the C library of NetCDF 
     * nc_open, nc_create

---NetCDF.new
     Aliased to NetCDF.open

---NetCDF.create(filename, noclobber=false, share=false)
     Creates a NetCDF file (class method)
     
     Arguments
     * filename (String) : file name (path)
     * noclobber (true or false) : overwrite or not if the file exists
     * share (true or false) : sharedɂ邩

     Return value
     *  a NetCDF object

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_create

====Instance Methods
---close
     Closes the file.

     Arguments
     *  (none)

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_close

---ndims
     Returns the number of dimensions in the file

     Arguments
     *  (none)

     Return value
     *  Integer

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_ndims

---nvars
     Returns the number of variables in the file
   
     Arguments
     *  (none)

     Return value
     *  Integer
     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_nvars

---natts
     Returns the number of global attributes in the file

     Arguments
     *  (none)

     Return value
     *  Integer

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_natts

---unlimited
     Returns the unlimited dimension in the file

     Arguments
     *  (none)

     Return value
     *  a NetCDFDim if it exists; nil if not

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_unlimdim

---path
     Returns the path of the file (contents of the filename specified when opened/created)

     Arguments
     *  (none)

     Return value
     *  String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (none)

---redef
     Switches to the define mode. Does nothing if already in it.

     Arguments
     *  (none)

     Return value
     *  nil
     
     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_redef

---enddef
     Switches to the data mode. Does nothing if already in it.

     Arguments
     *  (none)

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_enddef

---sync
     Synchronizes the disk copy of a netCDF dataset with in-memory buffer

     Arguments
     *  (none)

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_sync

---def_dim(dimension_name, length)
     Define a dimension

     Arguments
     * dimension_name (String) : Name of the dimension to be defined
     * length (Integer) : length of the dimension. 0 for unlimited.

     Return value
     *  defined dimension (NetCDFDim object)

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_def_dim

---put_att(attribute_name, value, atttype=nil)
     Sets a global attribute

     Arguments
     * attribute_name (String) : name of the global attribute
     * value (Numeric, String, Array of Numeric, or NArray) : value of the attribute
     * atttype (nil or String) : data type of the attribute value.
       nil lets it automatically determined from the value.
       "string", "byte", "sint", "int", "sfloat", or "float" specifies 
       the type explicitly (1,1,2,4,4,8 bytes, respectively)

     Return value
     *  created attribute (NetCDFAtt object)

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_put_att_<type>

---def_var(variable_name, vartype, dimensions)
     Defines a variable

     Arguments
     * variable_name (String) : Name of the variable to define
     * vartype (String) : data type of the variable ("byte", "sint",
       "sint", "int", "sfloat", or "float")
     * dimensions (Array) : Dimensions of the variable. An Array of
       NetCDFDim, in the order from the fastest varying dimension to
       the slowliest varying one; its length becomes the rank of the
       variable.

     Return value
     *  defined variable (NetCDFVar object)

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_def_var

---var(var_name)
     Opens an existing variable in the file

     Arguments
     * var_name (String) : Name of the variable to open

     Return value
     *  a NetCDFVar object if the variable exists; nil if not

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_varid

---dim(dimension_name)
     Opens an existing dimension in the file

     Arguments
     * dimension_name (String) : Name of the dimension to open

     Return value
     *  a NetCDFDim object if the dimension exists; nil if not

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_dimid

---att(attribute_name)
     Opens an existing global attribute in the file

     Arguments
     * attribute_name (String) : Name of the global attribute to open

     Return value
     *  a NetCDFAtt object if the attribute exists; nil if not

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (nc_inq_attid used for inquiry)

---fill=(filemode)
     Sets a fill mode. (Default behavior of NetCDF is FILL.)

     Arguments
     * fillmode (true or false)

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_set_fill

---each_dim{ ... }
     Iterator regarding the dimensions in the file.
     Ex.: {|i| print i.name,"\n"} prints names of all dimensions

     Arguments
     * { ... } : Block for the iterator. A "do end" block is the alternative.

     Return value
     *  self

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_ndims)

---each_var{ ... }
     Iterator regarding the variables in the file.
     Ex.: {|i| print i.name,"\n"} prints names of all variables

     Arguments
     * { ... } :  Block for the iterator. A "do end" block is the alternative.

     Return value
     *  self

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_nvars)

---each_att{ ... }
     Iterator regarding the global attributes of the file.
     Ex.: {|i| print i.name,"\n"} prints names of all of them.

     Arguments
     * { ... } : Block for the iterator. A "do end" block is the alternative.

     Return value
     *  self

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_natts, nc_inq_attname)

---dim_names
     Returns the names of all dimensions in the file

     Arguments
     *  (none)

     Return value
     *  Array of NetCDFDim

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (nc_inq_ndims, nc_inq_dimname)

---var_names
     Returns the names of all variables in the file

     Arguments
     *  (none)

     Return value
     *  Array of String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_nvars, nc_inq_varname)

---att_names
     Returns the names of all the global attributes of the file

     Arguments
     *  (none)

     Return value
     *  Array of NetCDFAtt

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_natts, nc_inq_attname)

---------------------------------------------

=class NetCDFDim
====Class Methods

====Instance Methods
---length
     Returns the length of the dimension

     Arguments
     *  (none)

     Return value
     *  Integer

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_dimlen

---name=(dimension_newname)
     Rename the dimension

     Arguments
     * dimension_newname (String) : new name

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_rename_dim

---name
     Returns the name of the  dimension

     Arguments
     *  (none)

     Return value
     *  String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_dimname

---unlimited?
     Inquires whether the dimension is unlimited or not

     Arguments
     *  (none)

     Return value
     *  true or false

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_unlimdim)

---------------------------------------------

=class NetCDFVar
====Class Methods

====Instance Methods
---dim(dim_num)
     Inquires the dim_num-th dimension of the variable (dim_num=0,1,2,..)

     Arguments
     * dim_num (Fixnum) : 0,1,...  0 is the fastest varying dimension.

     Return value
     *  a NetCDFDim object

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_vardimid)

---dims
     Returns an array of all the dimensions of the variable

     Arguments
     *  (none)

     Return value
     *  Array of NetCDFDim objects.

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_vardimid

---each_att{ ... }
     Iterator regarding the global attributes of the variables.
     Ex.: {|i| print i.name,"\n"} prints names of all of them.

     Arguments
     * { ... }  : Block for the iterator. A "do end" block is the alternative.

     Return value
     *  self

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_natts, nc_inq_attname)

---dim_names
     Returns the names of all the dimensions of the variable

     Arguments
     *  (none)

     Return value
     *  Array of String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_varndims, nc_inq_vardimid, nc_inq_dimname)

---att_names
     Returns the names of all the attributes of the variable

     Arguments
     *  (none)

     Return value
     *  Array of String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (dependent on nc_inq_natts, nc_inq_attname)

---name
     Returns the name of the variable
 
     Arguments
     *  (none)

     Return value
     *  String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_varname

---name=(variable_newname)
     Rename the variable

     Arguments
      * variable_newname (String) : new name

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_rename_var

---ndims
     Number of dimensions of the variable (which is rank of the variable).

     Arguments
     *  (none)

     Return value
     *  Integer

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_varndims

---ntype
---vartype
     Data value type of the variable

     Arguments
     *  (none)

     Return value
     *  String ("string","byte","sint","int","sfloat", or "float")

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_vartype

---natts
     Returns the number of the attributes of the variable

     Arguments
     *  (none)

     Return value
     *  Integer

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_varnatts

---file
     Inquires the file that the variable is in

     Arguments
     *  (none)

     Return value
     *  a NetCDF object

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (none)

---att(attribute_name)
     Returns the attribute specified by its name

     Arguments
     * attribute_name (String) : Name of the attribute

     Return value
     *  a NetCDFAtt object if the attribute exists; nil if not

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (nc_inq_attid is used for inquiry)

---put_att(attribute_name, value, atttype=nil)
     Sets an attribute

     Arguments
     * attribute_name (String) : name of the attribute
     * value (Numeric, String, Array of Numeric, or NArray) : value of the attribute
     * atttype (nil or String) : data type of the attribute value.
       nil lets it automatically determined from the value.
       "string", "byte", "sint", "int", "sfloat", or "float" specifies 
       the type explicitly (1,1,2,4,4,8 bytes, respectively)

     Return value
     *  a NetCDFAtt object

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_put_att_<type>

---put(value, option=nil)
     Set the values of the variable

     Arguments
     * value : value to set (Numeric, Array of Numeric (1D only), or 
       NArray (possibly multi-D))
     * option (Hash) : Optional argument to limit the portion of the
       variable to output values. If omitted, the whole variable is
       subject to the output. This argument accepts a Hash whose keys
       contain either "index" or a combination of "start","end", and
       "stride". The value of "index" points the index of a scalar
       portion of the variable. The other case is used to designate a
       regularly ordered subset, where "start" and "end" specifies
       bounds in each dimension and "stride" specifies intervals in
       it. As in Array "start", "end", and "index" can take negative
       values to specify index backward from the end. However,
       "stride" has to be positive, so reversing the array must be
       done afterwards if you like.

       Example: If the variable is 2D:

       {"start"=>[2,5],"end"=>[6,-1],"stride"=>[2,4]} -- Specifies a 
       subset made as follows: the 1st dimension from the element 2
       to the element 6 (note that the count starts with 0, so that
       the element 2 is the 3rd one) with an interval of 2; 
       the 2nd dimension from the element 6 to the last element
       (designated by -1) with an interval of 5.

       {"index"=>[0,0]}: Scalar of the fist element

       {"index"=>[0,-2]}: Scalar from the 1st element of with
       respect to the 1st dimension and the 2nd element from the last
       with respect to the 2nd dimension


     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_put_var_<type>, nc_put_vars_<type>, nc_put_var1_<type>

---get(option=nil)
     Returns values of the variable

     Arguments
     * option (Hash) : Optional argument to limit the portion of the
       variable to get values. Its usage is the same as in the method
       put.

     Return value
     *  an NArray object

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_get_var_<type>, nc_get_vars_<type>, nc_get_var1_<type>

---------------------------------------------

=class NetCDFAtt
====Class Methods

====Instance Methods
---name
     Returns the name of the attribute

     Arguments
     *  (none)

     Return value
     *  String

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  (none)

---name=(attribute_newname)
     Rename the attribute

     Arguments
     * attribute_newname (String) : New name

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_rename_att

---copy(var_or_file)
     Copies an attribute to a variable or a file. If file, becomes an global attribute

     Arguments
     * var_or_file (NetCDFVar or NetCDF)

     Return value
     *  Resultant new attribute (NetCDFAtt)

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_copy_att

---delete
     Delete an attribute

     Arguments
     *  (none)

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_del_att

---put(value, atttype=nil)
     Sets the value of the attribute

     Arguments
     * value (Numeric, String, Array of Numeric, or NArray) : value of the attribute
     * atttype (nil or String) : data type of the attribute value.
       nil lets it automatically determined from the value.
       "string", "byte", "sint", "int", "sfloat", or "float" specifies 
       the type explicitly (1,1,2,4,4,8 bytes, respectively)

     Return value
     *  nil

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_put_att_<type>

---get
     Returns the values of the attribute

     Arguments
     *  (none)

     Return value
     *  String or an NArray object (NOTE: even a scalar is returned as
        an NArray of length 1)
     
     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_get_att_<type>

---atttype
     Inquires the type of attribute values

     Arguments
     *  (none)

     Return value
     *  "string","byte","sint","int","sfloat","float"

     Corresponding (dependent) function(s) in the C library of NetCDF
     *  nc_inq_atttype

=end
