require 'rubyunit'
require 'spherical.rb'

class TestDummySpherical < RUNIT::TestCase

  def test_init
    sp = DummySpherical.new

    #<< pattern1 : >>
    mm = 10
    jm = 10
    im = 10
    goodworksize = (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15

    work, = sp.init(mm, jm, im)
    assert_equal(work.size, goodworksize)

    #<< pattern2 : >>
    mm = 10
    jm = 20
    im = 10
    goodworksize = (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15

    work, = sp.init(mm, jm, im)
    assert_equal(work.size, goodworksize)

    #<< pattern3  : >>
    mm = 10
    jm = 5
    im = 10
    goodworksize = (jm+1)*(4*jm+5*mm+14)+(mm+1)*(mm+1)+mm+2+6*im+15

    work, mmr, jmr, imr = sp.init(mm, jm, im)
    assert_equal(mmr, mm)
    assert_equal(jmr, jm)
    assert_equal(imr, im)
  end

  def test_setwn
    sp = DummySpherical.new
    #<<pattern1 : $BFnKL0lMM(B, $BEl@>GH?t(B 1 $B$N%G!<%?(B(cos)>>
    nx = 100; ny = 51    
    x = NMath::sin(2*NMath::PI*NArray.sfloat(nx).indgen!/(nx-1))
    ln = x.shape[0]-1; x = x[[0..ln, 0],false]
    xx = x.newdim(1)
    y = NArray.sfloat(ny).fill!(1.0)
    yy = y.newdim(0)
    zz = xx*yy
    z, *ary = sp.setwn(zz)

    assert_equal(ary, [50, 25, 50])
  end

  def test_xderiv
    sp = DummySpherical.new

    #<<pattern1 : $BFnKL0lMM(B, $BEl@>GH?t(B 1 $B$N%G!<%?(B(cos)>>
    nx = 101; ny =51    
    x = NMath::sin(2*NMath::PI*NArray.float(nx).indgen!/(nx-1))
    ln = x.shape[0]-1; x[-1, false] = x[0,false]
    xx = x.newdim(1)
    y = NArray.float(ny).fill!(1.0)
    yy = y.newdim(0)
    zz = xx*yy
    d_dx_sp = sp.xderiv(zz)
    ans = NMath::cos(2*NMath::PI*NArray.sfloat(nx).indgen!/(nx-1)).newdim(1)*yy
    assert_equal(d_dx_sp.shape, ans.shape)
#    assert_equal(d_dx_sp, ans)
  end

  def test_yderiv 
    sp = DummySpherical.new

    #<<pattern1 : $BFnKL0lMM(B, $BEl@>GH?t(B 1 $B$N%G!<%?(B(cos)>>
    nx = 101; ny =51
    x = NArray.float(nx).fill!(1.0)
    xx = x.newdim(1)
    y = NMath::sin(NMath::PI*NArray.float(ny).indgen!/(ny-1)+0.5)
    yy = y.newdim(0)
    zz = xx*yy
    d_dy_sp = sp.yderiv(zz)
    ans = xx*NMath::cos(NMath::PI*NArray.sfloat(ny).indgen!/(ny-1)).newdim(0)
    assert_equal(d_dy_sp.shape, ans.shape)
#    assert_equal(d_dy_sp, ans)
  end
  
  
  def test_div 
    sp = DummySpherical.new

    #<<pattern1 : (sin \phi, sin \theta) $B$N%Y%/%H%k(B>>
    nx = 101; ny =51

    x = NMath::sin(2*NMath::PI*NArray.float(nx).indgen!/(nx-1))
    ln = x.shape[0]-1; x[-1, false] = x[0,false]
    xx = x.newdim(1)
    y = NArray.float(ny).fill!(1.0)
    yx = y.newdim(0)
    zx = xx*yx    #<<x component>>

    x = NArray.float(nx).fill!(1.0)
    xy = x.newdim(1)
    y = NMath::sin(NMath::PI*NArray.float(ny).indgen!/(ny-1)+0.5)
    yy = y.newdim(0)
    zy = xy*yy    #<<y component>>

    divz = sp.div(zx, zy)
    ans = 0

    assert_equal(divz, ans)
  end
  
  def test_xdiv 
    sp = DummySpherical.new
    #<<pattern1 : (sin \phi, 0) $B$N%Y%/%H%k(B>>
    nx = 101; ny =51

    x = NMath::sin(2*NMath::PI*NArray.float(nx).indgen!/(nx-1))
    ln = x.shape[0]-1; x[-1, false] = x[0,false]
    xx = x.newdim(1)
    y = NArray.float(ny).fill!(1.0)
    yx = y.newdim(0)
    zx = xx*yx    #<<x component>>

    xdivz = sp.xdiv(zx)
    ans = 0

    assert_equal(xdivz, ans)
  end

  def test_ydiv 
    sp = DummySpherical.new
    #<<pattern1 : (0, sin \theta) $B$N%Y%/%H%k(B>>

    nx = 101; ny =51

    x = NArray.float(nx).fill!(1.0)
    xy = x.newdim(1)
    y = NMath::sin(NMath::PI*NArray.float(ny).indgen!/(ny-1)+0.5)
    yy = y.newdim(0)
    zy = xy*yy    #<<y component>>

    ydivz = sp.ydiv(zy)
    ans = 0

    assert_equal(ydivz, ans)
  end
  
  def test_grad 
    #
  end
  
  def test_xgrad 
    #
  end

  def test_ygrad 
    #
  end

  def test_rot 
    #
  end

  def test_lapla 
    #
  end
  
  def test_ilapla 
    #
  end

  def test_jacobian 
    #
  end
  
  def test_ydiv_m0 
    #
  end
  
  def test_ygrad_m0 
    #
  end

  def test_yderiv_m0 
    #
  end

end
