require 'rubyunit'
require './derivative'

class TestDummyDerivative < RUNIT::TestCase

  include NumRu
  include NMath

  def test_cderiv
    dr = DummyDerivative.new
    #<<pattern 1 : one-dimentional data>>
    nx = 10
    x1 = 2*PI*NArray.sfloat(nx).indgen!/(nx-1)
    z1 = sin(x1)
    c1 = dr.cderiv(z1, x1, 0)
    k1 = cos(x1)
    print "\n1-dimentional data\n"
    p ((c1 - k1).abs.max)
    assert_equal(k1.shape, c1.shape)
   

    #<<pattern 2 : 2-dimentional data>>

      nx = 20; ny = 10
      x2 = 2*PI*(NArray.sfloat(nx).indgen!/(nx-1))      # [0, .., 2PI]
      y2 =   PI*(NArray.sfloat(ny).indgen!/(ny-1)-0.5)  # [-PI/2,..,PI/2]
      z2 = (sin(x2).newdim(1))*(cos(y2).newdim(0))
     dzx = dr.cderiv(z2, x2, 0)
     dzy = dr.cderiv(z2, y2, 1)

     dzx2 = (cos(x2).newdim(1))*(cos(y2).newdim(0))
     dzy2 = -(sin(x2).newdim(1))*(sin(y2).newdim(0))

      print "\n2-dimentional data\n"
      p ((dzx - dzx2).abs.max)
      p ((dzy - dzy2).abs.max)


    #<<pattern 3 : 3-dimentional data>>
      ny = 70; nz = 10; nx=144
      x3 = 2*PI*(NArray.sfloat(nx).indgen!/(nx-1))      # [0, .., 2PI]
      y3 =   PI*(NArray.sfloat(ny).indgen!/(ny-1)-0.5)  # [-PI/2,..,PI/2]
      z3 =      (NArray.sfloat(nz).indgen!)             # [0, 1, .., 10]
      d3 = (sin(x3).newdim(-1).newdim(-1))*(cos(y3).newdim(0).newdim(-1)*z3.newdim(0).newdim(0))
      dzx = dr.cderiv(d3, x3, 0)
      dzy = dr.cderiv(d3, y3, 1)
      dzz = dr.cderiv(d3, z3, 2)
      dzx2 =  (cos(x3).newdim(-1).newdim(-1))*(cos(y3).newdim(0).newdim(-1)*z3.newdim(0).newdim(0))
      dzy2 = -(sin(x3).newdim(-1).newdim(-1))*(sin(y3).newdim(0).newdim(-1)*z3.newdim(0).newdim(0))
      dzz2 =  (sin(x3).newdim(-1).newdim(-1))*(cos(y3).newdim(0).newdim(-1)*(z3.fill!(1)).newdim(0).newdim(0))

      print "\n3-dimentional data\n"
      p ((dzx - dzx2).abs.max)
      p ((dzy - dzy2).abs.max)
      p ((dzz - dzz2).abs.max)

  end


  def test_b_expand_linear_ext
    dr = DummyDerivative.new
    nx = 10
    x1 = 2*PI*NArray.sfloat(nx).indgen!/(nx-1)
    z1 = sin(x1)
    cz1 = dr.b_expand_linear_ext(z1, 0)
    cx1 = dr.b_expand_linear_ext(x1, 0)
    assert_equal(cz1.shape, cx1.shape)
    assert_equal(cz1.shape, [12])
  end

  def test_cdiff
    dr = DummyDerivative.new
    nx = 10
    z1 = sin(2*PI*NArray.sfloat(nx).indgen!/(nx-1))
    x1 = NArray.sfloat(nx).indgen!
    cz1 = dr.b_expand_linear_ext(z1, 0)
    cx1 = dr.b_expand_linear_ext(x1, 0)
    dc = dr.cdiff(cx1,0)
  end

end

