require 'mkmf'
require 'ftools'

libs = %w(Common Filtering Graphics IO Imaging Rendering Patented Parallel Hybrid Misc)

ruby = File.join(Config::CONFIG['bindir'], Config::CONFIG['RUBY_INSTALL_NAME'])
ruby = arg_config("--ruby", ruby)
srcdir = File.dirname(__FILE__)


targets = Array.new
ignore = Array.new
inc_path, lib_path = dir_config("vtk","/usr/local/include/vtk","/usr/local/lib/vtk")
unless have_header("vtkConfigure.h")
  puts "header file for vtk is not found\n"
  puts "please retry with --with-vtk-inlucde=path\n"
  exit 1
end
libs.each{|lib|
  next if lib=="Misc"
  if have_library("vtk#{lib}") || have_library("VTK#{lib}")
    targets << lib
  else
    puts "cannot found #{lib}\n"
    ignore << lib
  end
}


if targets.length > 0
  targets<<"Misc"
  puts "Target libraries: #{targets.join(', ')}"
else
  puts "No vtk libraries are found\n"
  puts "please retry with --with-vtk-lib=path\n"
  exit 1
end
puts "Ignored libraries: #{ignore.join(', ')}" if ignore.length >0

File.open("vtk.rb","w"){|file|
  targets.each{|lib|
    file.print "require 'vtk/#{lib}'\n"
  }
}
argv = ARGV.collect{|arg|
  i = arg.index("=")
  arg[0...i] + '="'+arg[i+1..-1]+'"'
}

File.open("Makefile","w"){|makefile|
  drive = File::PATH_SEPARATOR == ';' ? /\A\w:/ : /\A/
  print "creating Makefile\n"
  makefile.print <<"EOF"
prefix = #{with_destdir Config::CONFIG['prefix'].sub(drive, '')}
sitedir = #{with_destdir $sitedir.sub(drive, '')}
sitelibdir = #{with_destdir $sitelibdir.sub(drive, '')}
ruby_version = #{Config::CONFIG['ruby_version']}

SUBDIRS = #{targets.join(' ')}
VTK_INC_PATH = #{inc_path}
VTK_LIB_PATH = #{lib_path}
RUBY = #{ruby}
RUBYLIBDIR = $(sitelibdir)
INSTALL_DATA = $(RUBY) -run -e install -- -vpm 0644
MAKE = make
RM = rm -f

all:
	@for dir in $(SUBDIRS) ; \\
	 do \\
	   ( cd $$dir; \\
	     $(MAKE) all) \\
	 done

srcs:
	@for dir in $(SUBDIRS) ; \\
	 do \\
	   ( cd $$dir; \\
	     $(MAKE) srcs) \\
	 done

install:
	@for dir in $(SUBDIRS) ; \\
	 do \\
	   ( cd $$dir; $(MAKE) install ) \\
	 done
	$(INSTALL_DATA) vtk.rb $(RUBYLIBDIR)

clean:
	@for dir in $(SUBDIRS) ; \\
	 do \\
	   ( cd $$dir; $(MAKE) clean) \\
	 done

distclean:
	@for dir in $(SUBDIRS) ; \\
	 do \\
	   ( cd $$dir; $(MAKE) distclean; $(RM) Makefile Makefile.org mkmf.log swig.log) \\
	 done
	$(RM) Makefile mkmf.log
EOF
}

targets.each{|lib|
  print "entering #{lib}\n"
  system("(cd #{lib}; #{ruby} extconf.rb #{argv.join(' ')})")
  print "leaving #{lib}\n"
}
