%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkCommon_typemaps.i


%{
#include "vtkUniformGrid.h"
#include "vtkDataArray.h"
#include "vtkEmptyCell.h"
#include "vtkImageData.h"
#include "vtkLine.h"
#include "vtkPixel.h"
#include "vtkVertex.h"
#include "vtkVoxel.h"
#include "vtkStructuredVisibilityConstraint.h"
#include "vtkUnsignedCharArray.h"
%}

%import vtkDataSet.h
%import vtkStructuredData.h


%{
extern void vtkUniformGrid_freefunc(void *ptr)
{
    vtkUniformGrid *obj;
    obj = (vtkUniformGrid*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetExtent()
}
%ignore GetExtent(int data[6]);
%ignore GetExtent(int _arg[6]);
%ignore GetExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetSpacing()
}
%ignore GetSpacing(double data[3]);
%ignore GetSpacing(double _arg[3]);
%ignore GetSpacing(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetOrigin()
}
%ignore GetOrigin(double data[3]);
%ignore GetOrigin(double _arg[3]);
%ignore GetOrigin(double &_arg1,double &_arg2,double &_arg3);

%include vtkUniformGrid.h
