/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkDataSetToStructuredGridFilter.h,v $
  Language:  C++
  Date:      $Date: 2005/03/11 02:32:15 $
  Version:   $Revision: 1.1 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkDataSetToStructuredGridFilter - abstract filter class
// .SECTION Description
// vtkDataSetToStructuredGridFilter is an abstract filter class whose 
// subclasses take as input any dataset and generate a structured
// grid on output.

#ifndef __vtkDataSetToStructuredGridFilter_h
#define __vtkDataSetToStructuredGridFilter_h

#include "vtkStructuredGridSource.h"

class vtkDataSet;

class VTK_FILTERING_EXPORT vtkDataSetToStructuredGridFilter : public vtkStructuredGridSource
{
public:
  vtkTypeRevisionMacro(vtkDataSetToStructuredGridFilter,vtkStructuredGridSource);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Set / get the input data or filter.
  virtual void SetInput(vtkDataSet *input);
  vtkDataSet *GetInput();

protected:
  vtkDataSetToStructuredGridFilter() {};
  ~vtkDataSetToStructuredGridFilter() {};
  
private:
  vtkDataSetToStructuredGridFilter(const vtkDataSetToStructuredGridFilter&);  // Not implemented.
  void operator=(const vtkDataSetToStructuredGridFilter&);  // Not implemented.
};

#endif


