%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkRendering_typemaps.i


%{
#include "vtkCamera.h"
#include "vtkRenderer.h"
%}

%import vtkObject.h


%{
extern void vtkCamera_freefunc(void *ptr)
{
    vtkCamera *obj;
    obj = (vtkCamera*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetPosition()
}
%ignore GetPosition(double data[3]);
%ignore GetPosition(double _arg[3]);
%ignore GetPosition(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetFocalPoint()
}
%ignore GetFocalPoint(double data[3]);
%ignore GetFocalPoint(double _arg[3]);
%ignore GetFocalPoint(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetViewUp()
}
%ignore GetViewUp(double data[3]);
%ignore GetViewUp(double _arg[3]);
%ignore GetViewUp(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetDirectionOfProjection()
}
%ignore GetDirectionOfProjection(double data[3]);
%ignore GetDirectionOfProjection(double _arg[3]);
%ignore GetDirectionOfProjection(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetClippingRange()
}
%ignore GetClippingRange(double data[2]);
%ignore GetClippingRange(double _arg[2]);
%ignore GetClippingRange(double &_arg1,double &_arg2);

%typemap(ruby,out) double value[2] {
  int i;
  $result = rb_ary_new2(2);
  for (i=0; i<2; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[2]{
   double *GetWindowCenter()
}
%ignore GetWindowCenter(double data[2]);
%ignore GetWindowCenter(double _arg[2]);
%ignore GetWindowCenter(double &_arg1,double &_arg2);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetViewPlaneNormal()
}
%ignore GetViewPlaneNormal(double data[3]);
%ignore GetViewPlaneNormal(double _arg[3]);
%ignore GetViewPlaneNormal(double &_arg1,double &_arg2,double &_arg3);

%typemap(ruby,out) double value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new($1[i]));
}
%apply double value[3]{
   double *GetViewShear()
}
%ignore GetViewShear(double data[3]);
%ignore GetViewShear(double _arg[3]);
%ignore GetViewShear(double &_arg1,double &_arg2,double &_arg3);

%include vtkCamera.h
