%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkImaging_typemaps.i


%{
#include "vtkImageChangeInformation.h"
%}

%import vtkImageToImageFilter.h


%{
extern void vtkImageChangeInformation_freefunc(void *ptr)
{
    vtkImageChangeInformation *obj;
    obj = (vtkImageChangeInformation*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetOutputExtentStart()
}
%ignore GetOutputExtentStart(int data[3]);
%ignore GetOutputExtentStart(int _arg[3]);
%ignore GetOutputExtentStart(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOutputSpacing()
}
%ignore GetOutputSpacing(float data[3]);
%ignore GetOutputSpacing(float _arg[3]);
%ignore GetOutputSpacing(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOutputOrigin()
}
%ignore GetOutputOrigin(float data[3]);
%ignore GetOutputOrigin(float _arg[3]);
%ignore GetOutputOrigin(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetExtentTranslation()
}
%ignore GetExtentTranslation(int data[3]);
%ignore GetExtentTranslation(int _arg[3]);
%ignore GetExtentTranslation(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetSpacingScale()
}
%ignore GetSpacingScale(float data[3]);
%ignore GetSpacingScale(float _arg[3]);
%ignore GetSpacingScale(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOriginTranslation()
}
%ignore GetOriginTranslation(float data[3]);
%ignore GetOriginTranslation(float _arg[3]);
%ignore GetOriginTranslation(float &_arg1,float &_arg2,float &_arg3);

%typemap(ruby,out) float value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,rb_float_new((double)$1[i]));
}
%apply float value[3]{
   float *GetOriginScale()
}
%ignore GetOriginScale(float data[3]);
%ignore GetOriginScale(float _arg[3]);
%ignore GetOriginScale(float &_arg1,float &_arg2,float &_arg3);

%include vtkImageChangeInformation.h
