%module vtk
%include typemaps.i
%include vtk_typemaps.i
%include vtkCommon_typemaps.i


%{
#include "vtkRectilinearGrid.h"
#include "vtkVertex.h"
#include "vtkLine.h"
#include "vtkPixel.h"
#include "vtkVoxel.h"
#include "vtkDataArray.h"
%}

%import vtkDataSet.h
%import vtkStructuredData.h


%{
extern void vtkRectilinearGrid_freefunc(void *ptr)
{
    vtkRectilinearGrid *obj;
    obj = (vtkRectilinearGrid*)ptr;
    obj->Delete();
}
%}

%typemap(ruby,out) int value[3] {
  int i;
  $result = rb_ary_new2(3);
  for (i=0; i<3; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[3]{
   int *GetDimensions()
}
%ignore GetDimensions(int data[3]);
%ignore GetDimensions(int _arg[3]);
%ignore GetDimensions(int &_arg1,int &_arg2,int &_arg3);

%typemap(ruby,out) int value[6] {
  int i;
  $result = rb_ary_new2(6);
  for (i=0; i<6; i++)
    rb_ary_store($result,i,INT2NUM($1[i]));
}
%apply int value[6]{
   int *GetExtent()
}
%ignore GetExtent(int data[6]);
%ignore GetExtent(int _arg[6]);
%ignore GetExtent(int &_arg1,int &_arg2,int &_arg3,int &_arg4,int &_arg5,int &_arg6);

%include vtkRectilinearGrid.h
