# $Id: extconf.rb,v 1.1 2000/11/28 04:50:39 keiko Exp $
# $Id: extconf.rb,v 1.2 2001/08/27 16:32:39 kawanabe Exp $

require "mkmf"
require "ftools"

dir_config('narray',$sitearchdir,$sitearchdir)
if ( ! ( have_header("narray.h") && have_header("narray_config.h") ) ) then
   print <<-EOS
   ** configure error **  
   Header narray.h or narray_config.h is not found. If you have these files in 
   /narraydir/include, try the following:

   % ruby extconf.rb --with-narray-include=/narraydir/include

   EOS
   exit(-1)
end

if(xsystem("which cdclconfig"))
  cflags = `cdclconfig --cflags`.gsub(/\n/, " ")
  ldflags = `cdclconfig --ldflags`.gsub(/\n/, " ")
  ldlibs = `cdclconfig --ldlibs`.gsub(/-R.*?\s/, " ").gsub(/\n/, " ")
 
  $CFLAGS += ' '+cflags  
  $LOCAL_LIBS += ' ' + ldflags
  $LOCAL_LIBS += ldlibs

  ldlibs = `cdclconfig --ldlibs`
  if ldlibs =~ /-lgtk/ then
    print "**Infomation** compile with gtk+\n"
    File.copy("grph1_zgpack.c.org","grph1_zgpack.c")
    File.safe_unlink("init.c")
    File.copy("init.c.gtk","init.c")
    if ldlibs =~ /-lgdk_imlib/ then
      print "**Infomation** compile with imlib_gdk\n"
    end    
  else
    File.copy("init.c.default","init.c")
  end

else
  print "**Warning** cdclconfig is not found. Assume C version of DCL 5.2\n"
  dcllibname = "cdcl52"
  f2clibname = "f2c4dcl"
  xlibname = "X11"
  dcllibdir = "-L/usr/local/lib"
  f2clibdir = "-L/usr/local/lib"
  xlibdir = "-L/usr/local/X11R6/lib"
  f2cincdir = "-I/usr/local/include"
  $CFLAGS += f2cincdir
  if(dcllibdir != f2clibdir)
    libdir = " "+dcllibdir
  else
    libdir = " "+dcllibdir+" "+f2clibdir
  end
  $LOCAL_LIBS += " "+libdir+" "+xlibdir
  $LOCAL_LIBS += " -l"+dcllibname+" -l"+f2clibname+" -l"+xlibname+" -lsocket -lnsl"
end

if /cygwin|mingw/ =~ RUBY_PLATFORM
   have_library("narray") || raise("ERROR: narray library is not found")
end

create_makefile("numru/dcl_raw")

######  Modify Makefile: #######
File.rename("Makefile","Makefile.orig")
oldmkfl = File.open("Makefile.orig")
newmkfl = File.open("Makefile","w")
oldmkfl.each_line{ |line|
   case(line)
   when /^distclean:/
      newmkfl.puts(line)
      newmkfl.puts("\t\t@$(RM) Makefile.orig")
      newmkfl.puts("\t\t@$(RM) init.c grph1_zgpack.c")
   else
      newmkfl.puts(line)
   end
}
newmkfl.close
