/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


VALUE mDCL;

static VALUE
dcl_sgopn(obj, iws)
    VALUE obj, iws;
{
    integer i_iws;

    if ((TYPE(iws) != T_BIGNUM) || (TYPE(iws) != T_FIXNUM)) {
      iws = rb_funcall(iws, rb_intern("to_i"), 0);
    }

    i_iws = NUM2INT(iws);


    sgopn_(&i_iws);

    return Qnil;

}

static VALUE
dcl_sgfrm(obj)
    VALUE obj;
{
    sgfrm_();

    return Qnil;

}

static VALUE
dcl_sgcls(obj)
    VALUE obj;
{
    sgcls_();

    return Qnil;

}

static VALUE
dcl_sgpqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    sgpqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_sgpqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgpqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_sgpqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sgpqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sgpqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sgpqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sgpqit(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    integer o_itp;
    VALUE itp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    sgpqit_(&i_idx, &o_itp);

    itp = INT2NUM(o_itp);


    return itp;

}

static VALUE
dcl_sgpqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    integer o_ipara;
    VALUE ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    sgpqvl_(&i_idx, &o_ipara);

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_sgpsvl(obj, idx, ipara)
    VALUE obj, idx, ipara;
{
    integer i_idx;
    integer i_ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_ipara = NUM2INT(ipara);


    sgpsvl_(&i_idx, &i_ipara);

    return Qnil;

}

static VALUE
dcl_sgpqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgpqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_sgpwsn(obj)
    VALUE obj;
{
    sgpwsn_();

    return Qnil;

}

static VALUE
dcl_sgsvpt(obj, vxmin, vxmax, vymin, vymax)
    VALUE obj, vxmin, vxmax, vymin, vymax;
{
    real i_vxmin;
    real i_vxmax;
    real i_vymin;
    real i_vymax;

    if (TYPE(vxmin) != T_FLOAT) {
      vxmin = rb_funcall(vxmin, rb_intern("to_f"), 0);
    }
    if (TYPE(vxmax) != T_FLOAT) {
      vxmax = rb_funcall(vxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(vymin) != T_FLOAT) {
      vymin = rb_funcall(vymin, rb_intern("to_f"), 0);
    }
    if (TYPE(vymax) != T_FLOAT) {
      vymax = rb_funcall(vymax, rb_intern("to_f"), 0);
    }

    i_vxmin = (real)NUM2DBL(vxmin);
    i_vxmax = (real)NUM2DBL(vxmax);
    i_vymin = (real)NUM2DBL(vymin);
    i_vymax = (real)NUM2DBL(vymax);


    sgsvpt_(&i_vxmin, &i_vxmax, &i_vymin, &i_vymax);

    return Qnil;

}

static VALUE
dcl_sgqvpt(obj)
    VALUE obj;
{
    real o_vxmin;
    real o_vxmax;
    real o_vymin;
    real o_vymax;
    VALUE vxmin;
    VALUE vxmax;
    VALUE vymin;
    VALUE vymax;

    sgqvpt_(&o_vxmin, &o_vxmax, &o_vymin, &o_vymax);

    vxmin = rb_float_new((double)o_vxmin);
    vxmax = rb_float_new((double)o_vxmax);
    vymin = rb_float_new((double)o_vymin);
    vymax = rb_float_new((double)o_vymax);


    return rb_ary_new3(4, vxmin, vxmax, vymin, vymax);

}

static VALUE
dcl_sgswnd(obj, uxmin, uxmax, uymin, uymax)
    VALUE obj, uxmin, uxmax, uymin, uymax;
{
    real i_uxmin;
    real i_uxmax;
    real i_uymin;
    real i_uymax;

    if (TYPE(uxmin) != T_FLOAT) {
      uxmin = rb_funcall(uxmin, rb_intern("to_f"), 0);
    }
    if (TYPE(uxmax) != T_FLOAT) {
      uxmax = rb_funcall(uxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(uymin) != T_FLOAT) {
      uymin = rb_funcall(uymin, rb_intern("to_f"), 0);
    }
    if (TYPE(uymax) != T_FLOAT) {
      uymax = rb_funcall(uymax, rb_intern("to_f"), 0);
    }

    i_uxmin = (real)NUM2DBL(uxmin);
    i_uxmax = (real)NUM2DBL(uxmax);
    i_uymin = (real)NUM2DBL(uymin);
    i_uymax = (real)NUM2DBL(uymax);


    sgswnd_(&i_uxmin, &i_uxmax, &i_uymin, &i_uymax);

    return Qnil;

}

static VALUE
dcl_sgqwnd(obj)
    VALUE obj;
{
    real o_uxmin;
    real o_uxmax;
    real o_uymin;
    real o_uymax;
    VALUE uxmin;
    VALUE uxmax;
    VALUE uymin;
    VALUE uymax;

    sgqwnd_(&o_uxmin, &o_uxmax, &o_uymin, &o_uymax);

    uxmin = rb_float_new((double)o_uxmin);
    uxmax = rb_float_new((double)o_uxmax);
    uymin = rb_float_new((double)o_uymin);
    uymax = rb_float_new((double)o_uymax);


    return rb_ary_new3(4, uxmin, uxmax, uymin, uymax);

}

static VALUE
dcl_sgssim(obj, simfac, vxoff, vyoff)
    VALUE obj, simfac, vxoff, vyoff;
{
    real i_simfac;
    real i_vxoff;
    real i_vyoff;

    if (TYPE(simfac) != T_FLOAT) {
      simfac = rb_funcall(simfac, rb_intern("to_f"), 0);
    }
    if (TYPE(vxoff) != T_FLOAT) {
      vxoff = rb_funcall(vxoff, rb_intern("to_f"), 0);
    }
    if (TYPE(vyoff) != T_FLOAT) {
      vyoff = rb_funcall(vyoff, rb_intern("to_f"), 0);
    }

    i_simfac = (real)NUM2DBL(simfac);
    i_vxoff = (real)NUM2DBL(vxoff);
    i_vyoff = (real)NUM2DBL(vyoff);


    sgssim_(&i_simfac, &i_vxoff, &i_vyoff);

    return Qnil;

}

static VALUE
dcl_sgqsim(obj)
    VALUE obj;
{
    real o_simfac;
    real o_vxoff;
    real o_vyoff;
    VALUE simfac;
    VALUE vxoff;
    VALUE vyoff;

    sgqsim_(&o_simfac, &o_vxoff, &o_vyoff);

    simfac = rb_float_new((double)o_simfac);
    vxoff = rb_float_new((double)o_vxoff);
    vyoff = rb_float_new((double)o_vyoff);


    return rb_ary_new3(3, simfac, vxoff, vyoff);

}

static VALUE
dcl_sgsmpl(obj, plx, ply, plrot)
    VALUE obj, plx, ply, plrot;
{
    real i_plx;
    real i_ply;
    real i_plrot;

    if (TYPE(plx) != T_FLOAT) {
      plx = rb_funcall(plx, rb_intern("to_f"), 0);
    }
    if (TYPE(ply) != T_FLOAT) {
      ply = rb_funcall(ply, rb_intern("to_f"), 0);
    }
    if (TYPE(plrot) != T_FLOAT) {
      plrot = rb_funcall(plrot, rb_intern("to_f"), 0);
    }

    i_plx = (real)NUM2DBL(plx);
    i_ply = (real)NUM2DBL(ply);
    i_plrot = (real)NUM2DBL(plrot);


    sgsmpl_(&i_plx, &i_ply, &i_plrot);

    return Qnil;

}

static VALUE
dcl_sgqmpl(obj)
    VALUE obj;
{
    real o_plx;
    real o_ply;
    real o_plrot;
    VALUE plx;
    VALUE ply;
    VALUE plrot;

    sgqmpl_(&o_plx, &o_ply, &o_plrot);

    plx = rb_float_new((double)o_plx);
    ply = rb_float_new((double)o_ply);
    plrot = rb_float_new((double)o_plrot);


    return rb_ary_new3(3, plx, ply, plrot);

}

static VALUE
dcl_sgstxy(obj, txmin, txmax, tymin, tymax)
    VALUE obj, txmin, txmax, tymin, tymax;
{
    real i_txmin;
    real i_txmax;
    real i_tymin;
    real i_tymax;

    if (TYPE(txmin) != T_FLOAT) {
      txmin = rb_funcall(txmin, rb_intern("to_f"), 0);
    }
    if (TYPE(txmax) != T_FLOAT) {
      txmax = rb_funcall(txmax, rb_intern("to_f"), 0);
    }
    if (TYPE(tymin) != T_FLOAT) {
      tymin = rb_funcall(tymin, rb_intern("to_f"), 0);
    }
    if (TYPE(tymax) != T_FLOAT) {
      tymax = rb_funcall(tymax, rb_intern("to_f"), 0);
    }

    i_txmin = (real)NUM2DBL(txmin);
    i_txmax = (real)NUM2DBL(txmax);
    i_tymin = (real)NUM2DBL(tymin);
    i_tymax = (real)NUM2DBL(tymax);


    sgstxy_(&i_txmin, &i_txmax, &i_tymin, &i_tymax);

    return Qnil;

}

static VALUE
dcl_sgqtxy(obj)
    VALUE obj;
{
    real o_txmin;
    real o_txmax;
    real o_tymin;
    real o_tymax;
    VALUE txmin;
    VALUE txmax;
    VALUE tymin;
    VALUE tymax;

    sgqtxy_(&o_txmin, &o_txmax, &o_tymin, &o_tymax);

    txmin = rb_float_new((double)o_txmin);
    txmax = rb_float_new((double)o_txmax);
    tymin = rb_float_new((double)o_tymin);
    tymax = rb_float_new((double)o_tymax);


    return rb_ary_new3(4, txmin, txmax, tymin, tymax);

}

static VALUE
dcl_sgstrn(obj, itr)
    VALUE obj, itr;
{
    integer i_itr;

    if ((TYPE(itr) != T_BIGNUM) || (TYPE(itr) != T_FIXNUM)) {
      itr = rb_funcall(itr, rb_intern("to_i"), 0);
    }

    i_itr = NUM2INT(itr);


    sgstrn_(&i_itr);

    return Qnil;

}

static VALUE
dcl_sgqtrn(obj)
    VALUE obj;
{
    integer o_itr;
    VALUE itr;

    sgqtrn_(&o_itr);

    itr = INT2NUM(o_itr);


    return itr;

}

static VALUE
dcl_sgstrf(obj)
    VALUE obj;
{
    sgstrf_();

    return Qnil;

}

static VALUE
dcl_sgtrqf(obj, ntx)
    VALUE obj, ntx;
{
    integer i_ntx;
    logical o_ltr;
    VALUE ltr;

    if ((TYPE(ntx) != T_BIGNUM) || (TYPE(ntx) != T_FIXNUM)) {
      ntx = rb_funcall(ntx, rb_intern("to_i"), 0);
    }

    i_ntx = NUM2INT(ntx);


    sgtrqf_(&i_ntx, &o_ltr);

    ltr = (o_ltr == FALSE_) ? Qfalse : Qtrue;


    return ltr;

}

static VALUE
dcl_sgtrsl(obj, cts)
    VALUE obj, cts;
{
    char *i_cts;
    char *o_ctl;
    VALUE ctl;

    if (TYPE(cts) != T_STRING) {
      cts = rb_funcall(cts, rb_intern("to_str"), 0);
    }

    i_cts = STR2CSTR(cts);

    o_ctl= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_ctl, '\0', DFLT_SIZE+1);

    sgtrsl_(i_cts, o_ctl, (ftnlen)strlen(i_cts), (ftnlen)DFLT_SIZE);

    ctl = rb_str_new2(o_ctl);


    return ctl;

}

static VALUE
dcl_sgtrsn(obj, cts)
    VALUE obj, cts;
{
    char *i_cts;
    integer o_ntx;
    VALUE ntx;

    if (TYPE(cts) != T_STRING) {
      cts = rb_funcall(cts, rb_intern("to_str"), 0);
    }

    i_cts = STR2CSTR(cts);


    sgtrsn_(i_cts, &o_ntx, (ftnlen)strlen(i_cts));

    ntx = INT2NUM(o_ntx);


    return ntx;

}

static VALUE
dcl_sgtrls(obj, ctl)
    VALUE obj, ctl;
{
    char *i_ctl;
    char *o_cts;
    VALUE cts;

    if (TYPE(ctl) != T_STRING) {
      ctl = rb_funcall(ctl, rb_intern("to_str"), 0);
    }

    i_ctl = STR2CSTR(ctl);

    o_cts= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cts, '\0', DFLT_SIZE+1);

    sgtrls_(i_ctl, o_cts, (ftnlen)strlen(i_ctl), (ftnlen)DFLT_SIZE);

    cts = rb_str_new2(o_cts);


    return cts;

}

static VALUE
dcl_sgtrln(obj, ctl)
    VALUE obj, ctl;
{
    char *i_ctl;
    integer o_ntx;
    VALUE ntx;

    if (TYPE(ctl) != T_STRING) {
      ctl = rb_funcall(ctl, rb_intern("to_str"), 0);
    }

    i_ctl = STR2CSTR(ctl);


    sgtrln_(i_ctl, &o_ntx, (ftnlen)strlen(i_ctl));

    ntx = INT2NUM(o_ntx);


    return ntx;

}

static VALUE
dcl_sgtrns(obj, ntx)
    VALUE obj, ntx;
{
    integer i_ntx;
    char *o_cts;
    VALUE cts;

    if ((TYPE(ntx) != T_BIGNUM) || (TYPE(ntx) != T_FIXNUM)) {
      ntx = rb_funcall(ntx, rb_intern("to_i"), 0);
    }

    i_ntx = NUM2INT(ntx);

    o_cts= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cts, '\0', DFLT_SIZE+1);

    sgtrns_(&i_ntx, o_cts, (ftnlen)DFLT_SIZE);

    cts = rb_str_new2(o_cts);


    return cts;

}

static VALUE
dcl_sgtrnl(obj, ntx)
    VALUE obj, ntx;
{
    integer i_ntx;
    char *o_ctl;
    VALUE ctl;

    if ((TYPE(ntx) != T_BIGNUM) || (TYPE(ntx) != T_FIXNUM)) {
      ntx = rb_funcall(ntx, rb_intern("to_i"), 0);
    }

    i_ntx = NUM2INT(ntx);

    o_ctl= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_ctl, '\0', DFLT_SIZE+1);

    sgtrnl_(&i_ntx, o_ctl, (ftnlen)DFLT_SIZE);

    ctl = rb_str_new2(o_ctl);


    return ctl;

}

static VALUE
dcl_isgtrc(obj, ctr)
    VALUE obj, ctr;
{
    char *i_ctr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(ctr) != T_STRING) {
      ctr = rb_funcall(ctr, rb_intern("to_str"), 0);
    }

    i_ctr = STR2CSTR(ctr);


    o_rtn_val = isgtrc_(i_ctr, (ftnlen)strlen(i_ctr));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_sgplu(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    sgplu_(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_sgplv(obj, n, vpx, vpy)
    VALUE obj, n, vpx, vpy;
{
    integer i_n;
    real *i_vpx;
    real *i_vpy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(vpx) == T_FLOAT) {
      vpx = rb_Array(vpx);
    }
    /* if ((TYPE(vpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(vpy) == T_FLOAT) {
      vpy = rb_Array(vpy);
    }
    /* if ((TYPE(vpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_vpx = dcl_obj2crealary(vpx);
    i_vpy = dcl_obj2crealary(vpy);


    sgplv_(&i_n, i_vpx, i_vpy);

    dcl_freecrealary(i_vpx);
    dcl_freecrealary(i_vpy);

    return Qnil;

}

static VALUE
dcl_sgplr(obj, n, rpx, rpy)
    VALUE obj, n, rpx, rpy;
{
    integer i_n;
    real *i_rpx;
    real *i_rpy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rpx) == T_FLOAT) {
      rpx = rb_Array(rpx);
    }
    /* if ((TYPE(rpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(rpy) == T_FLOAT) {
      rpy = rb_Array(rpy);
    }
    /* if ((TYPE(rpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_rpx = dcl_obj2crealary(rpx);
    i_rpy = dcl_obj2crealary(rpy);


    sgplr_(&i_n, i_rpx, i_rpy);

    dcl_freecrealary(i_rpx);
    dcl_freecrealary(i_rpy);

    return Qnil;

}

static VALUE
dcl_sgsplt(obj, itype)
    VALUE obj, itype;
{
    integer i_itype;

    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }

    i_itype = NUM2INT(itype);


    sgsplt_(&i_itype);

    return Qnil;

}

static VALUE
dcl_sgqplt(obj)
    VALUE obj;
{
    integer o_itype;
    VALUE itype;

    sgqplt_(&o_itype);

    itype = INT2NUM(o_itype);


    return itype;

}

static VALUE
dcl_sgspli(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    sgspli_(&i_index);

    return Qnil;

}

static VALUE
dcl_sgqpli(obj)
    VALUE obj;
{
    integer o_index;
    VALUE index;

    sgqpli_(&o_index);

    index = INT2NUM(o_index);


    return index;

}

static VALUE
dcl_sgplzu(obj, n, upx, upy, itype, index)
    VALUE obj, n, upx, upy, itype, index;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    sgplzu_(&i_n, i_upx, i_upy, &i_itype, &i_index);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_sgplzv(obj, n, vpx, vpy, itype, index)
    VALUE obj, n, vpx, vpy, itype, index;
{
    integer i_n;
    real *i_vpx;
    real *i_vpy;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(vpx) == T_FLOAT) {
      vpx = rb_Array(vpx);
    }
    /* if ((TYPE(vpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(vpy) == T_FLOAT) {
      vpy = rb_Array(vpy);
    }
    /* if ((TYPE(vpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_vpx = dcl_obj2crealary(vpx);
    i_vpy = dcl_obj2crealary(vpy);


    sgplzv_(&i_n, i_vpx, i_vpy, &i_itype, &i_index);

    dcl_freecrealary(i_vpx);
    dcl_freecrealary(i_vpy);

    return Qnil;

}

static VALUE
dcl_sgplzr(obj, n, rpx, rpy, itype, index)
    VALUE obj, n, rpx, rpy, itype, index;
{
    integer i_n;
    real *i_rpx;
    real *i_rpy;
    integer i_itype;
    integer i_index;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rpx) == T_FLOAT) {
      rpx = rb_Array(rpx);
    }
    /* if ((TYPE(rpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(rpy) == T_FLOAT) {
      rpy = rb_Array(rpy);
    }
    /* if ((TYPE(rpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rpx = dcl_obj2crealary(rpx);
    i_rpy = dcl_obj2crealary(rpy);


    sgplzr_(&i_n, i_rpx, i_rpy, &i_itype, &i_index);

    dcl_freecrealary(i_rpx);
    dcl_freecrealary(i_rpy);

    return Qnil;

}

static VALUE
dcl_sgpmu(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    sgpmu_(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_sgpmv(obj, n, vpx, vpy)
    VALUE obj, n, vpx, vpy;
{
    integer i_n;
    real *i_vpx;
    real *i_vpy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(vpx) == T_FLOAT) {
      vpx = rb_Array(vpx);
    }
    /* if ((TYPE(vpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(vpy) == T_FLOAT) {
      vpy = rb_Array(vpy);
    }
    /* if ((TYPE(vpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_vpx = dcl_obj2crealary(vpx);
    i_vpy = dcl_obj2crealary(vpy);


    sgpmv_(&i_n, i_vpx, i_vpy);

    dcl_freecrealary(i_vpx);
    dcl_freecrealary(i_vpy);

    return Qnil;

}

static VALUE
dcl_sgpmr(obj, n, rpx, rpy)
    VALUE obj, n, rpx, rpy;
{
    integer i_n;
    real *i_rpx;
    real *i_rpy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rpx) == T_FLOAT) {
      rpx = rb_Array(rpx);
    }
    /* if ((TYPE(rpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(rpy) == T_FLOAT) {
      rpy = rb_Array(rpy);
    }
    /* if ((TYPE(rpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_rpx = dcl_obj2crealary(rpx);
    i_rpy = dcl_obj2crealary(rpy);


    sgpmr_(&i_n, i_rpx, i_rpy);

    dcl_freecrealary(i_rpx);
    dcl_freecrealary(i_rpy);

    return Qnil;

}

static VALUE
dcl_sgspmt(obj, itype)
    VALUE obj, itype;
{
    integer i_itype;

    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }

    i_itype = NUM2INT(itype);


    sgspmt_(&i_itype);

    return Qnil;

}

static VALUE
dcl_sgqpmt(obj)
    VALUE obj;
{
    integer o_itype;
    VALUE itype;

    sgqpmt_(&o_itype);

    itype = INT2NUM(o_itype);


    return itype;

}

static VALUE
dcl_sgspmi(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    sgspmi_(&i_index);

    return Qnil;

}

static VALUE
dcl_sgqpmi(obj)
    VALUE obj;
{
    integer o_index;
    VALUE index;

    sgqpmi_(&o_index);

    index = INT2NUM(o_index);


    return index;

}

static VALUE
dcl_sgspms(obj, rsize)
    VALUE obj, rsize;
{
    real i_rsize;

    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_rsize = (real)NUM2DBL(rsize);


    sgspms_(&i_rsize);

    return Qnil;

}

static VALUE
dcl_sgqpms(obj)
    VALUE obj;
{
    real o_rsize;
    VALUE rsize;

    sgqpms_(&o_rsize);

    rsize = rb_float_new((double)o_rsize);


    return rsize;

}

static VALUE
dcl_sgtxu(obj, ux, uy, chars)
    VALUE obj, ux, uy, chars;
{
    real i_ux;
    real i_uy;
    char *i_chars;

    if (TYPE(ux) != T_FLOAT) {
      ux = rb_funcall(ux, rb_intern("to_f"), 0);
    }
    if (TYPE(uy) != T_FLOAT) {
      uy = rb_funcall(uy, rb_intern("to_f"), 0);
    }
    if (TYPE(chars) != T_STRING) {
      chars = rb_funcall(chars, rb_intern("to_str"), 0);
    }

    i_ux = (real)NUM2DBL(ux);
    i_uy = (real)NUM2DBL(uy);
    i_chars = STR2CSTR(chars);


    sgtxu_(&i_ux, &i_uy, i_chars, (ftnlen)strlen(i_chars));

    return Qnil;

}

static VALUE
dcl_sgtxv(obj, vx, vy, chars)
    VALUE obj, vx, vy, chars;
{
    real i_vx;
    real i_vy;
    char *i_chars;

    if (TYPE(vx) != T_FLOAT) {
      vx = rb_funcall(vx, rb_intern("to_f"), 0);
    }
    if (TYPE(vy) != T_FLOAT) {
      vy = rb_funcall(vy, rb_intern("to_f"), 0);
    }
    if (TYPE(chars) != T_STRING) {
      chars = rb_funcall(chars, rb_intern("to_str"), 0);
    }

    i_vx = (real)NUM2DBL(vx);
    i_vy = (real)NUM2DBL(vy);
    i_chars = STR2CSTR(chars);


    sgtxv_(&i_vx, &i_vy, i_chars, (ftnlen)strlen(i_chars));

    return Qnil;

}

static VALUE
dcl_sgtxr(obj, rx, ry, chars)
    VALUE obj, rx, ry, chars;
{
    real i_rx;
    real i_ry;
    char *i_chars;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }
    if (TYPE(ry) != T_FLOAT) {
      ry = rb_funcall(ry, rb_intern("to_f"), 0);
    }
    if (TYPE(chars) != T_STRING) {
      chars = rb_funcall(chars, rb_intern("to_str"), 0);
    }

    i_rx = (real)NUM2DBL(rx);
    i_ry = (real)NUM2DBL(ry);
    i_chars = STR2CSTR(chars);


    sgtxr_(&i_rx, &i_ry, i_chars, (ftnlen)strlen(i_chars));

    return Qnil;

}

static VALUE
dcl_sgstxs(obj, rsize)
    VALUE obj, rsize;
{
    real i_rsize;

    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_rsize = (real)NUM2DBL(rsize);


    sgstxs_(&i_rsize);

    return Qnil;

}

static VALUE
dcl_sgqtxs(obj)
    VALUE obj;
{
    real o_rsize;
    VALUE rsize;

    sgqtxs_(&o_rsize);

    rsize = rb_float_new((double)o_rsize);


    return rsize;

}

static VALUE
dcl_sgstxr(obj, irota)
    VALUE obj, irota;
{
    integer i_irota;

    if ((TYPE(irota) != T_BIGNUM) || (TYPE(irota) != T_FIXNUM)) {
      irota = rb_funcall(irota, rb_intern("to_i"), 0);
    }

    i_irota = NUM2INT(irota);


    sgstxr_(&i_irota);

    return Qnil;

}

static VALUE
dcl_sgqtxr(obj)
    VALUE obj;
{
    integer o_irota;
    VALUE irota;

    sgqtxr_(&o_irota);

    irota = INT2NUM(o_irota);


    return irota;

}

static VALUE
dcl_sgstxc(obj, icent)
    VALUE obj, icent;
{
    integer i_icent;

    if ((TYPE(icent) != T_BIGNUM) || (TYPE(icent) != T_FIXNUM)) {
      icent = rb_funcall(icent, rb_intern("to_i"), 0);
    }

    i_icent = NUM2INT(icent);


    sgstxc_(&i_icent);

    return Qnil;

}

static VALUE
dcl_sgqtxc(obj)
    VALUE obj;
{
    integer o_icent;
    VALUE icent;

    sgqtxc_(&o_icent);

    icent = INT2NUM(o_icent);


    return icent;

}

static VALUE
dcl_sgstxi(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    sgstxi_(&i_index);

    return Qnil;

}

static VALUE
dcl_sgqtxi(obj)
    VALUE obj;
{
    integer o_index;
    VALUE index;

    sgqtxi_(&o_index);

    index = INT2NUM(o_index);


    return index;

}

static VALUE
dcl_sgpmzu(obj, n, upx, upy, itype, index, rsize)
    VALUE obj, n, upx, upy, itype, index, rsize;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    sgpmzu_(&i_n, i_upx, i_upy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_sgpmzv(obj, n, vpx, vpy, itype, index, rsize)
    VALUE obj, n, vpx, vpy, itype, index, rsize;
{
    integer i_n;
    real *i_vpx;
    real *i_vpy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(vpx) == T_FLOAT) {
      vpx = rb_Array(vpx);
    }
    /* if ((TYPE(vpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(vpy) == T_FLOAT) {
      vpy = rb_Array(vpy);
    }
    /* if ((TYPE(vpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_vpx = dcl_obj2crealary(vpx);
    i_vpy = dcl_obj2crealary(vpy);


    sgpmzv_(&i_n, i_vpx, i_vpy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_vpx);
    dcl_freecrealary(i_vpy);

    return Qnil;

}

static VALUE
dcl_sgpmzr(obj, n, rpx, rpy, itype, index, rsize)
    VALUE obj, n, rpx, rpy, itype, index, rsize;
{
    integer i_n;
    real *i_rpx;
    real *i_rpy;
    integer i_itype;
    integer i_index;
    real i_rsize;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rpx) == T_FLOAT) {
      rpx = rb_Array(rpx);
    }
    /* if ((TYPE(rpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(rpy) == T_FLOAT) {
      rpy = rb_Array(rpy);
    }
    /* if ((TYPE(rpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);
    i_rsize = (real)NUM2DBL(rsize);
    i_rpx = dcl_obj2crealary(rpx);
    i_rpy = dcl_obj2crealary(rpy);


    sgpmzr_(&i_n, i_rpx, i_rpy, &i_itype, &i_index, &i_rsize);

    dcl_freecrealary(i_rpx);
    dcl_freecrealary(i_rpy);

    return Qnil;

}

static VALUE
dcl_sgtxzu(obj, ux, uy, chars, rsize, irota, icent, index)
    VALUE obj, ux, uy, chars, rsize, irota, icent, index;
{
    real i_ux;
    real i_uy;
    char *i_chars;
    real i_rsize;
    integer i_irota;
    integer i_icent;
    integer i_index;

    if (TYPE(ux) != T_FLOAT) {
      ux = rb_funcall(ux, rb_intern("to_f"), 0);
    }
    if (TYPE(uy) != T_FLOAT) {
      uy = rb_funcall(uy, rb_intern("to_f"), 0);
    }
    if (TYPE(chars) != T_STRING) {
      chars = rb_funcall(chars, rb_intern("to_str"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }
    if ((TYPE(irota) != T_BIGNUM) || (TYPE(irota) != T_FIXNUM)) {
      irota = rb_funcall(irota, rb_intern("to_i"), 0);
    }
    if ((TYPE(icent) != T_BIGNUM) || (TYPE(icent) != T_FIXNUM)) {
      icent = rb_funcall(icent, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_ux = (real)NUM2DBL(ux);
    i_uy = (real)NUM2DBL(uy);
    i_chars = STR2CSTR(chars);
    i_rsize = (real)NUM2DBL(rsize);
    i_irota = NUM2INT(irota);
    i_icent = NUM2INT(icent);
    i_index = NUM2INT(index);


    sgtxzu_(&i_ux, &i_uy, i_chars, &i_rsize, &i_irota, &i_icent, &i_index, (ftnlen)strlen(i_chars));

    return Qnil;

}

static VALUE
dcl_sgtxzv(obj, vx, vy, chars, rsize, irota, icent, index)
    VALUE obj, vx, vy, chars, rsize, irota, icent, index;
{
    real i_vx;
    real i_vy;
    char *i_chars;
    real i_rsize;
    integer i_irota;
    integer i_icent;
    integer i_index;

    if (TYPE(vx) != T_FLOAT) {
      vx = rb_funcall(vx, rb_intern("to_f"), 0);
    }
    if (TYPE(vy) != T_FLOAT) {
      vy = rb_funcall(vy, rb_intern("to_f"), 0);
    }
    if (TYPE(chars) != T_STRING) {
      chars = rb_funcall(chars, rb_intern("to_str"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }
    if ((TYPE(irota) != T_BIGNUM) || (TYPE(irota) != T_FIXNUM)) {
      irota = rb_funcall(irota, rb_intern("to_i"), 0);
    }
    if ((TYPE(icent) != T_BIGNUM) || (TYPE(icent) != T_FIXNUM)) {
      icent = rb_funcall(icent, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_vx = (real)NUM2DBL(vx);
    i_vy = (real)NUM2DBL(vy);
    i_chars = STR2CSTR(chars);
    i_rsize = (real)NUM2DBL(rsize);
    i_irota = NUM2INT(irota);
    i_icent = NUM2INT(icent);
    i_index = NUM2INT(index);


    sgtxzv_(&i_vx, &i_vy, i_chars, &i_rsize, &i_irota, &i_icent, &i_index, (ftnlen)strlen(i_chars));

    return Qnil;

}

static VALUE
dcl_sgtxzr(obj, rx, ry, chars, rsize, irota, icent, index)
    VALUE obj, rx, ry, chars, rsize, irota, icent, index;
{
    real i_rx;
    real i_ry;
    char *i_chars;
    real i_rsize;
    integer i_irota;
    integer i_icent;
    integer i_index;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }
    if (TYPE(ry) != T_FLOAT) {
      ry = rb_funcall(ry, rb_intern("to_f"), 0);
    }
    if (TYPE(chars) != T_STRING) {
      chars = rb_funcall(chars, rb_intern("to_str"), 0);
    }
    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }
    if ((TYPE(irota) != T_BIGNUM) || (TYPE(irota) != T_FIXNUM)) {
      irota = rb_funcall(irota, rb_intern("to_i"), 0);
    }
    if ((TYPE(icent) != T_BIGNUM) || (TYPE(icent) != T_FIXNUM)) {
      icent = rb_funcall(icent, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_rx = (real)NUM2DBL(rx);
    i_ry = (real)NUM2DBL(ry);
    i_chars = STR2CSTR(chars);
    i_rsize = (real)NUM2DBL(rsize);
    i_irota = NUM2INT(irota);
    i_icent = NUM2INT(icent);
    i_index = NUM2INT(index);


    sgtxzr_(&i_rx, &i_ry, i_chars, &i_rsize, &i_irota, &i_icent, &i_index, (ftnlen)strlen(i_chars));

    return Qnil;

}

static VALUE
dcl_sgtnu(obj, n, upx, upy)
    VALUE obj, n, upx, upy;
{
    integer i_n;
    real *i_upx;
    real *i_upy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    sgtnu_(&i_n, i_upx, i_upy);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_sgtnv(obj, n, vpx, vpy)
    VALUE obj, n, vpx, vpy;
{
    integer i_n;
    real *i_vpx;
    real *i_vpy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(vpx) == T_FLOAT) {
      vpx = rb_Array(vpx);
    }
    /* if ((TYPE(vpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(vpy) == T_FLOAT) {
      vpy = rb_Array(vpy);
    }
    /* if ((TYPE(vpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_vpx = dcl_obj2crealary(vpx);
    i_vpy = dcl_obj2crealary(vpy);


    sgtnv_(&i_n, i_vpx, i_vpy);

    dcl_freecrealary(i_vpx);
    dcl_freecrealary(i_vpy);

    return Qnil;

}

static VALUE
dcl_sgtnr(obj, n, rpx, rpy)
    VALUE obj, n, rpx, rpy;
{
    integer i_n;
    real *i_rpx;
    real *i_rpy;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rpx) == T_FLOAT) {
      rpx = rb_Array(rpx);
    }
    /* if ((TYPE(rpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(rpy) == T_FLOAT) {
      rpy = rb_Array(rpy);
    }
    /* if ((TYPE(rpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */

    i_n = NUM2INT(n);
    i_rpx = dcl_obj2crealary(rpx);
    i_rpy = dcl_obj2crealary(rpy);


    sgtnr_(&i_n, i_rpx, i_rpy);

    dcl_freecrealary(i_rpx);
    dcl_freecrealary(i_rpy);

    return Qnil;

}

static VALUE
dcl_sgstnp(obj, itpat)
    VALUE obj, itpat;
{
    integer i_itpat;

    if ((TYPE(itpat) != T_BIGNUM) || (TYPE(itpat) != T_FIXNUM)) {
      itpat = rb_funcall(itpat, rb_intern("to_i"), 0);
    }

    i_itpat = NUM2INT(itpat);


    sgstnp_(&i_itpat);

    return Qnil;

}

static VALUE
dcl_sgqtnp(obj)
    VALUE obj;
{
    integer o_itpat;
    VALUE itpat;

    sgqtnp_(&o_itpat);

    itpat = INT2NUM(o_itpat);


    return itpat;

}

static VALUE
dcl_sgtnzu(obj, n, upx, upy, itpat)
    VALUE obj, n, upx, upy, itpat;
{
    integer i_n;
    real *i_upx;
    real *i_upy;
    integer i_itpat;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(upx) == T_FLOAT) {
      upx = rb_Array(upx);
    }
    /* if ((TYPE(upx) != T_ARRAY) && 
           (rb_obj_is_kind_of(upx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(upy) == T_FLOAT) {
      upy = rb_Array(upy);
    }
    /* if ((TYPE(upy) != T_ARRAY) && 
           (rb_obj_is_kind_of(upy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat) != T_BIGNUM) || (TYPE(itpat) != T_FIXNUM)) {
      itpat = rb_funcall(itpat, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat = NUM2INT(itpat);
    i_upx = dcl_obj2crealary(upx);
    i_upy = dcl_obj2crealary(upy);


    sgtnzu_(&i_n, i_upx, i_upy, &i_itpat);

    dcl_freecrealary(i_upx);
    dcl_freecrealary(i_upy);

    return Qnil;

}

static VALUE
dcl_sgtnzv(obj, n, vpx, vpy, itpat)
    VALUE obj, n, vpx, vpy, itpat;
{
    integer i_n;
    real *i_vpx;
    real *i_vpy;
    integer i_itpat;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(vpx) == T_FLOAT) {
      vpx = rb_Array(vpx);
    }
    /* if ((TYPE(vpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(vpy) == T_FLOAT) {
      vpy = rb_Array(vpy);
    }
    /* if ((TYPE(vpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(vpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat) != T_BIGNUM) || (TYPE(itpat) != T_FIXNUM)) {
      itpat = rb_funcall(itpat, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat = NUM2INT(itpat);
    i_vpx = dcl_obj2crealary(vpx);
    i_vpy = dcl_obj2crealary(vpy);


    sgtnzv_(&i_n, i_vpx, i_vpy, &i_itpat);

    dcl_freecrealary(i_vpx);
    dcl_freecrealary(i_vpy);

    return Qnil;

}

static VALUE
dcl_sgtnzr(obj, n, rpx, rpy, itpat)
    VALUE obj, n, rpx, rpy, itpat;
{
    integer i_n;
    real *i_rpx;
    real *i_rpy;
    integer i_itpat;

    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if (TYPE(rpx) == T_FLOAT) {
      rpx = rb_Array(rpx);
    }
    /* if ((TYPE(rpx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(rpy) == T_FLOAT) {
      rpy = rb_Array(rpy);
    }
    /* if ((TYPE(rpy) != T_ARRAY) && 
           (rb_obj_is_kind_of(rpy, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(itpat) != T_BIGNUM) || (TYPE(itpat) != T_FIXNUM)) {
      itpat = rb_funcall(itpat, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_itpat = NUM2INT(itpat);
    i_rpx = dcl_obj2crealary(rpx);
    i_rpy = dcl_obj2crealary(rpy);


    sgtnzr_(&i_n, i_rpx, i_rpy, &i_itpat);

    dcl_freecrealary(i_rpx);
    dcl_freecrealary(i_rpy);

    return Qnil;

}

static VALUE
dcl_sglnu(obj, ux1, uy1, ux2, uy2)
    VALUE obj, ux1, uy1, ux2, uy2;
{
    real i_ux1;
    real i_uy1;
    real i_ux2;
    real i_uy2;

    if (TYPE(ux1) != T_FLOAT) {
      ux1 = rb_funcall(ux1, rb_intern("to_f"), 0);
    }
    if (TYPE(uy1) != T_FLOAT) {
      uy1 = rb_funcall(uy1, rb_intern("to_f"), 0);
    }
    if (TYPE(ux2) != T_FLOAT) {
      ux2 = rb_funcall(ux2, rb_intern("to_f"), 0);
    }
    if (TYPE(uy2) != T_FLOAT) {
      uy2 = rb_funcall(uy2, rb_intern("to_f"), 0);
    }

    i_ux1 = (real)NUM2DBL(ux1);
    i_uy1 = (real)NUM2DBL(uy1);
    i_ux2 = (real)NUM2DBL(ux2);
    i_uy2 = (real)NUM2DBL(uy2);


    sglnu_(&i_ux1, &i_uy1, &i_ux2, &i_uy2);

    return Qnil;

}

static VALUE
dcl_sglnv(obj, vx1, vy1, vx2, vy2)
    VALUE obj, vx1, vy1, vx2, vy2;
{
    real i_vx1;
    real i_vy1;
    real i_vx2;
    real i_vy2;

    if (TYPE(vx1) != T_FLOAT) {
      vx1 = rb_funcall(vx1, rb_intern("to_f"), 0);
    }
    if (TYPE(vy1) != T_FLOAT) {
      vy1 = rb_funcall(vy1, rb_intern("to_f"), 0);
    }
    if (TYPE(vx2) != T_FLOAT) {
      vx2 = rb_funcall(vx2, rb_intern("to_f"), 0);
    }
    if (TYPE(vy2) != T_FLOAT) {
      vy2 = rb_funcall(vy2, rb_intern("to_f"), 0);
    }

    i_vx1 = (real)NUM2DBL(vx1);
    i_vy1 = (real)NUM2DBL(vy1);
    i_vx2 = (real)NUM2DBL(vx2);
    i_vy2 = (real)NUM2DBL(vy2);


    sglnv_(&i_vx1, &i_vy1, &i_vx2, &i_vy2);

    return Qnil;

}

static VALUE
dcl_sglnr(obj, rx1, ry1, rx2, ry2)
    VALUE obj, rx1, ry1, rx2, ry2;
{
    real i_rx1;
    real i_ry1;
    real i_rx2;
    real i_ry2;

    if (TYPE(rx1) != T_FLOAT) {
      rx1 = rb_funcall(rx1, rb_intern("to_f"), 0);
    }
    if (TYPE(ry1) != T_FLOAT) {
      ry1 = rb_funcall(ry1, rb_intern("to_f"), 0);
    }
    if (TYPE(rx2) != T_FLOAT) {
      rx2 = rb_funcall(rx2, rb_intern("to_f"), 0);
    }
    if (TYPE(ry2) != T_FLOAT) {
      ry2 = rb_funcall(ry2, rb_intern("to_f"), 0);
    }

    i_rx1 = (real)NUM2DBL(rx1);
    i_ry1 = (real)NUM2DBL(ry1);
    i_rx2 = (real)NUM2DBL(rx2);
    i_ry2 = (real)NUM2DBL(ry2);


    sglnr_(&i_rx1, &i_ry1, &i_rx2, &i_ry2);

    return Qnil;

}

static VALUE
dcl_sgslni(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    sgslni_(&i_index);

    return Qnil;

}

static VALUE
dcl_sgqlni(obj)
    VALUE obj;
{
    integer o_index;
    VALUE index;

    sgqlni_(&o_index);

    index = INT2NUM(o_index);


    return index;

}

static VALUE
dcl_sglnzu(obj, ux1, uy1, ux2, uy2, index)
    VALUE obj, ux1, uy1, ux2, uy2, index;
{
    real i_ux1;
    real i_uy1;
    real i_ux2;
    real i_uy2;
    integer i_index;

    if (TYPE(ux1) != T_FLOAT) {
      ux1 = rb_funcall(ux1, rb_intern("to_f"), 0);
    }
    if (TYPE(uy1) != T_FLOAT) {
      uy1 = rb_funcall(uy1, rb_intern("to_f"), 0);
    }
    if (TYPE(ux2) != T_FLOAT) {
      ux2 = rb_funcall(ux2, rb_intern("to_f"), 0);
    }
    if (TYPE(uy2) != T_FLOAT) {
      uy2 = rb_funcall(uy2, rb_intern("to_f"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_ux1 = (real)NUM2DBL(ux1);
    i_uy1 = (real)NUM2DBL(uy1);
    i_ux2 = (real)NUM2DBL(ux2);
    i_uy2 = (real)NUM2DBL(uy2);
    i_index = NUM2INT(index);


    sglnzu_(&i_ux1, &i_uy1, &i_ux2, &i_uy2, &i_index);

    return Qnil;

}

static VALUE
dcl_sglnzv(obj, vx1, vy1, vx2, vy2, index)
    VALUE obj, vx1, vy1, vx2, vy2, index;
{
    real i_vx1;
    real i_vy1;
    real i_vx2;
    real i_vy2;
    integer i_index;

    if (TYPE(vx1) != T_FLOAT) {
      vx1 = rb_funcall(vx1, rb_intern("to_f"), 0);
    }
    if (TYPE(vy1) != T_FLOAT) {
      vy1 = rb_funcall(vy1, rb_intern("to_f"), 0);
    }
    if (TYPE(vx2) != T_FLOAT) {
      vx2 = rb_funcall(vx2, rb_intern("to_f"), 0);
    }
    if (TYPE(vy2) != T_FLOAT) {
      vy2 = rb_funcall(vy2, rb_intern("to_f"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_vx1 = (real)NUM2DBL(vx1);
    i_vy1 = (real)NUM2DBL(vy1);
    i_vx2 = (real)NUM2DBL(vx2);
    i_vy2 = (real)NUM2DBL(vy2);
    i_index = NUM2INT(index);


    sglnzv_(&i_vx1, &i_vy1, &i_vx2, &i_vy2, &i_index);

    return Qnil;

}

static VALUE
dcl_sglnzr(obj, rx1, ry1, rx2, ry2, index)
    VALUE obj, rx1, ry1, rx2, ry2, index;
{
    real i_rx1;
    real i_ry1;
    real i_rx2;
    real i_ry2;
    integer i_index;

    if (TYPE(rx1) != T_FLOAT) {
      rx1 = rb_funcall(rx1, rb_intern("to_f"), 0);
    }
    if (TYPE(ry1) != T_FLOAT) {
      ry1 = rb_funcall(ry1, rb_intern("to_f"), 0);
    }
    if (TYPE(rx2) != T_FLOAT) {
      rx2 = rb_funcall(rx2, rb_intern("to_f"), 0);
    }
    if (TYPE(ry2) != T_FLOAT) {
      ry2 = rb_funcall(ry2, rb_intern("to_f"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_rx1 = (real)NUM2DBL(rx1);
    i_ry1 = (real)NUM2DBL(ry1);
    i_rx2 = (real)NUM2DBL(rx2);
    i_ry2 = (real)NUM2DBL(ry2);
    i_index = NUM2INT(index);


    sglnzr_(&i_rx1, &i_ry1, &i_rx2, &i_ry2, &i_index);

    return Qnil;

}

static VALUE
dcl_sglau(obj, ux1, uy1, ux2, uy2)
    VALUE obj, ux1, uy1, ux2, uy2;
{
    real i_ux1;
    real i_uy1;
    real i_ux2;
    real i_uy2;

    if (TYPE(ux1) != T_FLOAT) {
      ux1 = rb_funcall(ux1, rb_intern("to_f"), 0);
    }
    if (TYPE(uy1) != T_FLOAT) {
      uy1 = rb_funcall(uy1, rb_intern("to_f"), 0);
    }
    if (TYPE(ux2) != T_FLOAT) {
      ux2 = rb_funcall(ux2, rb_intern("to_f"), 0);
    }
    if (TYPE(uy2) != T_FLOAT) {
      uy2 = rb_funcall(uy2, rb_intern("to_f"), 0);
    }

    i_ux1 = (real)NUM2DBL(ux1);
    i_uy1 = (real)NUM2DBL(uy1);
    i_ux2 = (real)NUM2DBL(ux2);
    i_uy2 = (real)NUM2DBL(uy2);


    sglau_(&i_ux1, &i_uy1, &i_ux2, &i_uy2);

    return Qnil;

}

static VALUE
dcl_sglav(obj, vx1, vy1, vx2, vy2)
    VALUE obj, vx1, vy1, vx2, vy2;
{
    real i_vx1;
    real i_vy1;
    real i_vx2;
    real i_vy2;

    if (TYPE(vx1) != T_FLOAT) {
      vx1 = rb_funcall(vx1, rb_intern("to_f"), 0);
    }
    if (TYPE(vy1) != T_FLOAT) {
      vy1 = rb_funcall(vy1, rb_intern("to_f"), 0);
    }
    if (TYPE(vx2) != T_FLOAT) {
      vx2 = rb_funcall(vx2, rb_intern("to_f"), 0);
    }
    if (TYPE(vy2) != T_FLOAT) {
      vy2 = rb_funcall(vy2, rb_intern("to_f"), 0);
    }

    i_vx1 = (real)NUM2DBL(vx1);
    i_vy1 = (real)NUM2DBL(vy1);
    i_vx2 = (real)NUM2DBL(vx2);
    i_vy2 = (real)NUM2DBL(vy2);


    sglav_(&i_vx1, &i_vy1, &i_vx2, &i_vy2);

    return Qnil;

}

static VALUE
dcl_sglar(obj, rx1, ry1, rx2, ry2)
    VALUE obj, rx1, ry1, rx2, ry2;
{
    real i_rx1;
    real i_ry1;
    real i_rx2;
    real i_ry2;

    if (TYPE(rx1) != T_FLOAT) {
      rx1 = rb_funcall(rx1, rb_intern("to_f"), 0);
    }
    if (TYPE(ry1) != T_FLOAT) {
      ry1 = rb_funcall(ry1, rb_intern("to_f"), 0);
    }
    if (TYPE(rx2) != T_FLOAT) {
      rx2 = rb_funcall(rx2, rb_intern("to_f"), 0);
    }
    if (TYPE(ry2) != T_FLOAT) {
      ry2 = rb_funcall(ry2, rb_intern("to_f"), 0);
    }

    i_rx1 = (real)NUM2DBL(rx1);
    i_ry1 = (real)NUM2DBL(ry1);
    i_rx2 = (real)NUM2DBL(rx2);
    i_ry2 = (real)NUM2DBL(ry2);


    sglar_(&i_rx1, &i_ry1, &i_rx2, &i_ry2);

    return Qnil;

}

static VALUE
dcl_sgslat(obj, itype)
    VALUE obj, itype;
{
    integer i_itype;

    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }

    i_itype = NUM2INT(itype);


    sgslat_(&i_itype);

    return Qnil;

}

static VALUE
dcl_sgqlat(obj)
    VALUE obj;
{
    integer o_itype;
    VALUE itype;

    sgqlat_(&o_itype);

    itype = INT2NUM(o_itype);


    return itype;

}

static VALUE
dcl_sgslai(obj, index)
    VALUE obj, index;
{
    integer i_index;

    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_index = NUM2INT(index);


    sgslai_(&i_index);

    return Qnil;

}

static VALUE
dcl_sgqlai(obj)
    VALUE obj;
{
    integer o_index;
    VALUE index;

    sgqlai_(&o_index);

    index = INT2NUM(o_index);


    return index;

}

static VALUE
dcl_sglazu(obj, ux1, uy1, ux2, uy2, itype, index)
    VALUE obj, ux1, uy1, ux2, uy2, itype, index;
{
    real i_ux1;
    real i_uy1;
    real i_ux2;
    real i_uy2;
    integer i_itype;
    integer i_index;

    if (TYPE(ux1) != T_FLOAT) {
      ux1 = rb_funcall(ux1, rb_intern("to_f"), 0);
    }
    if (TYPE(uy1) != T_FLOAT) {
      uy1 = rb_funcall(uy1, rb_intern("to_f"), 0);
    }
    if (TYPE(ux2) != T_FLOAT) {
      ux2 = rb_funcall(ux2, rb_intern("to_f"), 0);
    }
    if (TYPE(uy2) != T_FLOAT) {
      uy2 = rb_funcall(uy2, rb_intern("to_f"), 0);
    }
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_ux1 = (real)NUM2DBL(ux1);
    i_uy1 = (real)NUM2DBL(uy1);
    i_ux2 = (real)NUM2DBL(ux2);
    i_uy2 = (real)NUM2DBL(uy2);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);


    sglazu_(&i_ux1, &i_uy1, &i_ux2, &i_uy2, &i_itype, &i_index);

    return Qnil;

}

static VALUE
dcl_sglazv(obj, vx1, vy1, vx2, vy2, itype, index)
    VALUE obj, vx1, vy1, vx2, vy2, itype, index;
{
    real i_vx1;
    real i_vy1;
    real i_vx2;
    real i_vy2;
    integer i_itype;
    integer i_index;

    if (TYPE(vx1) != T_FLOAT) {
      vx1 = rb_funcall(vx1, rb_intern("to_f"), 0);
    }
    if (TYPE(vy1) != T_FLOAT) {
      vy1 = rb_funcall(vy1, rb_intern("to_f"), 0);
    }
    if (TYPE(vx2) != T_FLOAT) {
      vx2 = rb_funcall(vx2, rb_intern("to_f"), 0);
    }
    if (TYPE(vy2) != T_FLOAT) {
      vy2 = rb_funcall(vy2, rb_intern("to_f"), 0);
    }
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_vx1 = (real)NUM2DBL(vx1);
    i_vy1 = (real)NUM2DBL(vy1);
    i_vx2 = (real)NUM2DBL(vx2);
    i_vy2 = (real)NUM2DBL(vy2);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);


    sglazv_(&i_vx1, &i_vy1, &i_vx2, &i_vy2, &i_itype, &i_index);

    return Qnil;

}

static VALUE
dcl_sglazr(obj, rx1, ry1, rx2, ry2, itype, index)
    VALUE obj, rx1, ry1, rx2, ry2, itype, index;
{
    real i_rx1;
    real i_ry1;
    real i_rx2;
    real i_ry2;
    integer i_itype;
    integer i_index;

    if (TYPE(rx1) != T_FLOAT) {
      rx1 = rb_funcall(rx1, rb_intern("to_f"), 0);
    }
    if (TYPE(ry1) != T_FLOAT) {
      ry1 = rb_funcall(ry1, rb_intern("to_f"), 0);
    }
    if (TYPE(rx2) != T_FLOAT) {
      rx2 = rb_funcall(rx2, rb_intern("to_f"), 0);
    }
    if (TYPE(ry2) != T_FLOAT) {
      ry2 = rb_funcall(ry2, rb_intern("to_f"), 0);
    }
    if ((TYPE(itype) != T_BIGNUM) || (TYPE(itype) != T_FIXNUM)) {
      itype = rb_funcall(itype, rb_intern("to_i"), 0);
    }
    if ((TYPE(index) != T_BIGNUM) || (TYPE(index) != T_FIXNUM)) {
      index = rb_funcall(index, rb_intern("to_i"), 0);
    }

    i_rx1 = (real)NUM2DBL(rx1);
    i_ry1 = (real)NUM2DBL(ry1);
    i_rx2 = (real)NUM2DBL(rx2);
    i_ry2 = (real)NUM2DBL(ry2);
    i_itype = NUM2INT(itype);
    i_index = NUM2INT(index);


    sglazr_(&i_rx1, &i_ry1, &i_rx2, &i_ry2, &i_itype, &i_index);

    return Qnil;

}

static VALUE
dcl_sgsplc(obj, charx)
    VALUE obj, charx;
{
    char *i_charx;

    if (TYPE(charx) != T_STRING) {
      charx = rb_funcall(charx, rb_intern("to_str"), 0);
    }

    i_charx = STR2CSTR(charx);


    sgsplc_(i_charx, (ftnlen)strlen(i_charx));

    return Qnil;

}

static VALUE
dcl_sgqplc(obj)
    VALUE obj;
{
    char *o_charx;
    VALUE charx;

    o_charx= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_charx, '\0', DFLT_SIZE+1);

    sgqplc_(o_charx, (ftnlen)DFLT_SIZE);

    charx = rb_str_new2(o_charx);


    return charx;

}

static VALUE
dcl_sgspls(obj, rsize)
    VALUE obj, rsize;
{
    real i_rsize;

    if (TYPE(rsize) != T_FLOAT) {
      rsize = rb_funcall(rsize, rb_intern("to_f"), 0);
    }

    i_rsize = (real)NUM2DBL(rsize);


    sgspls_(&i_rsize);

    return Qnil;

}

static VALUE
dcl_sgqpls(obj)
    VALUE obj;
{
    real o_rsize;
    VALUE rsize;

    sgqpls_(&o_rsize);

    rsize = rb_float_new((double)o_rsize);


    return rsize;

}

static VALUE
dcl_sgnplc(obj)
    VALUE obj;
{
    sgnplc_();

    return Qnil;

}

static VALUE
dcl_sgiget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_ipara;
    VALUE ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgiget_(i_cp, &o_ipara, (ftnlen)strlen(i_cp));

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_sgiset(obj, cp, ipara)
    VALUE obj, cp, ipara;
{
    char *i_cp;
    integer i_ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_cp = STR2CSTR(cp);
    i_ipara = NUM2INT(ipara);


    sgiset_(i_cp, &i_ipara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_sgistx(obj, cp, ipara)
    VALUE obj, cp, ipara;
{
    char *i_cp;
    integer i_ipara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_cp = STR2CSTR(cp);
    i_ipara = NUM2INT(ipara);


    sgistx_(i_cp, &i_ipara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_sgiqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    sgiqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_sgiqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgiqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_sgiqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sgiqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sgiqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sgiqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sgiqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    integer o_ipara;
    VALUE ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    sgiqvl_(&i_idx, &o_ipara);

    ipara = INT2NUM(o_ipara);


    return ipara;

}

static VALUE
dcl_sgisvl(obj, idx, ipara)
    VALUE obj, idx, ipara;
{
    integer i_idx;
    integer i_ipara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }
    if ((TYPE(ipara) != T_BIGNUM) || (TYPE(ipara) != T_FIXNUM)) {
      ipara = rb_funcall(ipara, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_ipara = NUM2INT(ipara);


    sgisvl_(&i_idx, &i_ipara);

    return Qnil;

}

static VALUE
dcl_sgiqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgiqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_sglget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    logical o_lpara;
    VALUE lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sglget_(i_cp, &o_lpara, (ftnlen)strlen(i_cp));

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_sglset(obj, cp, lpara)
    VALUE obj, cp, lpara;
{
    char *i_cp;
    logical i_lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    sglset_(i_cp, &i_lpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_sglstx(obj, cp, lpara)
    VALUE obj, cp, lpara;
{
    char *i_cp;
    logical i_lpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    sglstx_(i_cp, &i_lpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_sglqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    sglqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_sglqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sglqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_sglqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sglqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sglqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sglqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sglqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    logical o_lpara;
    VALUE lpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    sglqvl_(&i_idx, &o_lpara);

    lpara = (o_lpara == FALSE_) ? Qfalse : Qtrue;


    return lpara;

}

static VALUE
dcl_sglsvl(obj, idx, lpara)
    VALUE obj, idx, lpara;
{
    integer i_idx;
    logical i_lpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);
    i_lpara = ((lpara == Qnil)||(lpara == Qfalse)) ? FALSE_ : TRUE_;


    sglsvl_(&i_idx, &i_lpara);

    return Qnil;

}

static VALUE
dcl_sglqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sglqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

static VALUE
dcl_sgoopn(obj, cprc, com)
    VALUE obj, cprc, com;
{
    char *i_cprc;
    char *i_com;

    if (TYPE(cprc) != T_STRING) {
      cprc = rb_funcall(cprc, rb_intern("to_str"), 0);
    }
    if (TYPE(com) != T_STRING) {
      com = rb_funcall(com, rb_intern("to_str"), 0);
    }

    i_cprc = STR2CSTR(cprc);
    i_com = STR2CSTR(com);


    sgoopn_(i_cprc, i_com, (ftnlen)strlen(i_cprc), (ftnlen)strlen(i_com));

    return Qnil;

}

static VALUE
dcl_sgocls(obj, cprc)
    VALUE obj, cprc;
{
    char *i_cprc;

    if (TYPE(cprc) != T_STRING) {
      cprc = rb_funcall(cprc, rb_intern("to_str"), 0);
    }

    i_cprc = STR2CSTR(cprc);


    sgocls_(i_cprc, (ftnlen)strlen(i_cprc));

    return Qnil;

}

static VALUE
dcl_sgrget(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    real o_rpara;
    VALUE rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgrget_(i_cp, &o_rpara, (ftnlen)strlen(i_cp));

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_sgrset(obj, cp, rpara)
    VALUE obj, cp, rpara;
{
    char *i_cp;
    real i_rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_cp = STR2CSTR(cp);
    i_rpara = (real)NUM2DBL(rpara);


    sgrset_(i_cp, &i_rpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_sgrstx(obj, cp, rpara)
    VALUE obj, cp, rpara;
{
    char *i_cp;
    real i_rpara;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_cp = STR2CSTR(cp);
    i_rpara = (real)NUM2DBL(rpara);


    sgrstx_(i_cp, &i_rpara, (ftnlen)strlen(i_cp));

    return Qnil;

}

static VALUE
dcl_sgrqnp(obj)
    VALUE obj;
{
    integer o_ncp;
    VALUE ncp;

    sgrqnp_(&o_ncp);

    ncp = INT2NUM(o_ncp);


    return ncp;

}

static VALUE
dcl_sgrqid(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_idx;
    VALUE idx;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgrqid_(i_cp, &o_idx, (ftnlen)strlen(i_cp));

    idx = INT2NUM(o_idx);


    return idx;

}

static VALUE
dcl_sgrqcp(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sgrqcp_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sgrqcl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    char *o_cp;
    VALUE cp;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);

    o_cp= ALLOCA_N(char, (DFLT_SIZE+1));
    memset(o_cp, '\0', DFLT_SIZE+1);

    sgrqcl_(&i_idx, o_cp, (ftnlen)DFLT_SIZE);

    cp = rb_str_new2(o_cp);


    return cp;

}

static VALUE
dcl_sgrqvl(obj, idx)
    VALUE obj, idx;
{
    integer i_idx;
    real o_rpara;
    VALUE rpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }

    i_idx = NUM2INT(idx);


    sgrqvl_(&i_idx, &o_rpara);

    rpara = rb_float_new((double)o_rpara);


    return rpara;

}

static VALUE
dcl_sgrsvl(obj, idx, rpara)
    VALUE obj, idx, rpara;
{
    integer i_idx;
    real i_rpara;

    if ((TYPE(idx) != T_BIGNUM) || (TYPE(idx) != T_FIXNUM)) {
      idx = rb_funcall(idx, rb_intern("to_i"), 0);
    }
    if (TYPE(rpara) != T_FLOAT) {
      rpara = rb_funcall(rpara, rb_intern("to_f"), 0);
    }

    i_idx = NUM2INT(idx);
    i_rpara = (real)NUM2DBL(rpara);


    sgrsvl_(&i_idx, &i_rpara);

    return Qnil;

}

static VALUE
dcl_sgrqin(obj, cp)
    VALUE obj, cp;
{
    char *i_cp;
    integer o_in;
    VALUE in;

    if (TYPE(cp) != T_STRING) {
      cp = rb_funcall(cp, rb_intern("to_str"), 0);
    }

    i_cp = STR2CSTR(cp);


    sgrqin_(i_cp, &o_in, (ftnlen)strlen(i_cp));

    in = INT2NUM(o_in);


    return in;

}

#if DCLVER >= 53

static VALUE
dcl_sgpcmd(obj)
    VALUE obj;
{
    sgpcmd_();

    return Qnil;

}

#endif

#if DCLVER >= 53

static VALUE
dcl_sgscmn(obj, nc)
    VALUE obj, nc;
{
    integer i_nc;

    if ((TYPE(nc) != T_BIGNUM) || (TYPE(nc) != T_FIXNUM)) {
      nc = rb_funcall(nc, rb_intern("to_i"), 0);
    }

    i_nc = NUM2INT(nc);


    sgscmn_(&i_nc);

    return Qnil;

}

#endif

#if DCLVER >= 53

static VALUE
dcl_sgqcmn(obj)
    VALUE obj;
{
    integer o_nmax;
    VALUE nmax;

    sgqcmn_(&o_nmax);

    nmax = INT2NUM(o_nmax);


    return nmax;

}

#endif

#if DCLVER >= 53

static VALUE
dcl_sgscwd(obj, cxmin, cxmax, cymin, cymax)
    VALUE obj, cxmin, cxmax, cymin, cymax;
{
    real i_cxmin;
    real i_cxmax;
    real i_cymin;
    real i_cymax;

    if (TYPE(cxmin) != T_FLOAT) {
      cxmin = rb_funcall(cxmin, rb_intern("to_f"), 0);
    }
    if (TYPE(cxmax) != T_FLOAT) {
      cxmax = rb_funcall(cxmax, rb_intern("to_f"), 0);
    }
    if (TYPE(cymin) != T_FLOAT) {
      cymin = rb_funcall(cymin, rb_intern("to_f"), 0);
    }
    if (TYPE(cymax) != T_FLOAT) {
      cymax = rb_funcall(cymax, rb_intern("to_f"), 0);
    }

    i_cxmin = (real)NUM2DBL(cxmin);
    i_cxmax = (real)NUM2DBL(cxmax);
    i_cymin = (real)NUM2DBL(cymin);
    i_cymax = (real)NUM2DBL(cymax);


    sgscwd_(&i_cxmin, &i_cxmax, &i_cymin, &i_cymax);

    return Qnil;

}

#endif

#if DCLVER >= 53

static VALUE
dcl_sgqcwd(obj)
    VALUE obj;
{
    real o_cxmin;
    real o_cxmax;
    real o_cymin;
    real o_cymax;
    VALUE cxmin;
    VALUE cxmax;
    VALUE cymin;
    VALUE cymax;

    sgqcwd_(&o_cxmin, &o_cxmax, &o_cymin, &o_cymax);

    cxmin = rb_float_new((double)o_cxmin);
    cxmax = rb_float_new((double)o_cxmax);
    cymin = rb_float_new((double)o_cymin);
    cymax = rb_float_new((double)o_cymax);


    return rb_ary_new3(4, cxmin, cxmax, cymin, cymax);

}

#endif
void
init_grph1_sgpack(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "sgopn", dcl_sgopn, 1);
    rb_define_module_function(mDCL, "sgfrm", dcl_sgfrm, 0);
    rb_define_module_function(mDCL, "sgcls", dcl_sgcls, 0);
    rb_define_module_function(mDCL, "sgpqnp", dcl_sgpqnp, 0);
    rb_define_module_function(mDCL, "sgpqid", dcl_sgpqid, 1);
    rb_define_module_function(mDCL, "sgpqcp", dcl_sgpqcp, 1);
    rb_define_module_function(mDCL, "sgpqcl", dcl_sgpqcl, 1);
    rb_define_module_function(mDCL, "sgpqit", dcl_sgpqit, 1);
    rb_define_module_function(mDCL, "sgpqvl", dcl_sgpqvl, 1);
    rb_define_module_function(mDCL, "sgpsvl", dcl_sgpsvl, 2);
    rb_define_module_function(mDCL, "sgpqin", dcl_sgpqin, 1);
    rb_define_module_function(mDCL, "sgpwsn", dcl_sgpwsn, 0);
    rb_define_module_function(mDCL, "sgsvpt", dcl_sgsvpt, 4);
    rb_define_module_function(mDCL, "sgqvpt", dcl_sgqvpt, 0);
    rb_define_module_function(mDCL, "sgswnd", dcl_sgswnd, 4);
    rb_define_module_function(mDCL, "sgqwnd", dcl_sgqwnd, 0);
    rb_define_module_function(mDCL, "sgssim", dcl_sgssim, 3);
    rb_define_module_function(mDCL, "sgqsim", dcl_sgqsim, 0);
    rb_define_module_function(mDCL, "sgsmpl", dcl_sgsmpl, 3);
    rb_define_module_function(mDCL, "sgqmpl", dcl_sgqmpl, 0);
    rb_define_module_function(mDCL, "sgstxy", dcl_sgstxy, 4);
    rb_define_module_function(mDCL, "sgqtxy", dcl_sgqtxy, 0);
    rb_define_module_function(mDCL, "sgstrn", dcl_sgstrn, 1);
    rb_define_module_function(mDCL, "sgqtrn", dcl_sgqtrn, 0);
    rb_define_module_function(mDCL, "sgstrf", dcl_sgstrf, 0);
    rb_define_module_function(mDCL, "sgtrqf", dcl_sgtrqf, 1);
    rb_define_module_function(mDCL, "sgtrsl", dcl_sgtrsl, 1);
    rb_define_module_function(mDCL, "sgtrsn", dcl_sgtrsn, 1);
    rb_define_module_function(mDCL, "sgtrls", dcl_sgtrls, 1);
    rb_define_module_function(mDCL, "sgtrln", dcl_sgtrln, 1);
    rb_define_module_function(mDCL, "sgtrns", dcl_sgtrns, 1);
    rb_define_module_function(mDCL, "sgtrnl", dcl_sgtrnl, 1);
    rb_define_module_function(mDCL, "isgtrc", dcl_isgtrc, 1);
    rb_define_module_function(mDCL, "sgplu", dcl_sgplu, 3);
    rb_define_module_function(mDCL, "sgplv", dcl_sgplv, 3);
    rb_define_module_function(mDCL, "sgplr", dcl_sgplr, 3);
    rb_define_module_function(mDCL, "sgsplt", dcl_sgsplt, 1);
    rb_define_module_function(mDCL, "sgqplt", dcl_sgqplt, 0);
    rb_define_module_function(mDCL, "sgspli", dcl_sgspli, 1);
    rb_define_module_function(mDCL, "sgqpli", dcl_sgqpli, 0);
    rb_define_module_function(mDCL, "sgplzu", dcl_sgplzu, 5);
    rb_define_module_function(mDCL, "sgplzv", dcl_sgplzv, 5);
    rb_define_module_function(mDCL, "sgplzr", dcl_sgplzr, 5);
    rb_define_module_function(mDCL, "sgpmu", dcl_sgpmu, 3);
    rb_define_module_function(mDCL, "sgpmv", dcl_sgpmv, 3);
    rb_define_module_function(mDCL, "sgpmr", dcl_sgpmr, 3);
    rb_define_module_function(mDCL, "sgspmt", dcl_sgspmt, 1);
    rb_define_module_function(mDCL, "sgqpmt", dcl_sgqpmt, 0);
    rb_define_module_function(mDCL, "sgspmi", dcl_sgspmi, 1);
    rb_define_module_function(mDCL, "sgqpmi", dcl_sgqpmi, 0);
    rb_define_module_function(mDCL, "sgspms", dcl_sgspms, 1);
    rb_define_module_function(mDCL, "sgqpms", dcl_sgqpms, 0);
    rb_define_module_function(mDCL, "sgtxu", dcl_sgtxu, 3);
    rb_define_module_function(mDCL, "sgtxv", dcl_sgtxv, 3);
    rb_define_module_function(mDCL, "sgtxr", dcl_sgtxr, 3);
    rb_define_module_function(mDCL, "sgstxs", dcl_sgstxs, 1);
    rb_define_module_function(mDCL, "sgqtxs", dcl_sgqtxs, 0);
    rb_define_module_function(mDCL, "sgstxr", dcl_sgstxr, 1);
    rb_define_module_function(mDCL, "sgqtxr", dcl_sgqtxr, 0);
    rb_define_module_function(mDCL, "sgstxc", dcl_sgstxc, 1);
    rb_define_module_function(mDCL, "sgqtxc", dcl_sgqtxc, 0);
    rb_define_module_function(mDCL, "sgstxi", dcl_sgstxi, 1);
    rb_define_module_function(mDCL, "sgqtxi", dcl_sgqtxi, 0);
    rb_define_module_function(mDCL, "sgpmzu", dcl_sgpmzu, 6);
    rb_define_module_function(mDCL, "sgpmzv", dcl_sgpmzv, 6);
    rb_define_module_function(mDCL, "sgpmzr", dcl_sgpmzr, 6);
    rb_define_module_function(mDCL, "sgtxzu", dcl_sgtxzu, 7);
    rb_define_module_function(mDCL, "sgtxzv", dcl_sgtxzv, 7);
    rb_define_module_function(mDCL, "sgtxzr", dcl_sgtxzr, 7);
    rb_define_module_function(mDCL, "sgtnu", dcl_sgtnu, 3);
    rb_define_module_function(mDCL, "sgtnv", dcl_sgtnv, 3);
    rb_define_module_function(mDCL, "sgtnr", dcl_sgtnr, 3);
    rb_define_module_function(mDCL, "sgstnp", dcl_sgstnp, 1);
    rb_define_module_function(mDCL, "sgqtnp", dcl_sgqtnp, 0);
    rb_define_module_function(mDCL, "sgtnzu", dcl_sgtnzu, 4);
    rb_define_module_function(mDCL, "sgtnzv", dcl_sgtnzv, 4);
    rb_define_module_function(mDCL, "sgtnzr", dcl_sgtnzr, 4);
    rb_define_module_function(mDCL, "sglnu", dcl_sglnu, 4);
    rb_define_module_function(mDCL, "sglnv", dcl_sglnv, 4);
    rb_define_module_function(mDCL, "sglnr", dcl_sglnr, 4);
    rb_define_module_function(mDCL, "sgslni", dcl_sgslni, 1);
    rb_define_module_function(mDCL, "sgqlni", dcl_sgqlni, 0);
    rb_define_module_function(mDCL, "sglnzu", dcl_sglnzu, 5);
    rb_define_module_function(mDCL, "sglnzv", dcl_sglnzv, 5);
    rb_define_module_function(mDCL, "sglnzr", dcl_sglnzr, 5);
    rb_define_module_function(mDCL, "sglau", dcl_sglau, 4);
    rb_define_module_function(mDCL, "sglav", dcl_sglav, 4);
    rb_define_module_function(mDCL, "sglar", dcl_sglar, 4);
    rb_define_module_function(mDCL, "sgslat", dcl_sgslat, 1);
    rb_define_module_function(mDCL, "sgqlat", dcl_sgqlat, 0);
    rb_define_module_function(mDCL, "sgslai", dcl_sgslai, 1);
    rb_define_module_function(mDCL, "sgqlai", dcl_sgqlai, 0);
    rb_define_module_function(mDCL, "sglazu", dcl_sglazu, 6);
    rb_define_module_function(mDCL, "sglazv", dcl_sglazv, 6);
    rb_define_module_function(mDCL, "sglazr", dcl_sglazr, 6);
    rb_define_module_function(mDCL, "sgsplc", dcl_sgsplc, 1);
    rb_define_module_function(mDCL, "sgqplc", dcl_sgqplc, 0);
    rb_define_module_function(mDCL, "sgspls", dcl_sgspls, 1);
    rb_define_module_function(mDCL, "sgqpls", dcl_sgqpls, 0);
    rb_define_module_function(mDCL, "sgnplc", dcl_sgnplc, 0);
    rb_define_module_function(mDCL, "sgiget", dcl_sgiget, 1);
    rb_define_module_function(mDCL, "sgiset", dcl_sgiset, 2);
    rb_define_module_function(mDCL, "sgistx", dcl_sgistx, 2);
    rb_define_module_function(mDCL, "sgiqnp", dcl_sgiqnp, 0);
    rb_define_module_function(mDCL, "sgiqid", dcl_sgiqid, 1);
    rb_define_module_function(mDCL, "sgiqcp", dcl_sgiqcp, 1);
    rb_define_module_function(mDCL, "sgiqcl", dcl_sgiqcl, 1);
    rb_define_module_function(mDCL, "sgiqvl", dcl_sgiqvl, 1);
    rb_define_module_function(mDCL, "sgisvl", dcl_sgisvl, 2);
    rb_define_module_function(mDCL, "sgiqin", dcl_sgiqin, 1);
    rb_define_module_function(mDCL, "sglget", dcl_sglget, 1);
    rb_define_module_function(mDCL, "sglset", dcl_sglset, 2);
    rb_define_module_function(mDCL, "sglstx", dcl_sglstx, 2);
    rb_define_module_function(mDCL, "sglqnp", dcl_sglqnp, 0);
    rb_define_module_function(mDCL, "sglqid", dcl_sglqid, 1);
    rb_define_module_function(mDCL, "sglqcp", dcl_sglqcp, 1);
    rb_define_module_function(mDCL, "sglqcl", dcl_sglqcl, 1);
    rb_define_module_function(mDCL, "sglqvl", dcl_sglqvl, 1);
    rb_define_module_function(mDCL, "sglsvl", dcl_sglsvl, 2);
    rb_define_module_function(mDCL, "sglqin", dcl_sglqin, 1);
    rb_define_module_function(mDCL, "sgoopn", dcl_sgoopn, 2);
    rb_define_module_function(mDCL, "sgocls", dcl_sgocls, 1);
    rb_define_module_function(mDCL, "sgrget", dcl_sgrget, 1);
    rb_define_module_function(mDCL, "sgrset", dcl_sgrset, 2);
    rb_define_module_function(mDCL, "sgrstx", dcl_sgrstx, 2);
    rb_define_module_function(mDCL, "sgrqnp", dcl_sgrqnp, 0);
    rb_define_module_function(mDCL, "sgrqid", dcl_sgrqid, 1);
    rb_define_module_function(mDCL, "sgrqcp", dcl_sgrqcp, 1);
    rb_define_module_function(mDCL, "sgrqcl", dcl_sgrqcl, 1);
    rb_define_module_function(mDCL, "sgrqvl", dcl_sgrqvl, 1);
    rb_define_module_function(mDCL, "sgrsvl", dcl_sgrsvl, 2);
    rb_define_module_function(mDCL, "sgrqin", dcl_sgrqin, 1);
#if DCLVER >= 53
    rb_define_module_function(mDCL, "sgpcmd", dcl_sgpcmd, 0);
#endif
#if DCLVER >= 53
    rb_define_module_function(mDCL, "sgscmn", dcl_sgscmn, 1);
#endif
#if DCLVER >= 53
    rb_define_module_function(mDCL, "sgqcmn", dcl_sgqcmn, 0);
#endif
#if DCLVER >= 53
    rb_define_module_function(mDCL, "sgscwd", dcl_sgscwd, 4);
#endif
#if DCLVER >= 53
    rb_define_module_function(mDCL, "sgqcwd", dcl_sgqcwd, 0);
#endif
}
