/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


VALUE mDCL;

static VALUE
dcl_irlt(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = irlt_(&i_rx);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_irge(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = irge_(&i_rx);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_irle(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = irle_(&i_rx);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_irgt(obj, rx)
    VALUE obj, rx;
{
    real i_rx;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) != T_FLOAT) {
      rx = rb_funcall(rx, rb_intern("to_f"), 0);
    }

    i_rx = (real)NUM2DBL(rx);


    o_rtn_val = irgt_(&i_rx);

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}
void
init_math1_intlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "irlt", dcl_irlt, 1);
    rb_define_module_function(mDCL, "irge", dcl_irge, 1);
    rb_define_module_function(mDCL, "irle", dcl_irle, 1);
    rb_define_module_function(mDCL, "irgt", dcl_irgt, 1);
}
