/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_chngc(obj, ch, ca, cb)
    VALUE obj, ch, ca, cb;
{
    char *io_ch;
    char *i_ca;
    char *i_cb;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }
    if (TYPE(ca) != T_STRING) {
      ca = rb_funcall(ca, rb_intern("to_str"), 0);
    }
    if (TYPE(cb) != T_STRING) {
      cb = rb_funcall(cb, rb_intern("to_str"), 0);
    }

    io_ch = ALLOCA_N(char, strlen(STR2CSTR(ch))+1);
    strcpy(io_ch, STR2CSTR(ch));
    i_ca = STR2CSTR(ca);
    i_cb = STR2CSTR(cb);


    chngc_(io_ch, i_ca, i_cb, (ftnlen)strlen(io_ch), (ftnlen)strlen(i_ca), (ftnlen)strlen(i_cb));

    ch = rb_str_new2(io_ch);


    return ch;

}

static VALUE
dcl_chngi(obj, ch, ca, ii, cfmt)
    VALUE obj, ch, ca, ii, cfmt;
{
    char *io_ch;
    char *i_ca;
    integer i_ii;
    char *i_cfmt;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }
    if (TYPE(ca) != T_STRING) {
      ca = rb_funcall(ca, rb_intern("to_str"), 0);
    }
    if ((TYPE(ii) != T_BIGNUM) || (TYPE(ii) != T_FIXNUM)) {
      ii = rb_funcall(ii, rb_intern("to_i"), 0);
    }
    if (TYPE(cfmt) != T_STRING) {
      cfmt = rb_funcall(cfmt, rb_intern("to_str"), 0);
    }

    io_ch = ALLOCA_N(char, strlen(STR2CSTR(ch))+1);
    strcpy(io_ch, STR2CSTR(ch));
    i_ca = STR2CSTR(ca);
    i_ii = NUM2INT(ii);
    i_cfmt = STR2CSTR(cfmt);


    chngi_(io_ch, i_ca, &i_ii, i_cfmt, (ftnlen)strlen(io_ch), (ftnlen)strlen(i_ca), (ftnlen)strlen(i_cfmt));

    ch = rb_str_new2(io_ch);


    return ch;

}

static VALUE
dcl_chngr(obj, ch, ca, rr, cfmt)
    VALUE obj, ch, ca, rr, cfmt;
{
    char *io_ch;
    char *i_ca;
    real i_rr;
    char *i_cfmt;

    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }
    if (TYPE(ca) != T_STRING) {
      ca = rb_funcall(ca, rb_intern("to_str"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }
    if (TYPE(cfmt) != T_STRING) {
      cfmt = rb_funcall(cfmt, rb_intern("to_str"), 0);
    }

    io_ch = ALLOCA_N(char, strlen(STR2CSTR(ch))+1);
    strcpy(io_ch, STR2CSTR(ch));
    i_ca = STR2CSTR(ca);
    i_rr = (real)NUM2DBL(rr);
    i_cfmt = STR2CSTR(cfmt);


    chngr_(io_ch, i_ca, &i_rr, i_cfmt, (ftnlen)strlen(io_ch), (ftnlen)strlen(i_ca), (ftnlen)strlen(i_cfmt));

    ch = rb_str_new2(io_ch);


    return ch;

}
void
init_misc1_chnlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "chngc", dcl_chngc, 3);
    rb_define_module_function(mDCL, "chngi", dcl_chngi, 4);
    rb_define_module_function(mDCL, "chngr", dcl_chngr, 4);
}
