#
# jump1.rb
#   $Id: jump1.rb,v 1.1 2000/11/18 18:57:41 keiko Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include NMath

nmax = 400
dt = 2*PI/(nmax-1)

x = NArray.sfloat(nmax)
y = NArray.sfloat(nmax)

#-- data 1 ----
dt = 2*PI/(nmax-1)
t = NArray.sfloat(nmax).indgen! * dt
x = 5*sin(4*t)
y = 5*cos(5*t)

#-- graph 1 ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::grswnd(-6.0, 6.0, -6.0, 6.0)
DCL::grsvpt(0.15, 0.45, 0.65, 0.95)
DCL::grstrn( 1 )
DCL::grstrf

DCL::ussttl('X1', '', 'Y1', '')
DCL::usdaxs

DCL::uulin(x, y)

#-- data 2 ----
iseed = 0

x[0] = 2*(rand(iseed)-0.5)
y[nmax-1] = x[0]

for n in 1..nmax-1
  x[n] = 2*(rand(iseed)-0.5)
  y[n-1] = x[n]
end

#-- graph 2 ----
DCL::grfig

DCL::grswnd(-1.1, 1.1, -1.1, 1.1)
DCL::grsvpt(0.15, 0.95, 0.1, 0.5)
DCL::grstrn(1)
DCL::grstrf

DCL::ussttl('X2-TITLE', '', 'Y2-TITLE', '')
DCL::usdaxs

DCL::uumrk(x, y)

DCL::grcls

